/*
 * Decompiled with CFR 0.152.
 */
package dev.uraneptus.refinedmosaicblocks.content;

import com.mojang.serialization.MapCodec;
import dev.uraneptus.refinedmosaicblocks.content.MosaicColor;
import dev.uraneptus.refinedmosaicblocks.content.RMBRegistries;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class MosaicBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<MosaicBlock> CODEC = MosaicBlock.simpleCodec(MosaicBlock::new);
    public static final EnumProperty<MosaicColor> COLOR = EnumProperty.create((String)"color", MosaicColor.class);

    public MosaicBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(COLOR, (Comparable)((Object)MosaicColor.WHITE)));
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (pState.hasProperty(COLOR) && !pLevel.isClientSide()) {
            ItemStack itemInHand = pPlayer.getItemInHand(pHand);
            MosaicColor currentColor = (MosaicColor)((Object)pState.getValue(COLOR));
            if (MosaicColor.isDyeItem(itemInHand)) {
                if (!currentColor.isSameDye(itemInHand.getItem())) {
                    MosaicColor itemColor = MosaicColor.getColorFromItem(itemInHand);
                    pLevel.setBlock(pPos, (BlockState)pState.setValue(COLOR, (Comparable)((Object)itemColor)), 3);
                    if (pLevel.random.nextFloat() < (float)pLevel.getGameRules().getInt(RMBRegistries.DYE_CONSUME_CHANCE) / 100.0f && !pPlayer.isCreative()) {
                        pPlayer.getItemInHand(pHand).shrink(1);
                        pLevel.playSound(null, pPos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 0.5f, 1.0f);
                        for (int i = 0; i < 7; ++i) {
                            double d0 = pLevel.random.nextGaussian() * 0.02;
                            double d1 = pLevel.random.nextGaussian() * 0.02;
                            double d2 = pLevel.random.nextGaussian() * 0.02;
                            ((ServerLevel)pLevel).sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pPos.getX() + 0.5, (double)pPos.getY() + 1.2, (double)pPos.getZ() + 0.5, 1, d0, d1, d2, 0.0);
                        }
                    } else {
                        pLevel.playSound(null, pPos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 0.5f, 1.0f);
                    }
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (itemInHand.isEmpty() && pPlayer.isShiftKeyDown()) {
                Direction direction = (Direction)pState.getValue((Property)FACING);
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)FACING, (Comparable)direction.getClockWise()), 3);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    protected BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (pState.hasProperty(COLOR) && !pLevel.isClientSide() && pNeighborState.getBlock() == Blocks.WET_SPONGE) {
            return (BlockState)pState.setValue(COLOR, (Comparable)((Object)MosaicColor.WHITE));
        }
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, COLOR});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        if (pBlockState.hasProperty(COLOR)) {
            return ((MosaicColor)((Object)pBlockState.getValue(COLOR))).getIndexNumber();
        }
        return 0;
    }

    public static Iterable<MosaicBlock> getMosaicBlocks() {
        return BuiltInRegistries.BLOCK.stream().filter(block -> "refinedmosaicblocks".equals(BuiltInRegistries.BLOCK.getKey(block).getNamespace()) && block instanceof MosaicBlock).map(block -> (MosaicBlock)((Object)block)).collect(Collectors.toList());
    }
}

