/*
 * Decompiled with CFR 0.152.
 */
package dev.uraneptus.refinedmosaicblocks.data;

import dev.uraneptus.refinedmosaicblocks.RMBConstants;
import dev.uraneptus.refinedmosaicblocks.content.MosaicBlock;
import dev.uraneptus.refinedmosaicblocks.content.MosaicColor;
import dev.uraneptus.refinedmosaicblocks.content.RMBRegistries;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class RMBBlockStateProvider
extends BlockStateProvider {
    public RMBBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "refinedmosaicblocks", exFileHelper);
    }

    protected void registerStatesAndModels() {
        MosaicBlock.getMosaicBlocks().forEach(this::patternedMosaicBlock);
        this.mosaicBlock(RMBRegistries.MOSAIC_BLOCK.get());
    }

    private void patternedMosaicBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(blockState -> {
            String pattern = RMBBlockStateProvider.name(block).replace("_mosaic_block", "");
            MosaicColor color = (MosaicColor)((Object)((Object)blockState.getValue(MosaicBlock.COLOR)));
            String name = color.name().toLowerCase() + "_" + pattern;
            ModelBuilder modelFile = ((BlockModelBuilder)this.models().withExistingParent(name, RMBBlockStateProvider.name(Blocks.WHITE_GLAZED_TERRACOTTA))).texture("pattern", RMBBlockStateProvider.modBlockLocation(name));
            return ConfiguredModel.builder().modelFile((ModelFile)modelFile).rotationY(((int)((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180) % 360).build();
        });
    }

    private void mosaicBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(blockState -> {
            ModelFile[] files = new ModelFile[4];
            for (int i = 0; i <= 3; ++i) {
                int rotNum = 90 * i;
                Object suffix = rotNum != 0 ? "_" + rotNum : "";
                ModelBuilder modelFile = ((BlockModelBuilder)this.models().withExistingParent(RMBBlockStateProvider.name(block) + (String)suffix, RMBBlockStateProvider.name(Blocks.WHITE_GLAZED_TERRACOTTA))).texture("pattern", RMBBlockStateProvider.modBlockLocation(RMBBlockStateProvider.name(block) + (String)suffix));
                files[i] = modelFile;
            }
            return ConfiguredModel.builder().modelFile(files[0]).nextModel().modelFile(files[1]).nextModel().modelFile(files[2]).nextModel().modelFile(files[3]).build();
        });
    }

    public static String name(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }

    public static ResourceLocation modBlockLocation(String path) {
        return RMBConstants.modPrefix("block/" + path);
    }
}

