/*
 * Decompiled with CFR 0.152.
 */
package com.exemplo.ecobalance;

import com.exemplo.ecobalance.EcoCommands;
import com.exemplo.ecobalance.EcoConfig;
import com.exemplo.ecobalance.EcoState;
import com.exemplo.ecobalance.EcoText;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EcoEvents {
    private final Map<UUID, Integer> logCounter = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> saplingCounter = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> animalKillCounter = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> deepMiningCounter = new HashMap<UUID, Integer>();
    private final Map<ResourceLocation, Long> sterileBiomes = new HashMap<ResourceLocation, Long>();

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        EcoCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void sendThoughtMessage(ServerPlayer player, String messageKey, ChatFormatting color) {
        String translatedText = EcoText.get(player.m_20148_(), messageKey);
        player.m_213846_((Component)Component.m_237113_((String)("*" + translatedText + "*")).m_130940_(color));
    }

    @SubscribeEvent
    public void onFlintAndSteel(PlayerInteractEvent.RightClickBlock event) {
        Player player;
        if (!event.getLevel().f_46443_ && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (event.getItemStack().m_150930_(Items.f_42409_) && event.getLevel().m_8055_(event.getPos()).m_204336_(BlockTags.f_13106_)) {
                int penalty = (Integer)EcoConfig.FIRE_KARMA_PENALTY.get();
                if (EcoState.isHardcore) {
                    penalty *= 2;
                }
                EcoState.addKarma(player2.m_20148_(), -penalty);
                this.sendThoughtMessage(player2, "fire", ChatFormatting.RED);
            }
        }
    }

    @SubscribeEvent
    public void onDeepMining(BlockEvent.BreakEvent event) {
        if (!event.getPlayer().m_9236_().m_5776_() && event.getPos().m_123342_() < 0) {
            ServerPlayer player = (ServerPlayer)event.getPlayer();
            UUID id = player.m_20148_();
            int count = this.deepMiningCounter.getOrDefault(id, 0) + 1;
            this.deepMiningCounter.put(id, count);
            if (count >= (Integer)EcoConfig.DEEP_MINING_THRESHOLD.get()) {
                int duration = EcoState.isHardcore ? 2400 : 1200;
                int amplifier = EcoState.isHardcore ? 2 : 0;
                this.sendThoughtMessage(player, "mining", ChatFormatting.DARK_GRAY);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, duration, amplifier));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
                this.deepMiningCounter.put(id, 0);
            }
        }
        if (event.getState().m_204336_(BlockTags.f_13106_)) {
            this.handleLogBreak((ServerPlayer)event.getPlayer());
        }
    }

    private void handleLogBreak(ServerPlayer player) {
        UUID id = player.m_20148_();
        int count = this.logCounter.getOrDefault(id, 0) + 1;
        if (count >= (Integer)EcoConfig.LOGS_TO_BREAK.get()) {
            int duration = (Integer)EcoConfig.DARKNESS_SECONDS.get() * 20;
            if (EcoState.isHardcore) {
                duration *= 2;
            }
            int amplifier = EcoState.isHardcore ? 1 : 0;
            this.sendThoughtMessage(player, "logs", ChatFormatting.DARK_RED);
            player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, duration, amplifier));
            EcoState.addKarma(id, -10);
            count = 0;
        }
        this.logCounter.put(id, count);
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (!event.getLevel().m_5776_() && event.getPlacedBlock().m_204336_(BlockTags.f_13104_)) {
                UUID id = player.m_20148_();
                int count = this.saplingCounter.getOrDefault(id, 0) + 1;
                if (count >= (Integer)EcoConfig.SAPLINGS_TO_PLANT.get()) {
                    int duration = (Integer)EcoConfig.REGEN_SECONDS.get() * 20;
                    if (EcoState.isHardcore) {
                        duration *= 2;
                    }
                    this.sendThoughtMessage(player, "sapling", ChatFormatting.GREEN);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, duration, 0));
                    EcoState.addKarma(id, 5);
                    count = 0;
                }
                this.saplingCounter.put(id, count);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (event.getEntity() instanceof Animal) {
                UUID id = player.m_20148_();
                int kills = this.animalKillCounter.getOrDefault(id, 0) + 1;
                EcoState.addKarma(id, -2);
                if (kills >= (Integer)EcoConfig.ANIMAL_KILLS.get()) {
                    int duration = (Integer)EcoConfig.HUNGER_SECONDS.get() * 20;
                    if (EcoState.isHardcore) {
                        duration *= 2;
                    }
                    int amplifier = EcoState.isHardcore ? 2 : 0;
                    this.sendThoughtMessage(player, "death", ChatFormatting.DARK_PURPLE);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, duration, amplifier));
                    BlockPos pos = player.m_20183_();
                    Holder biomeHolder = player.m_9236_().m_204166_(pos);
                    biomeHolder.m_203543_().ifPresent(key -> {
                        long sterileTime = (long)((Integer)EcoConfig.BIOME_STERILE_MINUTES.get() * 60) * 1000L;
                        if (EcoState.isHardcore) {
                            sterileTime *= 2L;
                        }
                        ResourceLocation biomeId = key.m_135782_();
                        this.sterileBiomes.put(biomeId, System.currentTimeMillis() + sterileTime);
                        System.out.println("ECOBALANCE: Bioma " + biomeId + " esterilizado.");
                    });
                    kills = 0;
                }
                this.animalKillCounter.put(id, kills);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().f_46443_) {
            ServerPlayer player = (ServerPlayer)event.player;
            if (player.f_19797_ % 100 == 0) {
                this.checkSanctuary(player);
                this.applyKarmaEffects(player);
            }
        }
    }

    private void checkSanctuary(ServerPlayer player) {
        BlockPos pos = player.m_20183_();
        int flowersCount = 0;
        int radius = 5;
        for (BlockPos p : BlockPos.m_121940_((BlockPos)pos.m_7918_(-radius, -1, -radius), (BlockPos)pos.m_7918_(radius, 2, radius))) {
            BlockState state = player.m_9236_().m_8055_(p);
            if (!state.m_204336_(BlockTags.f_13041_) && !state.m_204336_(BlockTags.f_13040_)) continue;
            ++flowersCount;
        }
        if (flowersCount >= (Integer)EcoConfig.SANCTUARY_BLOCK_COUNT.get()) {
            if (!player.m_21023_(MobEffects.f_19605_)) {
                this.sendThoughtMessage(player, "sanctuary", ChatFormatting.LIGHT_PURPLE);
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 120, 0));
        }
    }

    private void applyKarmaEffects(ServerPlayer player) {
        int karma = EcoState.getKarma(player.m_20148_());
        if (karma > 50) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 200, 0, true, false));
        } else if (karma < -50) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19590_, 200, 0, true, false));
            if (!player.m_9236_().m_46461_() && player.m_9236_().f_46441_.m_188501_() < 0.05f) {
                this.spawnPunishmentPhantom(player);
            }
        }
    }

    @SubscribeEvent
    public void onCheckSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (event.getEntity() instanceof Animal) {
            BlockPos pos = new BlockPos((int)event.getX(), (int)event.getY(), (int)event.getZ());
            event.getLevel().m_204166_(pos).m_203543_().ifPresent(key -> {
                ResourceLocation biomeId = key.m_135782_();
                if (this.sterileBiomes.containsKey(biomeId)) {
                    long expiration = this.sterileBiomes.get(biomeId);
                    if (System.currentTimeMillis() < expiration) {
                        event.setResult(Event.Result.DENY);
                        event.setSpawnCancelled(true);
                    } else {
                        this.sterileBiomes.remove(biomeId);
                    }
                }
            });
        }
        if (event.getEntity() instanceof Monster && EcoState.globalKarma > 100 && event.getLevel().m_213780_().m_188501_() < 0.3f) {
            event.setResult(Event.Result.DENY);
            event.setSpawnCancelled(true);
        }
    }

    @SubscribeEvent
    public void onLevelTick(TickEvent.LevelTickEvent event) {
        ServerLevel level;
        Level level2;
        if (event.phase == TickEvent.Phase.END && (level2 = event.level) instanceof ServerLevel && (level = (ServerLevel)level2).m_46467_() % 400L == 0L) {
            if (EcoState.globalKarma < -100) {
                if (level.m_46471_()) {
                    level.m_46734_(0.0f);
                }
            } else if (EcoState.globalKarma > 100 && !level.m_46471_() && level.f_46441_.m_188501_() < 0.1f) {
                level.m_46734_(1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onCropGrow(BlockEvent.CropGrowEvent.Pre event) {
        if (EcoState.globalKarma > 50 && event.getLevel().m_213780_().m_188501_() < 0.3f) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    private void spawnPunishmentPhantom(ServerPlayer player) {
        Phantom phantom = new Phantom(EntityType.f_20509_, player.m_9236_());
        phantom.m_6027_(player.m_20185_(), player.m_20186_() + 10.0, player.m_20189_());
        player.m_9236_().m_7967_((Entity)phantom);
    }
}

