/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.client.model;

import com.faboslav.variantsandventures.common.client.render.entity.state.MurkEntityRenderState;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.ArmorModelSet;
import net.minecraft.client.renderer.entity.state.SkeletonRenderState;

public class MurkEntityModel
extends SkeletonModel<MurkEntityRenderState> {
    private final ModelPart corals;

    public MurkEntityModel(ModelPart root) {
        super(root);
        this.corals = root.getChild("head").getChild("corals");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition modelData = MurkEntityModel.createDefaultMesh(CubeDeformation.NONE);
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    private static MeshDefinition createDefaultMesh(CubeDeformation cubeDeformation) {
        MeshDefinition modelData = HumanoidModel.createMesh((CubeDeformation)cubeDeformation, (float)0.0f);
        PartDefinition root = modelData.getRoot();
        SkeletonModel.createDefaultSkeletonMesh((PartDefinition)root);
        PartDefinition head = root.getChild("head");
        PartDefinition corals = head.addOrReplaceChild("corals", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        corals.addOrReplaceChild("coral1", CubeListBuilder.create().texOffs(0, 36).addBox(-1.0f, -15.0f, -4.0f, 9.0f, 9.0f, 0.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        corals.addOrReplaceChild("coral2", CubeListBuilder.create().texOffs(0, 32).addBox(-1.0f, -6.0f, 5.0f, 6.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        return modelData;
    }

    public void setupAnim(MurkEntityRenderState murkRenderState) {
        this.corals.visible = !murkRenderState.sheared;
        super.setupAnim((SkeletonRenderState)murkRenderState);
    }

    public static ArmorModelSet<LayerDefinition> createArmorLayers() {
        ArmorModelSet mesh = HumanoidModel.createArmorMeshSet((CubeDeformation)LayerDefinitions.INNER_ARMOR_DEFORMATION, (CubeDeformation)LayerDefinitions.OUTER_ARMOR_DEFORMATION);
        return mesh.map(meshDefinition -> LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64));
    }
}

