/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.entity.mob;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import com.faboslav.variantsandventures.common.entity.ai.goal.LeaveWaterGoal;
import com.faboslav.variantsandventures.common.entity.ai.goal.TargetAboveWaterGoal;
import com.faboslav.variantsandventures.common.entity.ai.goal.WanderAroundOnSurfaceGoal;
import com.faboslav.variantsandventures.common.init.VariantsAndVenturesSoundEvents;
import com.faboslav.variantsandventures.common.util.AdvancementHelper;
import com.faboslav.variantsandventures.common.versions.VersionedBlockPathType;
import com.faboslav.variantsandventures.common.versions.VersionedEntitySpawnReason;
import com.faboslav.variantsandventures.common.versions.VersionedInteractionResult;
import com.faboslav.variantsandventures.common.versions.VersionedNbt;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class MurkEntity
extends Skeleton
implements Shearable {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(MurkEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.defineId(MurkEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final String VARIANT_NBT_KEY = "Variant";
    public static final String SHEARED_NBT_KEY = "Sheared";
    private boolean targetingUnderwater;
    private final WaterBoundPathNavigation waterNavigation;
    private final GroundPathNavigation landNavigation;

    public MurkEntity(EntityType<? extends Skeleton> entityType, Level world) {
        super(entityType, world);
        this.moveControl = new MurkMoveControl(this, this);
        this.setPathfindingMalus(VersionedBlockPathType.WATER, 0.0f);
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, world);
        this.landNavigation = new GroundPathNavigation((Mob)this, world);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData entityData) {
        this.setVariant(Variant.getRandom(this.random));
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public static boolean canSpawn(EntityType<MurkEntity> type, ServerLevelAccessor world, EntitySpawnReason spawnReason, BlockPos pos, RandomSource random) {
        if (spawnReason == VersionedEntitySpawnReason.NATURAL) {
            return world.getFluidState(pos.below()).is(FluidTags.WATER) && MurkEntity.isValidSpawnDepth((LevelAccessor)world, pos) && random.nextInt(40) == 0;
        }
        return true;
    }

    private static boolean isValidSpawnDepth(LevelAccessor world, BlockPos pos) {
        return pos.getY() < world.getSeaLevel() - 5;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new WanderAroundOnSurfaceGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new LeaveWaterGoal(this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new TargetAboveWaterGoal(this, 1.0, this.level().getSeaLevel()));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, (livingEntity, serverLevel) -> this.canAttackTarget(livingEntity)));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Axolotl.class, true, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.BABY_ON_LAND_SELECTOR));
        super.registerGoals();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
        builder.define(SHEARED, (Object)false);
    }

    public void addAdditionalSaveData(ValueOutput nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt(VARIANT_NBT_KEY, this.getVariant().getId());
        nbt.putBoolean(SHEARED_NBT_KEY, this.isSheared());
    }

    public void readAdditionalSaveData(ValueInput nbt) {
        super.readAdditionalSaveData(nbt);
        this.setVariant(Variant.VARIANTS[VersionedNbt.getInt(nbt, VARIANT_NBT_KEY, Variant.PURPLE.ordinal())]);
        this.setSheared(VersionedNbt.getBoolean(nbt, SHEARED_NBT_KEY, false));
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public static AttributeSupplier.Builder createMurkAttributes() {
        return Skeleton.createAttributes().add(Attributes.MAX_HEALTH, 16.0);
    }

    protected SoundEvent getAmbientSound() {
        return this.isInWater() ? VariantsAndVenturesSoundEvents.ENTITY_MURK_AMBIENT_WATER.get() : VariantsAndVenturesSoundEvents.ENTITY_MURK_AMBIENT.get();
    }

    public void playAmbientSound() {
        SoundEvent soundEvent = this.getAmbientSound();
        if (soundEvent != null) {
            this.playSound(soundEvent, this.isInWater() ? 0.25f : this.getSoundVolume(), this.getVoicePitch());
        }
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return this.isInWater() ? VariantsAndVenturesSoundEvents.ENTITY_MURK_HURT_WATER.get() : VariantsAndVenturesSoundEvents.ENTITY_MURK_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return this.isInWater() ? VariantsAndVenturesSoundEvents.ENTITY_MURK_DEATH_WATER.get() : VariantsAndVenturesSoundEvents.ENTITY_MURK_DEATH.get();
    }

    protected void playStepSound(BlockPos blockPos, BlockState blockState) {
        this.playSound(this.isInWater() ? VariantsAndVenturesSoundEvents.ENTITY_MURK_STEP.get() : SoundEvents.SKELETON_STEP, 0.15f, 1.0f);
    }

    public void tick() {
        if (!VariantsAndVentures.getConfig().enableMurk) {
            this.discard();
        }
        super.tick();
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        ItemStack possibleBow = this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, (Item)Items.BOW));
        if (!possibleBow.is(Items.BOW)) {
            return;
        }
        ItemStack possibleProjectile = this.getProjectile(possibleBow);
        if (possibleProjectile == ItemStack.EMPTY) {
            return;
        }
        AbstractArrow abstractArrow = this.getArrow(possibleProjectile, velocity, possibleBow);
        double d = target.getX() - this.getX();
        double e = target.getY(0.3333333333333333) - abstractArrow.getY();
        double f = target.getZ() - this.getZ();
        double g = Math.sqrt(d * d + f * f);
        Level var15 = this.level();
        if (var15 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)var15;
            Projectile.spawnProjectileUsingShoot((Projectile)abstractArrow, (ServerLevel)serverLevel, (ItemStack)possibleProjectile, (double)d, (double)(e + g * (double)0.2f), (double)f, (float)1.6f, (float)(14 - serverLevel.getDifficulty().getId() * 4));
        }
        this.playSound(VariantsAndVenturesSoundEvents.ENTITY_MURK_ATTACK.get(), 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
    }

    public boolean isPushedByFluid() {
        return !this.isSwimming();
    }

    public boolean shouldDiscardFriction() {
        return this.isSwimming();
    }

    private boolean isTargetingUnderwater() {
        if (this.targetingUnderwater) {
            return true;
        }
        LivingEntity livingEntity = this.getTarget();
        return livingEntity != null && livingEntity.isInWater();
    }

    public void setTargetingUnderwater(boolean targetingUnderwater) {
        this.targetingUnderwater = targetingUnderwater;
    }

    public void travel(Vec3 movementInput) {
        if (this.isEffectiveAi() && this.isInWater() && this.isTargetingUnderwater()) {
            this.moveRelative(0.01f, movementInput);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(movementInput);
        }
    }

    public void updateSwimming() {
        if (!this.level().isClientSide()) {
            if (this.isEffectiveAi() && this.isInWater() && this.isTargetingUnderwater()) {
                this.navigation = this.waterNavigation;
                this.setSwimming(true);
            } else {
                this.navigation = this.landNavigation;
                this.setSwimming(false);
            }
        }
    }

    public boolean hasFinishedCurrentPath() {
        BlockPos blockPos;
        Path path = this.getNavigation().getPath();
        if (path != null && (blockPos = path.getTarget()) != null) {
            double d = this.distanceToSqr(blockPos.getX(), blockPos.getY(), blockPos.getZ());
            return d < 4.0;
        }
        return false;
    }

    public boolean isSheared() {
        return (Boolean)this.entityData.get(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.entityData.set(SHEARED, (Object)sheared);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.SHEARS) && this.readyForShearing()) {
            if (!this.level().isClientSide()) {
                this.shear((ServerLevel)this.level(), SoundSource.PLAYERS, itemStack);
                this.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                EquipmentSlot equipment = hand.asEquipmentSlot();
                itemStack.hurtAndBreak(1, (LivingEntity)player, equipment);
            }
            return VersionedInteractionResult.success((Entity)this);
        }
        return super.mobInteract(player, hand);
    }

    public void shear(ServerLevel level, SoundSource soundSource, ItemStack shears) {
        this.level().playSound(null, (Entity)this, VariantsAndVenturesSoundEvents.ENTITY_MURK_SHEAR.get(), soundSource, 1.0f, 1.0f);
        this.dropShearedItems(level, shears);
        this.setSheared(true);
    }

    private void dropShearedItems(ServerLevel level, ItemStack stack) {
        ResourceKey shearingLootTableResourceKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)VariantsAndVentures.makeID(String.format(Locale.ROOT, "shearing/murk_%s", this.getVariant().getName())));
        this.dropFromShearingLootTable(level, shearingLootTableResourceKey, stack, (serverLevel, itemStack) -> this.spawnAtLocation((ServerLevel)serverLevel, (ItemStack)itemStack, this.getBbHeight()));
    }

    public boolean readyForShearing() {
        return !this.isSheared() && this.isAlive();
    }

    public boolean isFreezeConverting() {
        return false;
    }

    public boolean isShaking() {
        return false;
    }

    protected void doFreezeConversion() {
    }

    public boolean canFreeze() {
        return false;
    }

    public void die(DamageSource damageSource) {
        super.die(damageSource);
        AdvancementHelper.triggerMonsterHunter(this.level(), damageSource);
    }

    public boolean canAttackTarget(@Nullable LivingEntity target) {
        if (target != null) {
            boolean isDay = this.level().isBrightOutside();
            return !isDay || target.isInWater();
        }
        return false;
    }

    private void setNavigation(PathNavigation navigation) {
        this.navigation = navigation;
    }

    public void setLandNavigation() {
        this.navigation = this.landNavigation;
    }

    public void setWaterNavigation() {
        this.navigation = this.waterNavigation;
    }

    public Variant getVariant() {
        return Variant.VARIANTS[(Integer)this.entityData.get(VARIANT)];
    }

    private void setVariant(Variant variant) {
        this.entityData.set(VARIANT, (Object)variant.getId());
    }

    private final class MurkMoveControl
    extends MoveControl {
        private final MurkEntity murk;

        public MurkMoveControl(MurkEntity murkEntity, MurkEntity murk) {
            super((Mob)murk);
            this.murk = murk;
        }

        public void tick() {
            LivingEntity livingEntity = this.murk.getTarget();
            if (this.murk.isTargetingUnderwater() && this.murk.isInWater()) {
                if (livingEntity != null && livingEntity.getY() > this.murk.getY() || this.murk.targetingUnderwater) {
                    this.murk.setDeltaMovement(this.murk.getDeltaMovement().add(0.0, 0.002, 0.0));
                }
                if (this.operation != MoveControl.Operation.MOVE_TO || this.murk.getNavigation().isDone()) {
                    this.murk.setSpeed(0.0f);
                    return;
                }
                double d = this.wantedX - this.murk.getX();
                double e = this.wantedY - this.murk.getY();
                double f = this.wantedZ - this.murk.getZ();
                double g = Math.sqrt(d * d + e * e + f * f);
                e /= g;
                float h = (float)(Mth.atan2((double)f, (double)d) * 57.2957763671875) - 90.0f;
                this.murk.setYRot(this.rotlerp(this.murk.getYRot(), h, 90.0f));
                this.murk.yBodyRot = this.murk.getYRot();
                float i = (float)(this.speedModifier * this.murk.getAttributeValue(Attributes.MOVEMENT_SPEED));
                float j = Mth.lerp((float)0.125f, (float)this.murk.getSpeed(), (float)i);
                this.murk.setSpeed(j);
                this.murk.setDeltaMovement(this.murk.getDeltaMovement().add((double)j * d * 0.005, (double)j * e * 0.1, (double)j * f * 0.005));
            } else {
                if (!this.murk.onGround()) {
                    this.murk.setDeltaMovement(this.murk.getDeltaMovement().add(0.0, -0.008, 0.0));
                }
                super.tick();
            }
        }
    }

    public static enum Variant {
        PURPLE(0, "purple"),
        RED(1, "red"),
        YELLOW(2, "yellow");

        public static final Variant[] VARIANTS;
        private final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        private static Variant getRandom(RandomSource random) {
            return (Variant)((Object)Util.getRandom((Object[])((Variant[])Arrays.stream(VARIANTS).toArray(Variant[]::new)), (RandomSource)random));
        }

        static {
            VARIANTS = (Variant[])Arrays.stream(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }
}

