/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.init;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import com.faboslav.variantsandventures.common.config.VariantsAndVenturesConfig;
import com.faboslav.variantsandventures.common.mixin.JigsawStructureAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5434;
import net.minecraft.class_6005;
import net.minecraft.class_6008;
import net.minecraft.class_7924;
import net.minecraft.class_8889;
import net.minecraft.class_8892;
import net.minecraft.class_8893;
import net.minecraft.server.MinecraftServer;

public final class VariantsAndVenturesStructurePoolAliases {
    public static void init(MinecraftServer server) {
        VariantsAndVenturesStructurePoolAliases.updateTrialChamberSpawners(server);
    }

    private static void updateTrialChamberSpawners(MinecraftServer server) {
        VariantsAndVenturesConfig config = VariantsAndVentures.getConfig();
        class_2378 structureRegistry = server.method_30611().method_30530(class_7924.field_41246);
        class_5434 structure = (class_5434)structureRegistry.method_63535(VariantsAndVentures.makeNamespacedId("minecraft:trial_chambers"));
        JigsawStructureAccessor structureAccessor = (JigsawStructureAccessor)structure;
        List<class_8889> originalPoolAliasBindings = structureAccessor.getPoolAliasBindings();
        ArrayList<class_8889> newPoolAliasBindings = new ArrayList<class_8889>();
        for (class_8889 originalPoolAliasBinding : originalPoolAliasBindings) {
            if (originalPoolAliasBinding instanceof class_8893) {
                class_8893 randomGroupStructurePoolAliasBinding = (class_8893)originalPoolAliasBinding;
                class_6005.class_6006 dataPoolBuilder = class_6005.method_34971();
                List groups = randomGroupStructurePoolAliasBinding.comp_2007().method_34994();
                for (class_6008.class_6010 group : groups) {
                    dataPoolBuilder.method_54453((Object)((List)group.comp_2542()));
                }
                if (config.enableMurkSpawnersInTrialChambers) {
                    dataPoolBuilder.method_54453(List.of(class_8889.method_54508((String)"trial_chambers/spawner/contents/ranged", (String)"trial_chambers/spawner/ranged/murk"), class_8889.method_54508((String)"trial_chambers/spawner/contents/slow_ranged", (String)"trial_chambers/spawner/slow_ranged/murk")));
                }
                if (config.enableVerdantSpawnersInTrialChambers) {
                    dataPoolBuilder.method_54453(List.of(class_8889.method_54508((String)"trial_chambers/spawner/contents/ranged", (String)"trial_chambers/spawner/ranged/verdant"), class_8889.method_54508((String)"trial_chambers/spawner/contents/slow_ranged", (String)"trial_chambers/spawner/slow_ranged/verdant")));
                }
                class_8893 newRandomGroupStructurePoolAliasBinding = class_8889.method_54506((class_6005)dataPoolBuilder.method_34974());
                newPoolAliasBindings.add((class_8889)newRandomGroupStructurePoolAliasBinding);
                continue;
            }
            if (originalPoolAliasBinding instanceof class_8892) {
                class_8892 newRandomStructurePoolAliasBinding;
                class_8892 randomStructurePoolAliasBinding = (class_8892)originalPoolAliasBinding;
                String alias = randomStructurePoolAliasBinding.comp_2005().method_29177().method_12832();
                List<class_5321> registryKeys = randomStructurePoolAliasBinding.method_54499().toList();
                if (Objects.equals(alias, "trial_chambers/spawner/contents/melee")) {
                    class_6005.class_6006 dataPoolBuilder = class_6005.method_34971();
                    registryKeys.forEach(registryKey -> {
                        String value = registryKey.method_29177().method_12832();
                        dataPoolBuilder.method_54453((Object)value);
                    });
                    if (config.enableGelidSpawnersInTrialChambers) {
                        dataPoolBuilder.method_54453((Object)"trial_chambers/spawner/melee/gelid");
                    }
                    if (config.enableThicketSpawnersInTrialChambers) {
                        dataPoolBuilder.method_54453((Object)"trial_chambers/spawner/melee/thicket");
                    }
                    newRandomStructurePoolAliasBinding = class_8889.method_54507((String)alias, (class_6005)dataPoolBuilder.method_34974());
                } else {
                    newRandomStructurePoolAliasBinding = randomStructurePoolAliasBinding;
                }
                newPoolAliasBindings.add((class_8889)newRandomStructurePoolAliasBinding);
                continue;
            }
            newPoolAliasBindings.add(originalPoolAliasBinding);
        }
        structureAccessor.setPoolAliasBindings(newPoolAliasBindings);
    }

    private VariantsAndVenturesStructurePoolAliases() {
    }
}

