/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.entity.event;

import com.faboslav.variantsandventures.common.events.entity.EntitySpawnEvent;
import com.faboslav.variantsandventures.common.mixin.MobAccessor;
import com.faboslav.variantsandventures.common.versions.VersionedEntitySpawnReason;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;

public final class OnEntitySpawn {
    public static boolean handleOnEntitySpawn(EntitySpawnEvent event, EntityType<? extends Mob> entityTypeToReplace, EntityType<? extends Mob> entityTypeToSpawn, boolean spawnCondition, double spawnChanceCondition, int minimumSpawnYLevel, TagKey<Biome> biomeTagKey) {
        Mob entity = event.entity();
        RandomSource random = entity.m_217043_();
        if (event.spawnReason() == VersionedEntitySpawnReason.NATURAL || event.spawnReason() == VersionedEntitySpawnReason.CHUNK_GENERATION || event.spawnReason() == VersionedEntitySpawnReason.STRUCTURE) {
            if (entity.m_6095_() != entityTypeToReplace) {
                return false;
            }
            if (!spawnCondition || (double)random.m_188501_() >= spawnChanceCondition || entity.m_20183_().m_123342_() < minimumSpawnYLevel) {
                return false;
            }
            LevelAccessor world = event.worldAccess();
            Holder biome = world.m_204166_(entity.m_20183_());
            if (!biome.m_203656_(biomeTagKey)) {
                return false;
            }
            Mob entityToSpawn = (Mob)entityTypeToSpawn.m_20615_(entity.m_9236_());
            if (entityToSpawn == null) {
                return false;
            }
            entityToSpawn.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entityToSpawn.m_217043_().m_188501_() * 360.0f, 0.0f);
            entityToSpawn.m_20359_((Entity)entity);
            entityToSpawn.f_20884_ = entity.f_20884_;
            entityToSpawn.f_20883_ = entity.f_20883_;
            entityToSpawn.f_20886_ = entity.f_20886_;
            entityToSpawn.f_20885_ = entity.f_20885_;
            entityToSpawn.m_6863_(entity.m_6162_());
            entityToSpawn.m_21557_(entity.m_21525_());
            entityToSpawn.m_20331_(entity.m_20147_());
            if (entity.m_8077_()) {
                entityToSpawn.m_6593_(entity.m_7770_());
                entityToSpawn.m_20340_(entity.m_20151_());
            }
            if (entity.m_21532_()) {
                entityToSpawn.m_21530_();
            }
            entityToSpawn.m_21553_(entity.m_21531_());
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                ItemStack itemStack = entity.m_6844_(equipmentSlot);
                if (itemStack.m_41619_()) continue;
                entityToSpawn.m_8061_(equipmentSlot, itemStack.m_278832_());
                float dropChance = ((MobAccessor)entity).variantsandventures$getEquipmentDropChance(equipmentSlot);
                entityToSpawn.m_21409_(equipmentSlot, dropChance);
            }
            entityToSpawn.m_6518_((ServerLevelAccessor)world, ((ServerLevelAccessor)world).m_6436_(entity.m_20183_()), event.spawnReason(), null, null);
            boolean spawnResult = world.m_7967_((Entity)entityToSpawn);
            if (!spawnResult) {
                entity.m_146870_();
                return false;
            }
            return true;
        }
        return false;
    }
}

