/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nimble.portable_blueprints.Events.BlueprintEvent;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.robautile.Operazioni;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="portable_blueprints", value={Dist.CLIENT})
public class BlueprintsPreviewMethods {
    public static List<BlueprintPreviewData> ConvertStructureToTextureDataInput = new ArrayList<BlueprintPreviewData>();
    public static boolean hideAllHud = false;
    private static boolean waitForNextIconGeneration = false;
    private static boolean inRenderingForIcon = false;
    public static Map<String, ResourceLocation> MapIconsRL = new HashMap<String, ResourceLocation>();

    public static boolean isBlockEntity(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof EntityBlock) {
            EntityBlock entityBlock = (EntityBlock)block;
            try {
                BlockEntity be = entityBlock.m_142194_(BlockPos.f_121853_, state);
                if (be == null) {
                    return false;
                }
                BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(be);
                return renderer != null;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isLiquidBlock(BlockState state) {
        if (state.m_60734_() instanceof LiquidBlock) {
            return !state.m_60819_().m_76178_();
        }
        return false;
    }

    public static NativeImage cropCentered(NativeImage original, float percent) {
        int width = original.m_84982_();
        int height = original.m_85084_();
        int cropSize = (int)((float)Math.min(width, height) * percent);
        int startX = width / 2 - cropSize / 2;
        int startY = height / 2 - cropSize / 2;
        NativeImage cropped = new NativeImage(cropSize, cropSize, false);
        for (int x = 0; x < cropSize; ++x) {
            for (int y = 0; y < cropSize; ++y) {
                int pixel = original.m_84985_(startX + x, startY + y);
                cropped.m_84988_(x, y, pixel);
            }
        }
        return cropped;
    }

    public static NativeImage scale(NativeImage original, int targetWidth, int targetHeight) {
        NativeImage scaled = new NativeImage(targetWidth, targetHeight, false);
        int originalWidth = original.m_84982_();
        int originalHeight = original.m_85084_();
        for (int x = 0; x < targetWidth; ++x) {
            for (int y = 0; y < targetHeight; ++y) {
                int srcX = x * originalWidth / targetWidth;
                int srcY = y * originalHeight / targetHeight;
                int pixel = original.m_84985_(srcX, srcY);
                scaled.m_84988_(x, y, pixel);
            }
        }
        return scaled;
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Pre event) {
        if (hideAllHud) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onScreenRender(ScreenEvent.Render.Pre event) {
        if (hideAllHud && event.getScreen() == Minecraft.m_91087_().f_91080_) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderPlayer(RenderPlayerEvent.Pre event) {
    }

    @SubscribeEvent
    public static void renderStage(RenderLevelStageEvent event) {
        Vec3 lookVec;
        if (!hideAllHud || ConvertStructureToTextureDataInput.isEmpty()) {
            return;
        }
        BlueprintPreviewData bpd = ConvertStructureToTextureDataInput.get(0);
        PoseStack poseStack = event.getPoseStack();
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        float yaw = camera.m_90590_();
        float pitch = camera.m_90589_();
        if (BlueprintPreviewData.AllUsedStage.contains(event.getStage())) {
            float r = 0.18431373f;
            float g = 0.21176471f;
            float b = 0.2509804f;
            Vec3 _lookVec = Minecraft.m_91087_().f_91074_.m_20154_();
            poseStack.m_85836_();
            poseStack.m_85837_(_lookVec.f_82479_, _lookVec.f_82480_, _lookVec.f_82481_);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yaw));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-pitch));
            Tesselator tess = Tesselator.m_85913_();
            BufferBuilder buf = tess.m_85915_();
            buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            float size = 3.0f;
            buf.m_252986_(poseStack.m_85850_().m_252922_(), -size, -size, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), size, -size, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), size, size, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), -size, size, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
            RenderSystem.setShader(GameRenderer::m_172811_);
            RenderSystem.enablePolygonOffset();
            RenderSystem.polygonOffset((float)-1.0f, (float)-1900000.0f);
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
            RenderSystem.disablePolygonOffset();
            poseStack.m_85849_();
        }
        Vec3 targetPos = lookVec = Minecraft.m_91087_().f_91074_.m_20154_();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252880_(-0.5f * ((float)bpd.visualizeBlueprintDatas.lunghezzaX / 20.0f), -23.5f * ((float)bpd.visualizeBlueprintDatas.altezza / 46.0f), Math.max(15.0f, 50.0f * ((float)bpd.visualizeBlueprintDatas.altezza / 46.0f)));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-22.5f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-45.0f));
        poseStack.m_85836_();
        RenderSystem.enablePolygonOffset();
        RenderSystem.polygonOffset((float)-1.0f, (float)-2900000.0f);
        bpd.renderStructureCustomPosestack(poseStack, event.getProjectionMatrix(), event.getStage(), Vec3.f_82478_, true);
        RenderSystem.disablePolygonOffset();
        poseStack.m_85849_();
        poseStack.m_85849_();
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES) && !inRenderingForIcon) {
            inRenderingForIcon = true;
        }
    }

    public static class BlueprintPreviewData {
        public static final List<RenderLevelStageEvent.Stage> AllUsedStage = List.of(RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS, RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS, RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS);
        private static final Map<RenderLevelStageEvent.Stage, List<RenderType>> STAGE_RENDER_TYPES = Map.of(RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS, List.of(RenderType.m_110451_(), RenderType.m_110463_(), RenderType.m_110457_()), RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS, List.of(RenderType.m_110466_()));
        private static final int MAX_BLOCKS_FOR_Time = 1000;
        private ScheduledExecutorService executor = null;
        private boolean datiVertexPronti = false;
        private final Map<RenderType, List<Tuple<BlockPos, BlockState>>> datiBlocchiRender = new HashMap<RenderType, List<Tuple<BlockPos, BlockState>>>();
        private final List<Tuple<BlockPos, BlockState>> datiRenderLiquid = new ArrayList<Tuple<BlockPos, BlockState>>();
        public Vec3i lunghezza = Vec3i.f_123288_;
        public boolean isDatiVertexPronti = false;
        private final Map<RenderType, List<VertexBuffer>> vertexBuffers = new HashMap<RenderType, List<VertexBuffer>>();
        private final List<Tuple<BlockPos, VertexBuffer>> vertexBuffersLiquids = new ArrayList<Tuple<BlockPos, VertexBuffer>>();
        private final List<Tuple<BlockPos, BlockState>> ListaBlocchiSingleRender = new ArrayList<Tuple<BlockPos, BlockState>>();
        private final Blueprint.BlueprintDatas visualizeBlueprintDatas;
        public ResourceLocation iconTexture;
        private boolean inCreazioneIcon = false;

        public BlueprintPreviewData(Blueprint.BlueprintDatas visualizeBlueprintDatas) {
            this.visualizeBlueprintDatas = visualizeBlueprintDatas;
        }

        public void cleanupStructureData() {
            for (RenderType renderType : this.vertexBuffers.keySet()) {
                for (VertexBuffer vertex : this.vertexBuffers.get(renderType)) {
                    vertex.close();
                }
            }
            this.vertexBuffers.clear();
            this.vertexBuffersLiquids.clear();
            this.ListaBlocchiSingleRender.clear();
            this.lunghezza = Vec3i.f_123288_;
            if (this.executor != null && !this.executor.isShutdown()) {
                this.executor.shutdownNow();
                this.executor = null;
            }
            this.datiVertexPronti = false;
            this.isDatiVertexPronti = false;
        }

        public void prepareData(CompoundTag nbt_blueprint_item) {
            if (Minecraft.m_91087_().f_91073_ == null) {
                return;
            }
            System.out.println("p1");
            this.cleanupStructureData();
            if (this.executor != null) {
                this.executor.shutdownNow();
            }
            this.executor = Executors.newSingleThreadScheduledExecutor();
            this.executor.schedule(() -> {
                try {
                    PoseStack poseStack = new PoseStack();
                    poseStack.m_85836_();
                    System.out.println("p2");
                    try {
                        Blueprint.BlueprintDatas schem = this.visualizeBlueprintDatas;
                        Minecraft mc = Minecraft.m_91087_();
                        BlockRenderDispatcher dispatcher = mc.m_91289_();
                        this.datiBlocchiRender.clear();
                        this.datiRenderLiquid.clear();
                        this.ListaBlocchiSingleRender.clear();
                        if (nbt_blueprint_item != null) {
                            if (nbt_blueprint_item.m_128448_("rotateValue") != 0) {
                                schem = schem.rotate(nbt_blueprint_item.m_128448_("rotateValue"));
                            }
                            if (nbt_blueprint_item.m_128471_("mirrorX") || nbt_blueprint_item.m_128471_("mirrorY") || nbt_blueprint_item.m_128471_("mirrorZ")) {
                                schem = schem.Mirror(nbt_blueprint_item.m_128471_("mirrorX"), nbt_blueprint_item.m_128471_("mirrorY"), nbt_blueprint_item.m_128471_("mirrorZ"));
                            }
                        }
                        this.lunghezza = new Vec3i(schem.lunghezzaX, schem.altezza, schem.lunghezzaZ);
                        int n_volte = 0;
                        System.out.println("p3");
                        for (int v = 0; v < 2; ++v) {
                            for (int altezze : v == 0 ? schem.BlocksData.keySet() : schem.NotSolidBlocksData.keySet()) {
                                for (Map.Entry<String, String> bloccoDati : v == 0 ? schem.BlocksData.get(altezze).entrySet() : schem.NotSolidBlocksData.get(altezze).entrySet()) {
                                    BlockState bs;
                                    BlockPos offsetPos = new BlockPos(Operazioni.getVec3iFromString(bloccoDati.getKey()));
                                    String blockstate = bloccoDati.getValue();
                                    String bloccoId = blockstate.substring(blockstate.indexOf("<bid>") + 5, blockstate.indexOf("</bid>"));
                                    BlockState blockState = bs = (blockstate = blockstate.replaceFirst("<bid>" + bloccoId + "</bid>", "")).equalsIgnoreCase("null") ? Operazioni.getBlockFromString(bloccoId).m_49966_() : Operazioni.getPropertiesStringToBlock(Operazioni.getBlockFromString(bloccoId), blockstate);
                                    if (bs.m_61138_((Property)BlockStateProperties.f_61391_) && ((BedPart)bs.m_61143_((Property)BlockStateProperties.f_61391_)).equals((Object)BedPart.HEAD)) continue;
                                    BakedModel model = dispatcher.m_110910_(bs);
                                    if (BlueprintsPreviewMethods.isLiquidBlock(bs)) {
                                        this.datiRenderLiquid.add((Tuple<BlockPos, BlockState>)new Tuple((Object)offsetPos, (Object)bs));
                                    } else {
                                        LegacyRandomSource threadRandom = new LegacyRandomSource(System.currentTimeMillis());
                                        for (RenderType renderType : model.getRenderTypes(bs, (RandomSource)threadRandom, ModelData.EMPTY)) {
                                            if (!this.datiBlocchiRender.containsKey(renderType)) {
                                                this.datiBlocchiRender.put(renderType, new ArrayList());
                                            }
                                            this.datiBlocchiRender.get(renderType).add((Tuple<BlockPos, BlockState>)new Tuple((Object)offsetPos, (Object)bs));
                                        }
                                    }
                                    if (++n_volte < 1000) continue;
                                    Thread.sleep(1L);
                                    n_volte = 0;
                                }
                            }
                        }
                        System.out.println("p4");
                        this.datiVertexPronti = true;
                    }
                    finally {
                        poseStack.m_85849_();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.createVertexBuffers();
            }, 0L, TimeUnit.MILLISECONDS);
        }

        public void createVertexBuffers() {
            if (Minecraft.m_91087_().f_91073_ == null || !this.datiVertexPronti || this.isDatiVertexPronti) {
                return;
            }
            System.out.println("p5");
            Minecraft mc = Minecraft.m_91087_();
            PoseStack poseStack = new PoseStack();
            BlockColors blockColors = Minecraft.m_91087_().m_91298_();
            BlockRenderDispatcher dispatcher = mc.m_91289_();
            try {
                BufferBuilder bufferBuilder;
                int initialBufferSize;
                int expectedVertices;
                for (RenderType renderType : this.datiBlocchiRender.keySet()) {
                    expectedVertices = this.datiBlocchiRender.size() * 24;
                    initialBufferSize = Math.max(256, expectedVertices * 32);
                    bufferBuilder = new BufferBuilder(initialBufferSize);
                    bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
                    for (Tuple<BlockPos, BlockState> datiBlocco : this.datiBlocchiRender.get(renderType)) {
                        if (BlueprintsPreviewMethods.isBlockEntity((BlockState)datiBlocco.m_14419_())) {
                            if (this.ListaBlocchiSingleRender.contains(datiBlocco)) continue;
                            this.ListaBlocchiSingleRender.add(datiBlocco);
                            continue;
                        }
                        poseStack.m_85836_();
                        poseStack.m_252880_((float)((BlockPos)datiBlocco.m_14418_()).m_123341_(), (float)((BlockPos)datiBlocco.m_14418_()).m_123342_(), (float)((BlockPos)datiBlocco.m_14418_()).m_123343_());
                        int color = blockColors.m_92577_((BlockState)datiBlocco.m_14419_(), (BlockAndTintGetter)mc.f_91073_, (BlockPos)datiBlocco.m_14418_(), 0);
                        float r = (float)(color >> 16 & 0xFF) / 255.0f;
                        float g = (float)(color >> 8 & 0xFF) / 255.0f;
                        float b = (float)(color & 0xFF) / 255.0f;
                        BakedModel model = dispatcher.m_110910_((BlockState)datiBlocco.m_14419_());
                        dispatcher.m_110937_().renderModel(poseStack.m_85850_(), (VertexConsumer)bufferBuilder, (BlockState)datiBlocco.m_14419_(), model, r, g, b, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, renderType);
                        poseStack.m_85849_();
                    }
                    BufferBuilder.RenderedBuffer rendered = bufferBuilder.m_231175_();
                    Minecraft.m_91087_().execute(() -> {
                        VertexBuffer vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
                        vertexBuffer.m_85921_();
                        vertexBuffer.m_231221_(rendered);
                        if (!this.vertexBuffers.containsKey(tipiRender)) {
                            this.vertexBuffers.put(tipiRender, new ArrayList());
                        }
                        this.vertexBuffers.get(tipiRender).add(vertexBuffer);
                        VertexBuffer.m_85931_();
                    });
                }
                System.out.println("p6");
                for (Tuple tuple : this.datiRenderLiquid) {
                    expectedVertices = this.datiRenderLiquid.size() * 24;
                    initialBufferSize = Math.max(256, expectedVertices * 32);
                    bufferBuilder = new BufferBuilder(initialBufferSize);
                    bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
                    BlockPos pos = new BlockPos(((BlockPos)tuple.m_14418_()).m_123341_() & 0xF, ((BlockPos)tuple.m_14418_()).m_123342_(), ((BlockPos)tuple.m_14418_()).m_123343_() & 0xF);
                    dispatcher.m_234363_(pos, (BlockAndTintGetter)mc.f_91073_, (VertexConsumer)bufferBuilder, (BlockState)tuple.m_14419_(), ((BlockState)tuple.m_14419_()).m_60819_());
                    BufferBuilder.RenderedBuffer rendered = bufferBuilder.m_231175_();
                    Minecraft.m_91087_().execute(() -> {
                        VertexBuffer vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
                        vertexBuffer.m_85921_();
                        vertexBuffer.m_231221_(rendered);
                        this.vertexBuffersLiquids.add((Tuple<BlockPos, VertexBuffer>)new Tuple((Object)((BlockPos)datiBlocco.m_14418_()), (Object)vertexBuffer));
                        VertexBuffer.m_85931_();
                    });
                }
                System.out.println("p7");
                this.isDatiVertexPronti = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void renderStructureCustomPosestack(PoseStack poseStack, Matrix4f matrix4f, RenderLevelStageEvent.Stage stage, Vec3 originPos, boolean renderDeep) {
            if (renderDeep) {
                RenderSystem.enableDepthTest();
            } else {
                RenderSystem.disableDepthTest();
            }
            for (RenderType renderType : this.vertexBuffers.keySet()) {
                if (!STAGE_RENDER_TYPES.containsKey(stage) || !STAGE_RENDER_TYPES.get(stage).contains(renderType)) continue;
                for (VertexBuffer vertexBuffer : this.vertexBuffers.get(renderType)) {
                    vertexBuffer.m_85921_();
                    if (renderType.equals(RenderType.m_110451_()) || renderType.equals(RenderType.m_110463_()) || renderType.equals(RenderType.m_110457_())) {
                        RenderSystem.setShader(GameRenderer::m_172835_);
                    } else if (renderType.equals(RenderType.m_110466_()) || renderType.equals(RenderType.m_110469_())) {
                        RenderSystem.setShader(GameRenderer::m_172649_);
                    } else if (renderType.equals(RenderType.m_110503_())) {
                        RenderSystem.setShader(GameRenderer::m_172814_);
                    }
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
                    try {
                        RenderSystem.enableBlend();
                        RenderSystem.defaultBlendFunc();
                        RenderSystem.depthMask((boolean)true);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)BlueprintEvent.HologramTrasparency);
                        vertexBuffer.m_253207_(poseStack.m_85850_().m_252922_(), matrix4f, Objects.requireNonNull(RenderSystem.getShader()));
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        RenderSystem.disableBlend();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    RenderSystem.depthMask((boolean)true);
                    RenderSystem.disableBlend();
                }
                VertexBuffer.m_85931_();
            }
            Frustum frustum = Minecraft.m_91087_().f_91060_.getFrustum();
            if (stage.equals(RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS)) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.setShader(GameRenderer::m_172649_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
                for (Tuple<BlockPos, VertexBuffer> tuple : this.vertexBuffersLiquids) {
                    ((VertexBuffer)tuple.m_14419_()).m_85921_();
                    Vec3 blockPos = new Vec3((double)((BlockPos)tuple.m_14418_()).m_123341_(), (double)((BlockPos)tuple.m_14418_()).m_123342_(), (double)((BlockPos)tuple.m_14418_()).m_123343_()).m_82549_(originPos);
                    AABB blockAABB = new AABB(blockPos, blockPos.m_82520_(1.0, 1.0, 1.0));
                    if (!frustum.m_113029_(blockAABB)) continue;
                    try {
                        poseStack.m_85836_();
                        BlockPos pos = new BlockPos(((BlockPos)tuple.m_14418_()).m_123341_() & 0xF, ((BlockPos)tuple.m_14418_()).m_123342_() & 0xF, ((BlockPos)tuple.m_14418_()).m_123343_() & 0xF);
                        poseStack.m_252880_((float)(((BlockPos)tuple.m_14418_()).m_123341_() - pos.m_123341_()), (float)(((BlockPos)tuple.m_14418_()).m_123342_() - pos.m_123342_()), (float)(((BlockPos)tuple.m_14418_()).m_123343_() - pos.m_123343_()));
                        RenderSystem.enableBlend();
                        RenderSystem.defaultBlendFunc();
                        RenderSystem.depthMask((boolean)true);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)BlueprintEvent.HologramTrasparency);
                        ((VertexBuffer)tuple.m_14419_()).m_253207_(poseStack.m_85850_().m_252922_(), matrix4f, Objects.requireNonNull(RenderSystem.getShader()));
                        poseStack.m_85849_();
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        RenderSystem.disableBlend();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    VertexBuffer.m_85931_();
                }
                RenderSystem.depthMask((boolean)true);
                RenderSystem.disableBlend();
            }
            if (stage.equals(RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS)) {
                Minecraft minecraft = Minecraft.m_91087_();
                BlockRenderDispatcher blockRenderDispatcher = minecraft.m_91289_();
                BlockEntityRenderDispatcher renderBlockEntity = minecraft.m_167982_();
                for (Tuple<BlockPos, BlockState> datiBlocco : this.ListaBlocchiSingleRender) {
                    Vec3 blockPos = new Vec3((double)((BlockPos)datiBlocco.m_14418_()).m_123341_(), (double)((BlockPos)datiBlocco.m_14418_()).m_123342_(), (double)((BlockPos)datiBlocco.m_14418_()).m_123343_()).m_82520_(originPos.f_82479_, originPos.f_82480_, originPos.f_82481_);
                    AABB blockAABB = new AABB(blockPos, blockPos.m_82520_(1.0, 1.0, 1.0));
                    if (!frustum.m_113029_(blockAABB)) continue;
                    poseStack.m_85836_();
                    poseStack.m_252880_((float)((BlockPos)datiBlocco.m_14418_()).m_123341_(), (float)((BlockPos)datiBlocco.m_14418_()).m_123342_(), (float)((BlockPos)datiBlocco.m_14418_()).m_123343_());
                    try {
                        blockRenderDispatcher.renderSingleBlock((BlockState)datiBlocco.m_14419_(), poseStack, (MultiBufferSource)minecraft.m_91269_().m_110104_(), 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, (RenderType)(((BlockState)datiBlocco.m_14419_()).m_60799_().equals((Object)RenderShape.MODEL) ? RenderType.m_110451_() : null));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    poseStack.m_85849_();
                }
            }
            if (!renderDeep) {
                RenderSystem.enableDepthTest();
            }
        }

        public void renderStructure(PoseStack poseStack, Vec3 cameraPos, Matrix4f matrix4f, RenderLevelStageEvent.Stage stage, Vec3 originPos, boolean renderDeep) {
            if (!this.isDatiVertexPronti || this.visualizeBlueprintDatas == null) {
                return;
            }
            poseStack.m_85836_();
            poseStack.m_85837_(originPos.f_82479_ - cameraPos.f_82479_, originPos.f_82480_ - cameraPos.f_82480_, originPos.f_82481_ - cameraPos.f_82481_);
            this.renderStructureCustomPosestack(poseStack, matrix4f, stage, originPos, renderDeep);
            poseStack.m_85849_();
        }

        public void renderStructureImage(GuiGraphics gg, int posX, int posY, int width, int height, String namespace) {
            if (this.iconTexture == null && !ConvertStructureToTextureDataInput.contains(this)) {
                if (this.visualizeBlueprintDatas == null) {
                    return;
                }
                this.generatePreviewIcon(namespace);
                return;
            }
            gg.m_280411_(this.iconTexture, posX, posY, width, height, 0.0f, 0.0f, 256, 256, 256, 256);
        }

        public void generatePreviewIcon(String namespace) {
            if (hideAllHud || this.iconTexture != null || this.inCreazioneIcon || waitForNextIconGeneration) {
                return;
            }
            String nsID = this.visualizeBlueprintDatas == null ? "" : Blueprint.getIDBlueprint(namespace, this.visualizeBlueprintDatas);
            if (MapIconsRL.containsKey(nsID = Blueprint.sanitizePathUnique(nsID))) {
                this.iconTexture = MapIconsRL.get(nsID);
                return;
            }
            if (!this.isDatiVertexPronti) {
                return;
            }
            waitForNextIconGeneration = true;
            this.inCreazioneIcon = true;
            hideAllHud = true;
            inRenderingForIcon = false;
            ConvertStructureToTextureDataInput.add(this);
            Minecraft mc = Minecraft.m_91087_();
            RenderTarget target = mc.m_91385_();
            target.m_83956_();
            String finalNsID = nsID;
            new Thread(() -> {
                try {
                    while (!inRenderingForIcon) {
                        Thread.sleep(1L);
                    }
                    Minecraft.m_91087_().execute(() -> {
                        NativeImage img = BlueprintsPreviewMethods.scale(BlueprintsPreviewMethods.cropCentered(Screenshot.m_92279_((RenderTarget)Minecraft.m_91087_().m_91385_()), 0.65f), 256, 256);
                        String name = "cache/tablet_icons/" + finalNsID;
                        ResourceLocation rl = new ResourceLocation("portable_blueprints", name);
                        Minecraft.m_91087_().m_91097_().m_118513_(rl);
                        DynamicTexture tex = new DynamicTexture(img);
                        this.iconTexture = Minecraft.m_91087_().m_91097_().m_118490_(name, tex);
                        MapIconsRL.put(finalNsID, this.iconTexture);
                    });
                    Thread.sleep(20L);
                    hideAllHud = false;
                    ConvertStructureToTextureDataInput.remove(this);
                    waitForNextIconGeneration = false;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }).start();
        }

        public String getUnicID(String namespace) {
            return this.visualizeBlueprintDatas == null ? "" : Blueprint.getIDBlueprint(namespace, this.visualizeBlueprintDatas);
        }
    }
}

