/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.client.screen.tablet;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.client.BlueprintsPreviewMethods;
import nimble.portable_blueprints.client.ServerToClientDatasShared;
import nimble.portable_blueprints.client.VisualizeBlueprintDatas;
import nimble.portable_blueprints.client.screen.tablet.TabletBlueprintScreen;
import nimble.portable_blueprints.client.screen.tablet.TabletBlueprintShareScreen;
import nimble.portable_blueprints.client.screen.tablet.TabletScreen;
import nimble.portable_blueprints.client.screen.tablet.mineprint.TabletMinePrintMethods;
import nimble.portable_blueprints.client.screen.tablet.mineprint.TabletMinePrintScreen;
import nimble.portable_blueprints.init.ModTabletTags;
import nimble.portable_blueprints.network.CtoS_CreaItemBlueprint;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.SharedBlueprints.CtoS_RemoveShareWithOthers;
import nimble.portable_blueprints.network.blueprint_tags.CtoS_GetBlueprintTags;
import nimble.portable_blueprints.network.blueprint_tags.CtoS_SetBlueprintTag;
import nimble.portable_blueprints.network.request_specific_data.CtoS_RequestSpecificData;
import nimble.portable_blueprints.network.rimuovi_blueprint.CtoS_BlueprintRemove;
import nimble.portable_blueprints.network.save_global_blueprint.CtoS_SaveGlobalBlueprint;
import nimble.portable_blueprints.network.save_global_blueprint.StoC_SaveGlobalBlueprint;
import nimble.portable_blueprints.robautile.AdvancedButton;
import nimble.portable_blueprints.robautile.Operazioni;
import nimble.portable_blueprints.robautile.RenderingMethods;

@Mod.EventBusSubscriber(modid="portable_blueprints", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class TabletBlueprintInfoScreen
extends Screen {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final ResourceLocation TEXTURE = new ResourceLocation("portable_blueprints", "textures/gui/tablet/tablet_blueprint_gui.png");
    private static int CentroX;
    private static int CentroY;
    private static int W;
    private static int H;
    private RenderingMethods.GuiGraphicsElement BG;
    private static BlueprintsPreviewMethods.BlueprintPreviewData BPD;
    private AdvancedButton B_TAGS;
    private AdvancedButton B_EXPORT;
    private AdvancedButton B_GETBLUEPRINT;
    private AdvancedButton B_SHARE;
    private AdvancedButton B_RESETP;
    private AdvancedButton B_BAN;
    private static boolean inPreparazione;
    private static boolean isOpen;
    private String Titolo = "";
    private static float rotX;
    private static float rotY;
    private static float zoom;
    private static float offsetX;
    private static float offsetY;
    private static int MAX_ZOOM;
    private static int MAX_OFFSET;
    private int ModeScreen = 0;
    private static int BlueprintDataID;
    private static Blueprint.BlueprintDatas visualizeBlueprintDatas;
    private boolean isGlobalBPAllowed = false;
    private RenderingMethods.GuiGraphicsElement TrashImage;
    private boolean TenendoPremutoTrash = false;
    private Long startTimeForTrash = 0L;
    private UUID BPOwner;
    private int nblocks = 0;
    private BufferedImage ImageFaccia;
    private String OwnerName = "";
    private boolean inTagMode = false;
    int XListTag = 0;
    int MaxXListTag = 0;
    private final List<ItemTag> ItemTags = new ArrayList<ItemTag>();
    private String IDStruttura;
    private List<ModTabletTags.TagData> TagsBlueprint = new ArrayList<ModTabletTags.TagData>();
    private boolean TagImpostati = false;
    private Long timeoutTagImpostati = 0L;
    private boolean openAreaIsFollow = false;
    private boolean oneShot = false;
    private short TickCount = 1;
    private boolean startDrag = false;

    protected TabletBlueprintInfoScreen(Component component) {
        super(component);
    }

    public TabletBlueprintInfoScreen(String titolo, int modeScreen, UUID BPOwner, boolean openAreaIsFollow) {
        super((Component)Component.m_237113_((String)"portable_blueprint.tablet"));
        this.ModeScreen = modeScreen;
        this.BPOwner = BPOwner;
        this.openAreaIsFollow = openAreaIsFollow;
        if (BPOwner != null) {
            Thread tickerThread = new Thread(() -> {
                try {
                    this.ImageFaccia = Operazioni.getPlayerFace(BPOwner);
                    this.OwnerName = Minecraft.m_91087_().f_91074_.m_20148_().equals(BPOwner) ? Minecraft.m_91087_().f_91074_.m_7755_().getString() : Operazioni.getPlayerNameFromUUID(BPOwner);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            tickerThread.setDaemon(true);
            tickerThread.start();
        } else {
            this.OwnerName = Component.m_237115_((String)"portable_blueprints.gui.tablet.blueprint_info.info.by_server").getString();
        }
        if (BlueprintDataID != -1 && VisualizeBlueprintDatas.BlueprintsMap.containsKey(BlueprintDataID)) {
            VisualizeBlueprintDatas.BlueprintsMap.remove(BlueprintDataID);
        }
        visualizeBlueprintDatas = null;
        if (modeScreen == 0) {
            BlueprintDataID = VisualizeBlueprintDatas.newVisualizeBlueprint(Minecraft.m_91087_().f_91074_.m_20148_(), titolo, false, false);
        } else if (modeScreen == 1) {
            BlueprintDataID = VisualizeBlueprintDatas.newVisualizeBlueprint(BPOwner, titolo, false, false);
        } else if (modeScreen == 2) {
            BlueprintDataID = VisualizeBlueprintDatas.newVisualizeBlueprint(true, titolo, false, false);
        }
        rotX = 0.0f;
        rotY = 0.0f;
        zoom = 0.0f;
        offsetX = 0.0f;
        offsetY = 0.0f;
        MAX_ZOOM = 0;
        MAX_OFFSET = 0;
        isOpen = true;
        this.Titolo = titolo;
        inPreparazione = false;
        if (BPD != null) {
            BPD.cleanupStructureData();
        }
        BPD = null;
        PacketHandler.sendToServer(new CtoS_RequestSpecificData(510, CtoS_RequestSpecificData.TipoRichiesta.ALLOW_GLOBAL_BLUEPRINTS));
        PacketHandler.sendToServer(new CtoS_RequestSpecificData(770, CtoS_RequestSpecificData.TipoRichiesta.IS_PLAYER_OP));
        this.timeoutTagImpostati = System.currentTimeMillis() + 5000L;
    }

    public void m_7379_() {
        this.reset();
        TabletScreen.resetTablet();
        super.m_7379_();
    }

    protected void m_7856_() {
        super.m_7856_();
        W = this.f_96543_;
        H = this.f_96544_;
        CentroX = W / 2;
        CentroY = H / 2;
        this.isGlobalBPAllowed = ServerToClientDatasShared.getRichiestaBooleana(510) == 1;
        this.BG = new RenderingMethods.GuiGraphicsElement(new RenderingMethods.GuiGraphicsElement.BLIT_Parametri(CentroX - 67, CentroY - 78, 0, 0, 134, 160, TEXTURE));
        int px = CentroX - 65;
        int py = CentroY - 76;
        this.m_142416_((GuiEventListener)AdvancedButton.builder((Component)Component.m_237113_((String)""), pAdvanceButton -> this.Back()).pos(px, py).size(9, 8).defaultImage(new AdvancedButton.Image(TEXTURE, px, py, 247, 16, 9, 8)).hoverImage(new AdvancedButton.Image(TEXTURE, px, py, 247, 24, 9, 8)).tooltip(Tooltip.m_257550_((Component)Component.m_237115_((String)"portable_blueprints.gui.tablet.blueprint_info.button.back"))).build());
        this.B_RESETP = AdvancedButton.builder((Component)Component.m_237113_((String)""), pAdvanceButton -> this.B_Reset()).pos(px, py += 11).size(9, 9).defaultImage(new AdvancedButton.Image(TEXTURE, px, py, 212, 0, 9, 9)).hoverImage(new AdvancedButton.Image(TEXTURE, px, py, 203, 0, 9, 9)).tooltip(Tooltip.m_257550_((Component)Component.m_237115_((String)"portable_blueprints.gui.tablet.blueprint_info.button.reset_preview"))).build();
        this.m_142416_((GuiEventListener)this.B_RESETP);
        px = CentroX + 51;
        py = CentroY - 76;
        this.B_GETBLUEPRINT = AdvancedButton.builder((Component)Component.m_237113_((String)""), pAdvanceButton -> this.B_BlueprintGetItem()).pos(px, py).size(15, 12).defaultImage(new AdvancedButton.Image(TEXTURE, px, py, 241, 191, 15, 16)).hoverImage(new AdvancedButton.Image(TEXTURE, px, py, this.ModeScreen == 2 ? 211 : (this.ModeScreen == 3 ? 196 : 226), 191, 15, 16)).tooltip(Tooltip.m_257550_((Component)Component.m_237115_((String)("portable_blueprints.gui.tablet.blueprint_info.button." + (this.ModeScreen == 3 ? "import_blueprint" : "get_blueprint"))))).build();
        this.m_142416_((GuiEventListener)this.B_GETBLUEPRINT);
        py += 21;
        if (this.ModeScreen == 0 || this.ModeScreen == 3) {
            this.TrashImage = new RenderingMethods.GuiGraphicsElement(new RenderingMethods.GuiGraphicsElement.BLIT_Parametri(px, py, 241, 225, 15, 15, TEXTURE));
            py += 20;
            if (this.ModeScreen == 0) {
                this.B_SHARE = AdvancedButton.builder((Component)Component.m_237113_((String)""), pAdvanceButton -> TabletBlueprintShareScreen.OpenGUI(this.Titolo, this.ModeScreen, this.BPOwner)).pos(px, py).size(15, 17).defaultImage(new AdvancedButton.Image(TEXTURE, px, py, 241, 207, 15, 17)).hoverImage(new AdvancedButton.Image(TEXTURE, px, py, 225, 207, 15, 17)).tooltip(Tooltip.m_257550_((Component)Component.m_237115_((String)"portable_blueprints.gui.tablet.blueprint_info.button.share_blueprint"))).build();
                this.m_142416_((GuiEventListener)this.B_SHARE);
                py += 22;
                if (this.isGlobalBPAllowed) {
                    this.B_EXPORT = AdvancedButton.builder((Component)Component.m_237113_((String)""), pAdvanceButton -> this.B_ExportToGlobal()).pos(px, py).size(15, 15).defaultImage(new AdvancedButton.Image(TEXTURE, px, py, 241, 241, 15, 15)).hoverImage(new AdvancedButton.Image(TEXTURE, px, py, 226, 241, 15, 15)).tooltip(Tooltip.m_257550_((Component)Component.m_237115_((String)"portable_blueprints.gui.tablet.blueprint_info.button.export_blueprint"))).build();
                    this.m_142416_((GuiEventListener)this.B_EXPORT);
                    py += 18;
                }
            }
        }
        if (ServerToClientDatasShared.getRichiestaBooleana(770) == 1 && this.ModeScreen == 1) {
            this.B_BAN = AdvancedButton.builder((Component)Component.m_237113_((String)""), pAdvanceButton -> this.B_BAN()).pos(px, py).size(15, 15).defaultImage(new AdvancedButton.Image(TEXTURE, px, py, 241, 176, 15, 15)).hoverImage(new AdvancedButton.Image(TEXTURE, px, py, 226, 176, 15, 15)).tooltip(Tooltip.m_257550_((Component)Component.m_237115_((String)"portable_blueprints.gui.tablet.blueprint_info.button.ban"))).build();
            this.m_142416_((GuiEventListener)this.B_BAN);
        }
        if (this.ModeScreen != 3) {
            px = CentroX - 63;
            py = CentroY + 63;
            this.B_TAGS = AdvancedButton.builder((Component)Component.m_237113_((String)""), pAdvanceButton -> this.TagMode()).pos(px, py).size(15, 15).defaultImage(new AdvancedButton.Image(TEXTURE, px - 1, py - 1, 64, 240, 16, 16)).pressedImageCondition(new AdvancedButton.Image(TEXTURE, px - 1, py - 1, 80, 240, 16, 16)).build();
            this.m_142416_((GuiEventListener)this.B_TAGS);
        }
        this.m_142416_((GuiEventListener)TabletScreen.getTabletButton(CentroX, CentroY));
        this.MakeTagList();
    }

    private void B_BAN() {
        if (this.BPOwner != null) {
            PacketHandler.sendToServer(new CtoS_RemoveShareWithOthers(this.Titolo, this.BPOwner, this.BPOwner));
            this.Back();
        }
    }

    private void TagMode() {
        System.out.println(this.TagImpostati);
        if (this.BPOwner == null && ServerToClientDatasShared.getRichiestaBooleana(770) == -1 || this.BPOwner != null && !this.BPOwner.equals(Minecraft.m_91087_().f_91074_.m_20148_()) || !this.TagImpostati) {
            return;
        }
        this.inTagMode = !this.inTagMode;
        this.MakeTagList();
    }

    private void B_ExportToGlobal() {
        if (!StoC_SaveGlobalBlueprint.StaGiaGestendoUnaBlueprint && this.isGlobalBPAllowed) {
            Object nome = this.Titolo;
            int tentativi = 1;
            while (Blueprint.globalBlueprintExist((String)nome)) {
                nome = this.Titolo + " (" + tentativi + ")";
                ++tentativi;
            }
            PacketHandler.sendToServer(new CtoS_SaveGlobalBlueprint(this.Titolo + ";" + (String)nome));
        }
    }

    private void B_Reset() {
        offsetX = 0.0f;
        offsetY = 0.0f;
        rotX = 0.0f;
        rotY = 0.0f;
    }

    private void B_RemoveBlueprint() {
        if (this.ModeScreen == 0) {
            PacketHandler.sendToServer(new CtoS_BlueprintRemove(this.Titolo));
            this.Back();
        } else if (this.ModeScreen == 3) {
            Blueprint.removeGlobalBlueprint(this.Titolo);
            this.Back();
        }
    }

    private void B_BlueprintGetItem() {
        if (this.ModeScreen == 0) {
            PacketHandler.sendToServer(new CtoS_CreaItemBlueprint(this.Titolo));
        } else if (this.ModeScreen == 1) {
            PacketHandler.sendToServer(new CtoS_CreaItemBlueprint(this.BPOwner, this.Titolo));
        } else if (this.ModeScreen == 2) {
            PacketHandler.sendToServer(new CtoS_CreaItemBlueprint(true, this.Titolo));
        } else if (this.ModeScreen == 3) {
            PacketHandler.sendToServer(new CtoS_RequestSpecificData(507, CtoS_RequestSpecificData.TipoRichiesta.MAX_STRUCTURE_BLOCK_COUNT));
            PacketHandler.sendToServer(new CtoS_RequestSpecificData(508, CtoS_RequestSpecificData.TipoRichiesta.MAX_DIGITIZED_STRUCTURES_FOR_PLAYER));
            PacketHandler.sendToServer(new CtoS_RequestSpecificData(6000, CtoS_RequestSpecificData.TipoRichiesta.PLAYER_BLUEPRINTS_QUANTITY));
            Blueprint.sendToServerGlobalBlueprint(this.Titolo);
        }
    }

    private void Back() {
        this.reset();
        if (this.openAreaIsFollow) {
            TabletMinePrintScreen.OpenGUI(TabletMinePrintScreen.PageType.FOLLOW);
        } else {
            if (this.ModeScreen == 0 || this.ModeScreen == 3) {
                TabletBlueprintScreen.OpenGUI();
            }
            if (this.ModeScreen == 1) {
                TabletMinePrintScreen.OpenGUI(TabletMinePrintScreen.PageType.GLOBAL);
            } else if (this.ModeScreen == 2) {
                TabletMinePrintScreen.OpenGUI(TabletMinePrintScreen.PageType.SERVER);
            }
        }
    }

    public void m_88315_(GuiGraphics gg, int mouseX, int mouseY, float delta) {
        if (!this.oneShot && ServerToClientDatasShared.getRichiestaBooleana(510) != -1) {
            this.oneShot = true;
            this.re_init();
        }
        if (BPD == null && this.ModeScreen == 3) {
            try {
                visualizeBlueprintDatas = (Blueprint.BlueprintDatas)GSON.fromJson((Reader)new FileReader(new File(Blueprint.getGlobalBlueprintDir(), this.Titolo + ".bp")), Blueprint.BlueprintDatas.class);
                BPD = new BlueprintsPreviewMethods.BlueprintPreviewData(visualizeBlueprintDatas);
                BPD.prepareData(null);
                this.nblocks = visualizeBlueprintDatas.getAllBlocksCount();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.ModeScreen != 3) {
            if (BPD == null && VisualizeBlueprintDatas.BlueprintsMap.containsKey(BlueprintDataID)) {
                visualizeBlueprintDatas = VisualizeBlueprintDatas.BlueprintsMap.get(BlueprintDataID);
                this.IDStruttura = Blueprint.getIDBlueprint(this.BPOwner == null ? "server" : this.BPOwner.toString(), visualizeBlueprintDatas);
                this.nblocks = visualizeBlueprintDatas.getAllBlocksCount();
                BPD = new BlueprintsPreviewMethods.BlueprintPreviewData(visualizeBlueprintDatas);
                VisualizeBlueprintDatas.BlueprintsMap.remove(BlueprintDataID);
                ServerToClientDatasShared.BlueprintTags.remove(this.IDStruttura);
                PacketHandler.sendToServer(new CtoS_GetBlueprintTags(this.BPOwner, this.Titolo));
            }
            if (this.IDStruttura != null && ServerToClientDatasShared.BlueprintTags.containsKey(this.IDStruttura) && this.TagsBlueprint.isEmpty() && !this.TagImpostati) {
                this.TagImpostati = true;
                for (String v : ServerToClientDatasShared.BlueprintTags.get(this.IDStruttura)) {
                    ModTabletTags.TagData td = ModTabletTags.getTagByID(v);
                    if (td == null) continue;
                    this.TagsBlueprint.add(td);
                }
                ServerToClientDatasShared.BlueprintTags.remove(this.IDStruttura);
                this.MakeTagList();
            }
            if (!this.TagImpostati && System.currentTimeMillis() > this.timeoutTagImpostati) {
                this.TagImpostati = true;
                this.timeoutTagImpostati = 0L;
            }
        }
        if (this.B_TAGS != null) {
            this.B_TAGS.PressedImageCondition = this.inTagMode;
        }
        Minecraft mc = Minecraft.m_91087_();
        for (int x = 0; x < 4; ++x) {
            if (x == 0) {
                RenderingMethods.enableScissorFromGui(mc, CentroX - 78, CentroY - 104, 23, 210);
            } else if (x == 1) {
                RenderingMethods.enableScissorFromGui(mc, CentroX - 78, CentroY - 104, 180, 28);
            } else if (x == 2) {
                RenderingMethods.enableScissorFromGui(mc, CentroX - 78 + 128, CentroY - 104, 30, 210);
            } else if (x == 3) {
                RenderingMethods.enableScissorFromGui(mc, CentroX - 78, CentroY - 104 + 133, 180, 80);
            }
            TabletScreen.renderTabletBackground(gg, CentroX, CentroY, "b3");
            this.BG.render(gg);
            RenderingMethods.disableScissor();
        }
        try {
            super.m_88315_(gg, mouseX, mouseY, delta);
        }
        catch (Exception x) {
            // empty catch block
        }
        if (BPD == null || !TabletBlueprintInfoScreen.BPD.isDatiVertexPronti) {
            RenderingMethods.GuiGraphicsTestoScalato(gg, Component.m_237115_((String)"portable_blueprints.gui.tablet.blueprint_info.loading_data").getString(), 1.0f, Minecraft.m_91087_().f_91062_, new Vec2((float)(CentroX - 2), (float)(CentroY - 30)), 0xFFFFFF, false, RenderingMethods.PosizioneTesto.CENTRO, true);
            if (this.B_TAGS != null) {
                this.B_TAGS.f_93624_ = false;
            }
            if (this.B_EXPORT != null) {
                this.B_EXPORT.f_93624_ = false;
            }
            if (this.B_GETBLUEPRINT != null) {
                this.B_GETBLUEPRINT.f_93624_ = false;
            }
            if (this.B_SHARE != null) {
                this.B_SHARE.f_93624_ = false;
            }
            if (this.B_RESETP != null) {
                this.B_RESETP.f_93624_ = false;
            }
            if (this.B_BAN != null) {
                this.B_BAN.f_93624_ = false;
            }
        } else {
            gg.m_280218_(TEXTURE, CentroX - 65, CentroY - 54, 222, 0, 9, 9);
            gg.m_280218_(TEXTURE, CentroX - 65, CentroY - 43, 231, 0, 9, 9);
            if (visualizeBlueprintDatas != null && mouseX >= CentroX - 65 && mouseX < CentroX - 65 + 9 && mouseY >= CentroY - 54 && mouseY < CentroY - 54 + 9) {
                gg.m_280677_(Minecraft.m_91087_().f_91062_, List.of(Component.m_237113_((String)Component.m_237115_((String)"portable_blueprints.gui.tablet.blueprint_info.info.lenght.x").getString().replace("%v%", String.valueOf(TabletBlueprintInfoScreen.visualizeBlueprintDatas.lunghezzaX))), Component.m_237113_((String)Component.m_237115_((String)"portable_blueprints.gui.tablet.blueprint_info.info.lenght.y").getString().replace("%v%", String.valueOf(TabletBlueprintInfoScreen.visualizeBlueprintDatas.altezza))), Component.m_237113_((String)Component.m_237115_((String)"portable_blueprints.gui.tablet.blueprint_info.info.lenght.z").getString().replace("%v%", String.valueOf(TabletBlueprintInfoScreen.visualizeBlueprintDatas.lunghezzaZ)))), Optional.empty(), mouseX, mouseY);
            } else if (visualizeBlueprintDatas != null && mouseX >= CentroX - 65 && mouseX < CentroX - 65 + 9 && mouseY >= CentroY - 43 && mouseY < CentroY - 43 + 9) {
                gg.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)Component.m_237115_((String)"portable_blueprints.gui.tablet.blueprint_info.info.nblocks").getString().replace("%v%", String.valueOf(this.nblocks))), mouseX, mouseY);
            }
            if (visualizeBlueprintDatas != null) {
                String testo;
                RenderingMethods.GuiGraphicsTestoScalato(gg, testo, (testo = TabletBlueprintInfoScreen.visualizeBlueprintDatas.nome).length() > 22 ? (float)testo.length() / 35.0f : 1.0f, Minecraft.m_91087_().f_91062_, new Vec2((float)(CentroX - 1), (float)(CentroY + 34)), 0, false, RenderingMethods.PosizioneTesto.CENTRO, true);
                int l = Minecraft.m_91087_().f_91062_.m_92895_(testo) / 2;
                if (l > 50) {
                    l = 50;
                }
                gg.m_280509_(CentroX - l - 5, CentroY + 38, CentroX + l + 2, CentroY + 39, -16777216);
            }
            if (this.ImageFaccia != null) {
                for (int x = 0; x < this.ImageFaccia.getWidth(); ++x) {
                    for (int y = 0; y < this.ImageFaccia.getHeight(); ++y) {
                        int color = this.ImageFaccia.getRGB(x, y);
                        int addX = 2 * x + CentroX - 64;
                        int addY = 2 * y + CentroY + 42;
                        gg.m_280509_(addX, addY, addX + 2, addY + 2, color);
                    }
                }
            } else {
                gg.m_280218_(TEXTURE, CentroX - 64, CentroY + 42, this.BPOwner == null ? 48 : 32, 240, 16, 16);
            }
            if (this.OwnerName != null) {
                RenderingMethods.GuiGraphicsTestoScalato(gg, this.OwnerName, this.OwnerName.length() < 14 ? 1.25f : Operazioni.lerp(1.25f, 1.1f, (float)(this.OwnerName.length() - 14) / 2.0f), Minecraft.m_91087_().f_91062_, new Vec2((float)(CentroX - 46), (float)(CentroY + 52)), 0, false, RenderingMethods.PosizioneTesto.SINISTRA, true);
            }
            if (this.TrashImage != null) {
                this.TrashImage.render(gg);
                if (this.TenendoPremutoTrash && this.startTimeForTrash != 0L) {
                    float time = 1.0f - (float)(this.startTimeForTrash - System.currentTimeMillis()) / 2000.0f;
                    if (time > 1.2f) {
                        this.TenendoPremutoTrash = false;
                        this.startTimeForTrash = 0L;
                        this.B_RemoveBlueprint();
                        System.out.println("Elimina Blueprint Personale");
                    }
                    int h = (int)Math.min(Operazioni.lerp(1.0f, 15.0f, time), 15.0f);
                    int v2 = 240 - h;
                    gg.m_280218_(TEXTURE, this.TrashImage.blitParametri.startPosX, this.TrashImage.blitParametri.startPosY - h + 15, 225, v2, 15, h);
                }
            }
            try {
                RenderingMethods.enableScissorFromGui(Minecraft.m_91087_(), CentroX - 46, CentroY + 67, 110, 10);
                for (ItemTag it : this.ItemTags) {
                    it.render(gg);
                }
                RenderingMethods.disableScissor();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.TrashImage != null && mouseX >= this.TrashImage.blitParametri.startPosX && mouseX < this.TrashImage.blitParametri.startPosX + this.TrashImage.blitParametri.width && mouseY >= this.TrashImage.blitParametri.startPosY && mouseY < this.TrashImage.blitParametri.startPosY + this.TrashImage.blitParametri.height) {
                gg.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"portable_blueprints.gui.tablet.blueprint_info.button.delete_blueprint"), mouseX, mouseY);
            }
            if (this.B_TAGS != null) {
                this.B_TAGS.f_93624_ = true;
            }
            if (this.B_EXPORT != null) {
                this.B_EXPORT.f_93624_ = true;
            }
            if (this.B_GETBLUEPRINT != null) {
                this.B_GETBLUEPRINT.f_93624_ = true;
            }
            if (this.B_SHARE != null) {
                this.B_SHARE.f_93624_ = true;
            }
            if (this.B_RESETP != null) {
                this.B_RESETP.f_93624_ = true;
            }
            if (this.B_BAN != null) {
                this.B_BAN.f_93624_ = true;
            }
        }
        TabletScreen.renderTabletUpBar(gg, CentroX, CentroY);
    }

    private void re_init() {
        while (this.f_169369_.size() > 0) {
            this.m_169411_((GuiEventListener)this.f_169369_.get(0));
        }
        this.m_7856_();
    }

    public void MakeTagList() {
        this.ItemTags.clear();
        int offsetX = 0;
        for (ModTabletTags.TagData tagData : this.inTagMode ? ModTabletTags.TagDatas : this.TagsBlueprint) {
            ItemTag it = new ItemTag(tagData, CentroX + offsetX - 45, CentroY + 72);
            if (this.inTagMode) {
                for (ModTabletTags.TagData tagData1 : this.TagsBlueprint) {
                    if (!tagData.getOriginalTag().equals(tagData1.getOriginalTag())) continue;
                    it.isSelected = true;
                    break;
                }
            }
            this.ItemTags.add(it);
            offsetX += it.getTextWidth() + 5;
        }
        this.MaxXListTag = offsetX - 105 - 10 + 1;
        System.err.println("v: " + this.MaxXListTag);
        if (this.MaxXListTag < 0) {
            this.MaxXListTag = 0;
        }
        if (this.XListTag > this.MaxXListTag) {
            this.XListTag = this.MaxXListTag;
        }
    }

    public void m_86600_() {
        super.m_86600_();
        this.TickCount = (short)(this.TickCount + 1);
        if (this.TickCount > 20) {
            this.TickCount = 1;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        block2: {
            block1: {
                if (this.TrashImage == null || !(mouseX >= (double)this.TrashImage.blitParametri.startPosX) || !(mouseX < (double)(this.TrashImage.blitParametri.startPosX + this.TrashImage.blitParametri.width)) || !(mouseY >= (double)this.TrashImage.blitParametri.startPosY) || !(mouseY < (double)(this.TrashImage.blitParametri.startPosY + this.TrashImage.blitParametri.height))) break block1;
                this.TenendoPremutoTrash = true;
                this.startTimeForTrash = System.currentTimeMillis() + 2000L;
                break block2;
            }
            if (!this.inTagMode || !(mouseX >= (double)(CentroX - 46)) || !(mouseX < (double)(CentroX - 46 + 110)) || !(mouseY >= (double)(CentroY + 67)) || !(mouseY < (double)(CentroY + 67 + 10))) break block2;
            for (ItemTag it : this.ItemTags) {
                if (it.select((int)mouseX, (int)mouseY)) break;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7043_() {
        return false;
    }

    private void reset() {
        isOpen = false;
        if (BPD != null) {
            BPD.cleanupStructureData();
        }
        inPreparazione = false;
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (!(Minecraft.m_91087_().f_91080_ instanceof TabletBlueprintInfoScreen) || !BlueprintsPreviewMethods.BlueprintPreviewData.AllUsedStage.contains(event.getStage()) && !event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES)) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        float yaw = camera.m_90590_();
        float pitch = camera.m_90589_();
        RenderingMethods.enableScissorFromGui(Minecraft.m_91087_(), CentroX - 55, CentroY - 76, 105, 105);
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES) || event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS)) {
            float r = 0.18431373f;
            float g = 0.21176471f;
            float b = 0.2509804f;
            Vec3 _lookVec = Minecraft.m_91087_().f_91074_.m_20154_();
            _lookVec = _lookVec.m_82490_((double)0.9f);
            poseStack.m_85836_();
            poseStack.m_85837_(_lookVec.f_82479_, _lookVec.f_82480_, _lookVec.f_82481_);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yaw));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-pitch));
            Tesselator tess = Tesselator.m_85913_();
            BufferBuilder buf = tess.m_85915_();
            buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buf.m_252986_(poseStack.m_85850_().m_252922_(), -0.5f, -0.5f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), 0.5f, -0.5f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), 0.5f, 0.5f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
            buf.m_252986_(poseStack.m_85850_().m_252922_(), -0.5f, 0.5f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
            RenderSystem.setShader(GameRenderer::m_172811_);
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buf.m_231175_());
            poseStack.m_85849_();
        }
        if (BPD != null && visualizeBlueprintDatas != null) {
            if (!TabletBlueprintInfoScreen.BPD.isDatiVertexPronti && !inPreparazione) {
                inPreparazione = true;
                MAX_OFFSET = MAX_ZOOM = (int)((float)((double)Math.max(TabletBlueprintInfoScreen.visualizeBlueprintDatas.altezza, TabletBlueprintInfoScreen.visualizeBlueprintDatas.lunghezzaX) * 2.2) * 1.5f);
                BPD.prepareData(null);
            }
            if (TabletBlueprintInfoScreen.BPD.isDatiVertexPronti) {
                Vec3 lookVec = Minecraft.m_91087_().f_91074_.m_20154_();
                Vec3 targetPos = lookVec.m_82490_((double)Math.max(TabletBlueprintInfoScreen.visualizeBlueprintDatas.altezza, TabletBlueprintInfoScreen.visualizeBlueprintDatas.lunghezzaX) * 2.2 + (double)zoom);
                poseStack.m_85836_();
                poseStack.m_85837_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
                poseStack.m_252880_(0.0f, -offsetY, -offsetX);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-yaw));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-rotX));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(rotY));
                poseStack.m_85836_();
                poseStack.m_252880_((float)(-TabletBlueprintInfoScreen.visualizeBlueprintDatas.lunghezzaX) / 2.0f, (float)(-TabletBlueprintInfoScreen.visualizeBlueprintDatas.altezza) / 5.0f, (float)(-TabletBlueprintInfoScreen.visualizeBlueprintDatas.lunghezzaZ) / 2.0f);
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-1.0f, (float)-1000000.0f);
                BPD.renderStructureCustomPosestack(poseStack, event.getProjectionMatrix(), event.getStage(), targetPos, true);
                RenderSystem.disablePolygonOffset();
                poseStack.m_85849_();
                poseStack.m_85849_();
            }
        }
        RenderingMethods.disableScissor();
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.startDrag || mouseX >= (double)(CentroX - 54) && mouseX < (double)(CentroX - 54 + 105) && mouseY >= (double)(CentroY - 76) && mouseY < (double)(CentroY - 76 + 105)) {
            this.startDrag = true;
            float sensRot = 2.0f;
            float sensMov = Math.max(1.0E-4f, 1.0E-4f * ((float)(MAX_ZOOM * 2) * (((float)MAX_ZOOM + zoom) / (float)(MAX_ZOOM * 2))));
            if (visualizeBlueprintDatas != null) {
                sensMov *= (float)Math.sqrt(TabletBlueprintInfoScreen.visualizeBlueprintDatas.lunghezzaX * TabletBlueprintInfoScreen.visualizeBlueprintDatas.lunghezzaX + TabletBlueprintInfoScreen.visualizeBlueprintDatas.altezza * TabletBlueprintInfoScreen.visualizeBlueprintDatas.altezza + TabletBlueprintInfoScreen.visualizeBlueprintDatas.lunghezzaZ * TabletBlueprintInfoScreen.visualizeBlueprintDatas.lunghezzaZ);
            }
            if (button == 0) {
                if (dragX > 0.0) {
                    rotX -= sensRot;
                } else if (dragX < 0.0) {
                    rotX += sensRot;
                }
                if (rotX >= 360.0f) {
                    rotX -= 360.0f;
                } else if (rotX < 0.0f) {
                    rotX += 360.0f;
                }
                if (dragY > 0.0) {
                    rotY -= sensRot;
                } else if (dragY < 0.0) {
                    rotY += sensRot;
                }
                if (rotY >= 360.0f) {
                    rotY -= 360.0f;
                } else if (rotY < 0.0f) {
                    rotY += 360.0f;
                }
            } else if (button == 1) {
                // empty if block
            }
        }
        if (!(this.TrashImage == null || mouseX >= (double)this.TrashImage.blitParametri.startPosX && mouseX < (double)(this.TrashImage.blitParametri.startPosX + this.TrashImage.blitParametri.width) && mouseY >= (double)this.TrashImage.blitParametri.startPosY && mouseY < (double)(this.TrashImage.blitParametri.startPosY + this.TrashImage.blitParametri.height))) {
            this.TenendoPremutoTrash = false;
            this.startTimeForTrash = 0L;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.startDrag = false;
        this.TenendoPremutoTrash = false;
        this.startTimeForTrash = 0L;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        float sens = 5.0f;
        if (mouseX >= (double)(CentroX - 54) && mouseX < (double)(CentroX - 54 + 105) && mouseY >= (double)(CentroY - 76) && mouseY < (double)(CentroY - 76 + 105)) {
            if ((zoom += (float)((double)sens * -delta)) > (float)MAX_ZOOM) {
                zoom = MAX_ZOOM;
            } else if (zoom < (float)(-MAX_ZOOM)) {
                zoom = -MAX_ZOOM;
            }
        } else if (mouseX >= (double)(CentroX - 46) && mouseX < (double)(CentroX - 46 + 110) && mouseY >= (double)(CentroY + 67) && mouseY < (double)(CentroY + 67 + 10)) {
            this.XListTag += (int)(10.0 * -delta);
            System.err.println(this.MaxXListTag);
            if (this.XListTag > this.MaxXListTag) {
                this.XListTag = this.MaxXListTag;
            } else if (this.XListTag < 0) {
                this.XListTag = 0;
            }
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public static void OpenGUIByAppBlueprint(String Titolo) {
        Minecraft.m_91087_().m_91152_((Screen)new TabletBlueprintInfoScreen(Titolo, 0, null, false));
    }

    public static void OpenGUIByAppMinePrint(String Titolo, TabletMinePrintMethods.TYPE type, UUID BPOwner, boolean isOpenByFollowArea) {
        Minecraft.m_91087_().m_91152_((Screen)new TabletBlueprintInfoScreen(Titolo, type.equals((Object)TabletMinePrintMethods.TYPE.PERSONAL) ? 0 : (type.equals((Object)TabletMinePrintMethods.TYPE.SERVER) ? 2 : (type.equals((Object)TabletMinePrintMethods.TYPE.PERSONAL_GLOBAL) ? 3 : 1)), BPOwner, isOpenByFollowArea));
    }

    static {
        inPreparazione = false;
        isOpen = false;
        rotX = 0.0f;
        rotY = 0.0f;
        zoom = 0.0f;
        offsetX = 0.0f;
        offsetY = 0.0f;
        MAX_ZOOM = 0;
        MAX_OFFSET = 0;
        BlueprintDataID = -1;
        visualizeBlueprintDatas = null;
    }

    public class ItemTag {
        final ModTabletTags.TagData tagData;
        final int px;
        final int py;
        private boolean isSelected = false;

        public ItemTag(ModTabletTags.TagData tagData, int px, int py) {
            this.tagData = tagData;
            this.px = px;
            this.py = py;
        }

        public void render(GuiGraphics gg) {
            gg.m_280509_(this.px - 1 - TabletBlueprintInfoScreen.this.XListTag, this.py - 5, this.px + this.getTextWidth() - TabletBlueprintInfoScreen.this.XListTag, this.py + 5, -3618616);
            RenderingMethods.GuiGraphicsTestoScalato(gg, this.tagData.getCurrentLenguageTag(), 1.0f, Minecraft.m_91087_().f_91062_, new Vec2((float)(this.px - TabletBlueprintInfoScreen.this.XListTag), (float)this.py), this.isSelected ? 255 : 0, false, RenderingMethods.PosizioneTesto.SINISTRA, true);
        }

        public int getTextWidth() {
            return Minecraft.m_91087_().f_91062_.m_92895_(this.tagData.getCurrentLenguageTag());
        }

        public boolean select(int mouseX, int mouseY) {
            int _px = this.px - TabletBlueprintInfoScreen.this.XListTag;
            int _py = this.py - 4;
            if (mouseX >= _px && mouseX < _px + this.getTextWidth() - 1 && mouseY >= _py && mouseY < _py + 7) {
                this.isSelected = !this.isSelected;
                PacketHandler.sendToServer(new CtoS_SetBlueprintTag(TabletBlueprintInfoScreen.this.BPOwner, TabletBlueprintInfoScreen.this.Titolo, this.tagData.getOriginalTag(), this.isSelected));
                if (this.isSelected) {
                    TabletBlueprintInfoScreen.this.TagsBlueprint.add(this.tagData);
                } else {
                    ModTabletTags.TagData to_remove = null;
                    for (ModTabletTags.TagData td : TabletBlueprintInfoScreen.this.TagsBlueprint) {
                        if (!td.getOriginalTag().equals(this.tagData.getOriginalTag())) continue;
                        to_remove = td;
                        break;
                    }
                    if (to_remove != null) {
                        TabletBlueprintInfoScreen.this.TagsBlueprint.remove(to_remove);
                    }
                }
                return true;
            }
            return false;
        }
    }
}

