/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.client.screen.tablet;

import com.mojang.blaze3d.vertex.PoseStack;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import nimble.portable_blueprints.client.ServerToClientDatasShared;
import nimble.portable_blueprints.client.VisualizeBlueprintDatas;
import nimble.portable_blueprints.client.screen.tablet.TabletBlueprintScreen;
import nimble.portable_blueprints.client.screen.tablet.TabletInfoScreen;
import nimble.portable_blueprints.client.screen.tablet.mineprint.TabletMinePrintScreen;
import nimble.portable_blueprints.init.TabletClientDatas;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.request_specific_data.CtoS_RequestSpecificData;
import nimble.portable_blueprints.robautile.AdvancedButton;
import nimble.portable_blueprints.robautile.Operazioni;
import nimble.portable_blueprints.robautile.RenderingMethods;
import org.joml.Vector2i;

public class TabletScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("portable_blueprints", "textures/gui/tablet/tablet_gui.png");
    private int CentroX;
    private int CentroY;
    private int W;
    private int H;
    private AdvancedButton B_APP_BLUEPRINT;
    private AdvancedButton B_APP_MINEPRINT;
    private AdvancedButton B_APP_INFO;
    private AdvancedButton B_SETTINGS;
    private AdvancedButton B_CHANGE_BG_LEFT;
    private AdvancedButton B_CHANGE_BG_RIGHT;
    private final OpenAppAnimation OAA;
    private final Long EndAnimation;
    private linkItem[] linkItems = new linkItem[5];
    private boolean settingsOpen = false;
    private static final short BGMAX = 7;
    private boolean isOpeningApp = false;
    private short TickCount = 1;
    public static List<Integer> IDSBlueprints = new ArrayList<Integer>();

    protected TabletScreen(boolean withAnimation, Component component) {
        super(component);
        this.OAA = new OpenAppAnimation();
        this.EndAnimation = System.currentTimeMillis() + (long)(withAnimation ? 400 : 0);
        PacketHandler.sendToServer(new CtoS_RequestSpecificData(53, CtoS_RequestSpecificData.TipoRichiesta.GET_TABLET_SOCIAL_LINKS));
    }

    public TabletScreen(boolean withAnimation) {
        super((Component)Component.m_237113_((String)"portable_blueprint.tablet"));
        this.OAA = new OpenAppAnimation();
        this.EndAnimation = System.currentTimeMillis() + (long)(withAnimation ? 400 : 0);
        PacketHandler.sendToServer(new CtoS_RequestSpecificData(53, CtoS_RequestSpecificData.TipoRichiesta.GET_TABLET_SOCIAL_LINKS));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.W = this.f_96543_;
        this.H = this.f_96544_;
        this.CentroX = this.W / 2;
        this.CentroY = this.H / 2;
        this.setButtonsApp();
        this.m_142416_((GuiEventListener)TabletScreen.getTabletButton(this.CentroX, this.CentroY));
    }

    public void m_88315_(GuiGraphics gg, int mouseX, int mouseY, float delta) {
        if (this.linkItems[0] == null && ServerToClientDatasShared.RichiestaString.containsKey(53)) {
            String v = ServerToClientDatasShared.RichiestaString.get(53);
            for (int x = 0; x < 5; ++x) {
                if (v.split(";").length - 1 >= x) {
                    String link = v.split(";")[x];
                    if (!link.equals("")) {
                        this.linkItems[x] = new linkItem(link);
                        continue;
                    }
                    this.linkItems[x] = null;
                    continue;
                }
                this.linkItems[x] = null;
            }
        }
        PoseStack poseStack = gg.m_280168_();
        poseStack.m_85836_();
        float t = 1.0f - (float)(this.EndAnimation - System.currentTimeMillis()) / 400.0f;
        if (t > 1.0f) {
            t = 1.0f;
        }
        poseStack.m_252880_((float)this.CentroX, (float)this.CentroY, 0.0f);
        float scale = Operazioni.lerp(0.4f, 1.0f, t);
        poseStack.m_85841_(scale, scale, 1.0f);
        poseStack.m_252880_((float)(-this.CentroX), (float)(-this.CentroY), 0.0f);
        poseStack.m_252880_(0.0f, Operazioni.lerp(this.CentroY * 3, 0.0f, t), 0.0f);
        TabletScreen.renderTabletBackground(gg, this.CentroX, this.CentroY, "b" + TabletClientDatas.getSettings().selectedBG);
        if (!this.settingsOpen) {
            int posPlus = 0;
            for (linkItem linkItem2 : this.linkItems) {
                if (linkItem2 == null) continue;
                linkItem2.render(gg, this.CentroX - 68 + posPlus, this.CentroY + 69, mouseX, mouseY);
                posPlus += 24;
            }
        } else {
            gg.m_280509_(this.CentroX - 70, this.CentroY - 97, this.CentroX - 40, this.CentroY + 89, 0x55FFFFFF);
            gg.m_280509_(this.CentroX + 70, this.CentroY - 97, this.CentroX + 40, this.CentroY + 89, 0x55FFFFFF);
        }
        try {
            super.m_88315_(gg, mouseX, mouseY, delta);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.OAA.isStarted && !this.settingsOpen) {
            if (this.B_APP_BLUEPRINT != null) {
                RenderingMethods.GuiGraphicsTestoScalato(gg, Component.m_237115_((String)"portable_blueprints.gui.tablet.app.blueprint").getString(), 0.5f, Minecraft.m_91087_().f_91062_, new Vec2((float)(this.B_APP_BLUEPRINT.posX + 16), (float)(this.B_APP_BLUEPRINT.posY + 36)), 0xFFFFFF, true, RenderingMethods.PosizioneTesto.CENTRO, true);
            }
            if (this.B_APP_MINEPRINT != null) {
                RenderingMethods.GuiGraphicsTestoScalato(gg, Component.m_237115_((String)"portable_blueprints.gui.tablet.app.mineprint").getString(), 0.5f, Minecraft.m_91087_().f_91062_, new Vec2((float)(this.B_APP_MINEPRINT.posX + 16), (float)(this.B_APP_MINEPRINT.posY + 36)), 0xFFFFFF, true, RenderingMethods.PosizioneTesto.CENTRO, true);
            }
            if (this.B_APP_INFO != null) {
                RenderingMethods.GuiGraphicsTestoScalato(gg, Component.m_237115_((String)"portable_blueprints.gui.tablet.app.info").getString(), 0.5f, Minecraft.m_91087_().f_91062_, new Vec2((float)(this.B_APP_INFO.posX + 16), (float)(this.B_APP_INFO.posY + 36)), 0xFFFFFF, true, RenderingMethods.PosizioneTesto.CENTRO, true);
            }
        }
        this.OAA.render(gg);
        TabletScreen.renderTabletUpBar(gg, this.CentroX, this.CentroY);
        poseStack.m_85849_();
    }

    public void setButtonsApp() {
        int ofX = 192;
        int ofY = 0;
        int posX = this.CentroX - 60;
        int posY = this.CentroY - 77;
        this.B_APP_BLUEPRINT = AdvancedButton.builder((Component)Component.m_237113_((String)""), button -> this.B_Open_App(0)).pos(posX, posY).size(32, 32).defaultImage(new AdvancedButton.Image(TEXTURE, posX, posY, ofX, ofY, 32, 32)).build();
        this.m_142416_((GuiEventListener)this.B_APP_BLUEPRINT);
        this.B_APP_BLUEPRINT.f_93624_ = !this.settingsOpen;
        posX = this.CentroX - 16;
        this.B_APP_MINEPRINT = AdvancedButton.builder((Component)Component.m_237113_((String)""), button -> this.B_Open_App(1)).pos(posX, posY).size(32, 32).defaultImage(new AdvancedButton.Image(TEXTURE, posX, posY, ofX += 32, ofY, 32, 32)).build();
        this.m_142416_((GuiEventListener)this.B_APP_MINEPRINT);
        this.B_APP_MINEPRINT.f_93624_ = !this.settingsOpen;
        posX = this.CentroX + 28;
        this.B_APP_INFO = AdvancedButton.builder((Component)Component.m_237113_((String)""), button -> this.B_Open_App(2)).pos(posX, posY).size(32, 32).defaultImage(new AdvancedButton.Image(TEXTURE, posX, posY, ofX -= 32, ofY += 32, 32, 32)).build();
        this.m_142416_((GuiEventListener)this.B_APP_INFO);
        this.B_APP_INFO.f_93624_ = !this.settingsOpen;
        posX = this.CentroX + 52;
        posY = this.CentroY + 70;
        this.B_SETTINGS = AdvancedButton.builder((Component)Component.m_237113_((String)""), button -> this.B_OpenSettings()).pos(posX, posY).size(16, 16).defaultImage(new AdvancedButton.Image(TEXTURE, posX, posY, 32, 208, 16, 16)).build();
        this.m_142416_((GuiEventListener)this.B_SETTINGS);
        posX = this.CentroX - 70;
        posY = this.CentroY - 97;
        this.B_CHANGE_BG_LEFT = AdvancedButton.builder((Component)Component.m_237113_((String)""), button -> this.B_CHANGE_BG(false)).pos(posX, posY).size(30, 186).defaultImage(new AdvancedButton.Image(TEXTURE, posX + 4, this.CentroY - 18, 216, 188, 20, 36)).build();
        this.m_142416_((GuiEventListener)this.B_CHANGE_BG_LEFT);
        this.B_CHANGE_BG_LEFT.f_93624_ = this.settingsOpen;
        posX = this.CentroX + 40;
        posY = this.CentroY - 97;
        this.B_CHANGE_BG_RIGHT = AdvancedButton.builder((Component)Component.m_237113_((String)""), button -> this.B_CHANGE_BG(true)).pos(posX, posY).size(30, 186).defaultImage(new AdvancedButton.Image(TEXTURE, posX + 6, this.CentroY - 18, 236, 188, 20, 36)).build();
        this.m_142416_((GuiEventListener)this.B_CHANGE_BG_RIGHT);
        this.B_CHANGE_BG_RIGHT.f_93624_ = this.settingsOpen;
    }

    private void B_CHANGE_BG(boolean right) {
        TabletClientDatas.getSettings().selectedBG = (short)(TabletClientDatas.getSettings().selectedBG + (short)(right ? 1 : -1));
        if (TabletClientDatas.getSettings().selectedBG <= 0) {
            TabletClientDatas.Settings settings = TabletClientDatas.getSettings();
            settings.selectedBG = (short)7;
            TabletClientDatas.setSettings(settings);
        } else if (TabletClientDatas.getSettings().selectedBG > 7) {
            TabletClientDatas.Settings settings = TabletClientDatas.getSettings();
            settings.selectedBG = 1;
            TabletClientDatas.setSettings(settings);
        }
        TabletClientDatas.save();
    }

    private void B_OpenSettings() {
        this.settingsOpen = !this.settingsOpen;
        this.B_APP_BLUEPRINT.f_93624_ = !this.settingsOpen;
        this.B_APP_MINEPRINT.f_93624_ = !this.settingsOpen;
        this.B_APP_INFO.f_93624_ = !this.settingsOpen;
        this.B_CHANGE_BG_LEFT.f_93624_ = this.settingsOpen;
        this.B_CHANGE_BG_RIGHT.f_93624_ = this.settingsOpen;
    }

    private void B_Open_App(int tipo) {
        if (this.isOpeningApp) {
            return;
        }
        this.isOpeningApp = true;
        AdvancedButton bSelect = tipo == 2 ? this.B_APP_INFO : (tipo == 0 ? this.B_APP_BLUEPRINT : this.B_APP_MINEPRINT);
        bSelect.f_93624_ = false;
        this.OAA.start(tipo);
    }

    private void re_init() {
        while (this.f_169369_.size() > 0) {
            this.m_169411_((GuiEventListener)this.f_169369_.get(0));
        }
        this.m_7856_();
    }

    public void m_86600_() {
        super.m_86600_();
        this.TickCount = (short)(this.TickCount + 1);
        if (this.TickCount > 20) {
            this.TickCount = 1;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.settingsOpen) {
            for (linkItem li : this.linkItems) {
                if (li == null || !li.isOver) continue;
                li.use();
                break;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7043_() {
        return false;
    }

    public static void renderTabletBackground(GuiGraphics gg, int CentroX, int CentroY, String bgName) {
        gg.m_280218_(TEXTURE, CentroX - 77, CentroY - 104, 0, 0, 154, 208);
        ResourceLocation bg = new ResourceLocation("portable_blueprints", "textures/gui/tablet/backgrounds/" + bgName + ".png");
        if (Minecraft.m_91087_().m_91098_().m_213713_(bg).isPresent()) {
            gg.m_280218_(bg, CentroX - 70, CentroY - 97, 0, 0, 140, 186);
        }
    }

    public static void renderTabletUpBar(GuiGraphics gg, int CentroX, int CentroY) {
        gg.m_280509_(CentroX - 70, CentroY - 97, CentroX + 70, CentroY - 87, -1442840576);
        RenderingMethods.GuiGraphicsTestoScalato(gg, Operazioni.getWorldTimeString(), 0.8f, Minecraft.m_91087_().f_91062_, new Vec2((float)(CentroX - 67), (float)(CentroY - 92)), 0xFFFFFF, false, RenderingMethods.PosizioneTesto.SINISTRA, true);
        gg.m_280218_(TEXTURE, CentroX + 44, CentroY - 96, 0, 217, 23, 7);
    }

    public static AdvancedButton getTabletButton(int CentroX, int CentroY) {
        int posX = CentroX - 15;
        int posY = CentroY + 90;
        return AdvancedButton.builder((Component)Component.m_237113_((String)""), button -> TabletScreen.OpenGUI(false)).pos(posX, posY).size(30, 11).defaultImage(new AdvancedButton.Image(TEXTURE, posX, posY, 226, 234, 30, 11)).hoverImage(new AdvancedButton.Image(TEXTURE, posX, posY, 226, 245, 30, 11)).build();
    }

    public static void OpenGUI(boolean withAnimation) {
        Minecraft.m_91087_().m_91152_((Screen)new TabletScreen(withAnimation));
    }

    public static void OpenGUI() {
        Minecraft.m_91087_().m_91152_((Screen)new TabletScreen(true));
    }

    public void m_7379_() {
        TabletScreen.resetTablet();
        super.m_7379_();
    }

    public static void resetTablet() {
        for (int requestid : IDSBlueprints) {
            if (!VisualizeBlueprintDatas.BlueprintsMap.containsKey(requestid)) continue;
            VisualizeBlueprintDatas.BlueprintsMap.remove(requestid);
        }
        IDSBlueprints.clear();
    }

    private class linkItem {
        private final Vector2i icon;
        private final String link;
        private boolean isOver = false;
        private static Map<String, Vector2i> Icons = Map.of("general", new Vector2i(134, 238), "discord", new Vector2i(206, 238), "youtube", new Vector2i(188, 238), "instagram", new Vector2i(170, 238), "twitch", new Vector2i(152, 238));

        public linkItem(String link) {
            this.link = link;
            Vector2i icon_v = Icons.get("general");
            try {
                URI uri = new URI(link);
                String host = uri.getHost();
                if (host != null) {
                    String dominio;
                    if (host.startsWith("www.")) {
                        host = host.substring(4);
                    }
                    if (Icons.containsKey(dominio = host.split("\\.")[0])) {
                        icon_v = Icons.get(dominio);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.icon = icon_v;
        }

        public void render(GuiGraphics gg, int posx, int posy, int mouseX, int mouseY) {
            gg.m_280218_(TEXTURE, posx, posy, this.icon.x, this.icon.y, 18, 18);
            if (this.isOver(mouseX, mouseY, posx, posy)) {
                gg.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)this.link), posx + 1 - Minecraft.m_91087_().f_91062_.m_92895_(this.link) / 2, posy - 5);
                gg.m_280218_(TEXTURE, posx + 4, posy - 6, 0, 211, 10, 5);
                this.isOver = true;
            } else {
                this.isOver = false;
            }
        }

        private boolean isOver(int mouseX, int mouseY, int posx, int posy) {
            return mouseX >= posx && mouseX < posx + 18 && mouseY >= posy && mouseY < posy + 18;
        }

        private void use() {
            if (this.isOver) {
                Util.m_137581_().m_137646_(this.link);
            }
        }
    }

    private class OpenAppAnimation {
        public Long StartAnim = 0L;
        public boolean isStarted = false;
        public RenderingMethods.GuiGraphicsElement Icona;
        private int startPX;
        private int startPY;
        private int color = -1;
        private int tipo = -1;

        private OpenAppAnimation() {
        }

        public void start(int tipo) {
            if (tipo == 0) {
                this.Icona = new RenderingMethods.GuiGraphicsElement(new RenderingMethods.GuiGraphicsElement.BLIT_Parametri(0, 0, 192, 0, 32, 32, TEXTURE));
                this.startPX = -60;
                this.startPY = -77;
                this.color = -13864770;
            } else if (tipo == 1) {
                this.Icona = new RenderingMethods.GuiGraphicsElement(new RenderingMethods.GuiGraphicsElement.BLIT_Parametri(0, 0, 224, 0, 32, 32, TEXTURE));
                this.startPX = -18;
                this.startPY = -77;
                this.color = -5383962;
            } else if (tipo == 2) {
                this.Icona = new RenderingMethods.GuiGraphicsElement(new RenderingMethods.GuiGraphicsElement.BLIT_Parametri(0, 0, 192, 32, 32, 32, TEXTURE));
                this.startPX = 28;
                this.startPY = -77;
                this.color = -13198269;
            }
            this.StartAnim = System.currentTimeMillis() + 350L;
            this.isStarted = true;
            this.tipo = tipo;
        }

        public void render(GuiGraphics gg) {
            if (!this.isStarted) {
                return;
            }
            float t = 1.0f - (float)(this.StartAnim - System.currentTimeMillis()) / 350.0f;
            RenderingMethods.enableScissorFromGui(Minecraft.m_91087_(), TabletScreen.this.CentroX - 70, TabletScreen.this.CentroY - 97, 140, 186);
            float t2 = t;
            if (t2 > 1.0f) {
                t2 = 1.0f;
            }
            Vec2 p = new Vec2(Operazioni.lerp(TabletScreen.this.CentroX + this.startPX, TabletScreen.this.CentroX - 16, t2), Operazioni.lerp(TabletScreen.this.CentroY + this.startPY, TabletScreen.this.CentroY - 16, t2));
            int size = (int)Operazioni.lerp(0.0f, 97.0f, t2 / 0.8f);
            gg.m_280509_((int)p.f_82470_ - size + 16, (int)p.f_82471_ - size + 16, (int)p.f_82470_ + size + 16, (int)p.f_82471_ + size + 16, this.color);
            RenderingMethods.disableScissor();
            this.Icona.blitParametri.setPos((int)p.f_82470_, (int)p.f_82471_);
            this.Icona.render(gg);
            if (t > 2.0f) {
                if (this.tipo == 0) {
                    TabletBlueprintScreen.OpenGUI();
                } else if (this.tipo == 1) {
                    TabletMinePrintScreen.OpenGUI(TabletMinePrintScreen.PageType.SERVER);
                } else if (this.tipo == 2) {
                    TabletInfoScreen.OpenGUI();
                }
            }
        }
    }
}

