/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.init.ModItems;

@Mod.EventBusSubscriber(modid="portable_blueprints", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BlueprintWornCommand {
    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"blueprintworn").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"add").executes(ctx -> {
            BlueprintWornCommand.setWornBlueprint(((CommandSourceStack)ctx.getSource()).m_81372_(), ((CommandSourceStack)ctx.getSource()).m_230896_());
            return 1;
        }))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"param", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            for (String perm : BlueprintWornCommand.blueprintEsistenti(((CommandSourceStack)ctx.getSource()).m_81372_())) {
                builder.suggest(perm);
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            String param = StringArgumentType.getString((CommandContext)ctx, (String)"param");
            BlueprintWornCommand.removeWornBlueprint(((CommandSourceStack)ctx.getSource()).m_81372_(), ((CommandSourceStack)ctx.getSource()).m_230896_(), param);
            return 1;
        }))));
    }

    private static void setWornBlueprint(ServerLevel level, ServerPlayer player) {
        if (player == null) {
            return;
        }
        if (player.m_21205_().m_41720_().equals(ModItems.BLUEPRINT.get())) {
            CompoundTag nbt = player.m_21205_().m_41784_();
            if (nbt.m_128441_("owner") && nbt.m_128441_("nome")) {
                if (nbt.m_128461_("nome").contains("[Global]")) {
                    if (player != null) {
                        player.m_240418_((Component)Component.m_237115_((String)"command.portable_blueprints.wornblueprint.set_global_error").m_130940_(ChatFormatting.RED), false);
                    }
                    return;
                }
                boolean successo = BlueprintWornCommand.addWornBlueprint(level, nbt.m_128461_("nome"), nbt.m_128461_("owner"));
                if (!successo) {
                    if (player != null) {
                        player.m_240418_((Component)Component.m_237115_((String)"command.portable_blueprints.wornblueprint.not_found").m_130940_(ChatFormatting.RED), false);
                    }
                    return;
                }
                if (player != null) {
                    player.m_240418_((Component)Component.m_237115_((String)"command.portable_blueprints.wornblueprint.set_success").m_130940_(ChatFormatting.GREEN), false);
                }
            } else if (player != null) {
                player.m_240418_((Component)Component.m_237115_((String)"command.portable_blueprints.wornblueprint.not_valid_item").m_130940_(ChatFormatting.RED), false);
            }
        } else if (player != null) {
            player.m_240418_((Component)Component.m_237115_((String)"command.portable_blueprints.wornblueprint.no_item").m_130940_(ChatFormatting.RED), false);
        }
    }

    private static boolean addWornBlueprint(ServerLevel level, String nome, String owner) {
        File folderWornBlueprints = new File(Blueprint.getWornBlueprintFile(level), nome + ".bp");
        File original = null;
        for (File file : Blueprint.getFileForBlueprints(level, UUID.fromString(owner)).listFiles()) {
            if (!file.getName().equals(nome + ".bp")) continue;
            original = file;
            break;
        }
        if (original != null) {
            try {
                Files.copy(original.toPath(), folderWornBlueprints.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static void removeWornBlueprint(ServerLevel level, ServerPlayer player, String nome) {
        File blueprintFile = null;
        for (File file : Blueprint.getWornBlueprintFile(level).listFiles()) {
            if (!file.getName().equals(nome + ".bp")) continue;
            blueprintFile = file;
            break;
        }
        if (blueprintFile != null) {
            if (blueprintFile.delete()) {
                if (player != null) {
                    player.m_240418_((Component)Component.m_237115_((String)"command.portable_blueprints.wornblueprint.delete_success").m_130940_(ChatFormatting.GREEN), false);
                }
            } else if (player != null) {
                player.m_240418_((Component)Component.m_237115_((String)"command.portable_blueprints.wornblueprint.delete_error").m_130940_(ChatFormatting.RED), false);
            }
        } else if (player != null) {
            player.m_240418_((Component)Component.m_237115_((String)"command.portable_blueprints.wornblueprint.not_found").m_130940_(ChatFormatting.RED), false);
        }
    }

    private static List<String> blueprintEsistenti(ServerLevel level) {
        ArrayList<String> nomi = new ArrayList<String>();
        for (File file : Blueprint.getWornBlueprintFile(level).listFiles()) {
            nomi.add(file.getName().replace(".bp", ""));
        }
        return nomi;
    }
}

