/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.entity.custom;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class BusinessVillagerEntity
extends Mob {
    public static Map<UUID, BusinessVillagerEntity> listaBVEVivi = new HashMap<UUID, BusinessVillagerEntity>();
    private static final EntityDataAccessor<Optional<UUID>> TARGETBP = SynchedEntityData.m_135353_(BusinessVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public boolean selezionato = false;
    public boolean inviato = false;
    public final AnimationState spawnAnimationState = new AnimationState();
    public float animationProgress = 0.0f;
    public boolean isSpawning = true;
    public int tickAlive = 1000;

    public BusinessVillagerEntity(EntityType<? extends BusinessVillagerEntity> type, Level level) {
        super(type, level);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            if (this.isSpawning) {
                this.animationProgress += 0.05f;
                if (this.animationProgress >= 1.0f) {
                    this.animationProgress = 1.0f;
                    this.isSpawning = false;
                }
            }
            if (!this.inviato && this.getTargetBP().equals(Minecraft.m_91087_().f_91074_.m_20148_())) {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"portable_blueprints.gui.entity.businessvillager.text"), false);
                this.inviato = true;
            }
        } else {
            --this.tickAlive;
            if (this.tickAlive <= 0 || this.getTargetBP() == null) {
                this.poofParticle();
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public void setTargetBP(UUID uuid) {
        this.f_19804_.m_135381_(TARGETBP, Optional.ofNullable(uuid));
        if (listaBVEVivi.containsKey(uuid) && listaBVEVivi.get(uuid) != null) {
            this.poofParticle();
            BusinessVillagerEntity.listaBVEVivi.get((Object)uuid).tickAlive = -1;
        }
        listaBVEVivi.put(uuid, this);
    }

    @Nullable
    public UUID getTargetBP() {
        return ((Optional)this.f_19804_.m_135370_(TARGETBP)).orElse(null);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGETBP, Optional.empty());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22277_, 0.0);
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.emptyList();
    }

    public ItemStack m_6844_(EquipmentSlot equipmentSlot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot equipmentSlot, ItemStack itemStack) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public void m_8107_() {
    }

    public boolean m_20147_() {
        return true;
    }

    public boolean m_6469_(DamageSource src, float amount) {
        if (src.m_276093_(DamageTypes.f_286979_)) {
            return super.m_6469_(src, amount);
        }
        return false;
    }

    public boolean m_6673_(DamageSource src) {
        return !src.m_276093_(DamageTypes.f_286979_);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.poofParticle();
    }

    public void m_6667_(DamageSource p_21014_) {
        super.m_6667_(p_21014_);
        if (!this.m_9236_().f_46443_) {
            UUID toremove = null;
            for (UUID uuid : listaBVEVivi.keySet()) {
                if (!listaBVEVivi.get(uuid).equals((Object)this)) continue;
                toremove = uuid;
                break;
            }
            if (toremove != null) {
                listaBVEVivi.remove(toremove);
            }
        }
        this.poofParticle();
    }

    private void poofParticle() {
        if (!this.m_9236_().f_46443_) {
            AABB box = this.m_20191_();
            double w = box.m_82362_() / 2.0;
            double h = box.m_82376_();
            double d = box.m_82385_() / 2.0;
            for (int i = 0; i < 40; ++i) {
                double dx = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * w;
                double dy = this.m_20186_() + this.f_19796_.m_188500_() * h;
                double dz = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * d;
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123759_, dx, dy, dz, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

