/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.mod_compatibility.sophisticatedbackpacks;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlockEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import nimble.portable_blueprints.mod_compatibility.ModCompatibilityInit;
import nimble.portable_blueprints.portable_blueprints.Mod;
import nimble.portable_blueprints.robautile.ModifiableItemInventory;
import nimble.portable_blueprints.robautile.Operazioni;

public class SophisticatedBackpacksMetodi {
    public static boolean isABackpack(ItemStack itemStack) {
        if (!ModCompatibilityInit.isSophisticatedBackpacksLoaded) {
            return false;
        }
        return BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_()).m_135827_().equals("sophisticatedbackpacks");
    }

    public static boolean isABackpack(BlockEntity blockEntity) {
        if (!ModCompatibilityInit.isSophisticatedBackpacksLoaded) {
            return false;
        }
        return blockEntity instanceof BackpackBlockEntity;
    }

    public static InventoryHandler getInventoryFromBackpack(ItemStack backpack) {
        if (!ModCompatibilityInit.isSophisticatedBackpacksLoaded) {
            return null;
        }
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        if (backpack == null || backpack.m_41619_()) {
            return null;
        }
        backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> wrapper.getContentsUuid().ifPresent(uuid -> {
            InventoryHandler handler = wrapper.getInventoryHandler();
            result.set(handler);
        }));
        return result.get();
    }

    public static InventoryHandler getInventoryFromBackpack(BlockEntity backpack) {
        if (!ModCompatibilityInit.isSophisticatedBackpacksLoaded) {
            return null;
        }
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)backpack;
        IBackpackWrapper wrapper = backpackBlockEntity.getBackpackWrapper();
        wrapper.getContentsUuid().ifPresent(uuid -> {
            InventoryHandler handler = wrapper.getInventoryHandler();
            result.set(handler);
        });
        return result.get();
    }

    public static Tuple<Boolean, Vec3> removeItemFromBackpack(ServerPlayer player, ServerLevel level, ItemStack backpack, Item Target) {
        if (!ModCompatibilityInit.isSophisticatedBackpacksLoaded) {
            return null;
        }
        InventoryHandler inventoryHandler = SophisticatedBackpacksMetodi.getInventoryFromBackpack(backpack);
        if (inventoryHandler == null) {
            return null;
        }
        return SophisticatedBackpacksMetodi.inventoryRemoveTargetItem(player, level, inventoryHandler, Target);
    }

    public static Tuple<Boolean, Vec3> removeItemFromBackpack(ServerPlayer player, ServerLevel level, BlockEntity backpack, Item Target, BlockPos posizione) {
        if (!ModCompatibilityInit.isSophisticatedBackpacksLoaded) {
            return null;
        }
        InventoryHandler inventoryHandler = SophisticatedBackpacksMetodi.getInventoryFromBackpack(backpack);
        if (inventoryHandler == null) {
            return null;
        }
        for (int x = 0; x < inventoryHandler.getSlots(); ++x) {
            Object v;
            ItemStack item = inventoryHandler.getStackInSlot(x);
            if (item.m_41720_().equals(Target)) {
                if (item.m_41720_().equals(Items.f_42447_) || item.m_41720_().equals(Items.f_42448_)) {
                    item.m_41764_(item.m_41613_() - 1);
                    int item_rimasti = Operazioni.addItemToInventory(player.m_150109_(), new ItemStack((ItemLike)Items.f_42446_), 1);
                    if (item_rimasti > 0) {
                        Operazioni.dropItem((Level)level, player.m_20182_(), new ItemStack((ItemLike)Items.f_42446_));
                    }
                } else {
                    item.m_41764_(item.m_41613_() - 1);
                }
                return new Tuple((Object)true, (Object)posizione.m_252807_());
            }
            if (SophisticatedBackpacksMetodi.isABackpack(item)) {
                v = SophisticatedBackpacksMetodi.removeItemFromBackpack(player, level, item, Target);
                if (v == null) continue;
                return new Tuple((Object)true, (Object)posizione.m_252807_());
            }
            if (Mod.ListaModContainerNonConsentiti.contains(BuiltInRegistries.f_257033_.m_7981_((Object)item.m_41720_()).m_135827_())) continue;
            v = new AtomicReference();
            ModifiableItemInventory.of(item).ifPresent(inv -> {
                Container container_item = inv.getContainer();
                for (int xItem = 0; xItem < container_item.m_6643_(); ++xItem) {
                    ItemStack itemStack = container_item.m_8020_(xItem);
                    if (!itemStack.m_41720_().equals(Target)) continue;
                    if (itemStack.m_41720_().equals(Items.f_42447_) || itemStack.m_41720_().equals(Items.f_42448_)) {
                        itemStack.m_41764_(itemStack.m_41613_() - 1);
                        int item_rimasti = Operazioni.addItemToInventory(player.m_150109_(), new ItemStack((ItemLike)Items.f_42446_), 1);
                        if (item_rimasti > 0) {
                            Operazioni.dropItem((Level)level, player.m_20182_(), new ItemStack((ItemLike)Items.f_42446_));
                        }
                    } else {
                        itemStack.m_41764_(itemStack.m_41613_() - 1);
                    }
                    v.set(new Tuple((Object)true, (Object)posizione.m_252807_()));
                    break;
                }
                inv.save();
            });
            if (((AtomicReference)v).get() == null) continue;
            return (Tuple)((AtomicReference)v).get();
        }
        return SophisticatedBackpacksMetodi.inventoryRemoveTargetItem(player, level, inventoryHandler, Target);
    }

    public static void getAllItemFromBackpack(ItemStack backpack, Map<Item, Integer> ItemQuantity) {
        if (!ModCompatibilityInit.isSophisticatedBackpacksLoaded) {
            return;
        }
        InventoryHandler inventoryHandler = SophisticatedBackpacksMetodi.getInventoryFromBackpack(backpack);
        if (inventoryHandler == null) {
            return;
        }
        SophisticatedBackpacksMetodi.inventoryGetAllItemFromBackpack(backpack.m_41613_(), inventoryHandler, ItemQuantity);
    }

    public static void getAllItemFromBackpack(BlockEntity backpack, Map<Item, Integer> ItemQuantity) {
        if (!ModCompatibilityInit.isSophisticatedBackpacksLoaded) {
            return;
        }
        InventoryHandler inventoryHandler = SophisticatedBackpacksMetodi.getInventoryFromBackpack(backpack);
        if (inventoryHandler == null) {
            return;
        }
        SophisticatedBackpacksMetodi.inventoryGetAllItemFromBackpack(1, inventoryHandler, ItemQuantity);
    }

    private static Tuple<Boolean, Vec3> inventoryRemoveTargetItem(ServerPlayer player, ServerLevel level, InventoryHandler inventoryHandler, Item Target) {
        Tuple v = null;
        for (int slot = 0; slot < inventoryHandler.getSlots(); ++slot) {
            ItemStack itemStack = inventoryHandler.getStackInSlot(slot);
            if (!itemStack.m_41720_().equals(Target)) continue;
            if (itemStack.m_41720_().equals(Items.f_42447_) || itemStack.m_41720_().equals(Items.f_42448_)) {
                itemStack.m_41764_(itemStack.m_41613_() - 1);
                int item_rimasti = Operazioni.addItemToInventory(player.m_150109_(), new ItemStack((ItemLike)Items.f_42446_), 1);
                if (item_rimasti > 0) {
                    Operazioni.dropItem((Level)level, player.m_20182_(), new ItemStack((ItemLike)Items.f_42446_));
                }
            } else {
                itemStack.m_41764_(itemStack.m_41613_() - 1);
            }
            v = new Tuple((Object)true, (Object)player.m_20182_().m_82520_(0.0, 1.0, 0.0));
            break;
        }
        return v;
    }

    private static void inventoryGetAllItemFromBackpack(int count, InventoryHandler inventoryHandler, Map<Item, Integer> ItemQuantity) {
        for (int slot = 0; slot < inventoryHandler.getSlots(); ++slot) {
            ItemStack itemStack = inventoryHandler.getStackInSlot(slot);
            if (ItemQuantity.containsKey(itemStack.m_41720_())) {
                ItemQuantity.replace(itemStack.m_41720_(), ItemQuantity.get(itemStack.m_41720_()) + itemStack.m_41613_() * count);
                continue;
            }
            ItemQuantity.put(itemStack.m_41720_(), itemStack.m_41613_() * count);
        }
    }
}

