/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.ServerBlueprints;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.client.ServerToClientDatasShared;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.ServerBlueprints.StoC_ServerBlueprintsData;

public class CtoS_ServerBlueprintsData {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    final UUID randomUUIDSending;

    public CtoS_ServerBlueprintsData() {
        ServerToClientDatasShared.endTrasferingServerBlueprints = false;
        this.randomUUIDSending = UUID.randomUUID();
    }

    public CtoS_ServerBlueprintsData(FriendlyByteBuf buffer) {
        this.randomUUIDSending = buffer.m_130259_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.randomUUIDSending);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ServerLevel level = player.m_284548_();
            File permissionFile = Blueprint.getServerPremissionFile(level);
            Blueprint.BlueprintPermission bp = null;
            try {
                bp = (Blueprint.BlueprintPermission)GSON.fromJson((Reader)new FileReader(permissionFile), Blueprint.BlueprintPermission.class);
                PacketHandler.sendToPlayer(new StoC_ServerBlueprintsData("<START>", this.randomUUIDSending), player);
                for (String v : bp.getPlayerAllAllowedBlueprints(player.m_20148_())) {
                    PacketHandler.sendToPlayer(new StoC_ServerBlueprintsData(v, this.randomUUIDSending), player);
                }
                PacketHandler.sendToPlayer(new StoC_ServerBlueprintsData("<END>", this.randomUUIDSending), player);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        return true;
    }
}

