/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.blueprint_tags;

import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.init.ModTabletTags;

public class CtoS_SetBlueprintTag {
    private final UUID OwnerBP;
    private final String BPName;
    private final String TagID;
    private final boolean toAdd;

    public CtoS_SetBlueprintTag(UUID OwnerBP, String BPName, String TagID, boolean toAdd) {
        this.OwnerBP = OwnerBP;
        this.BPName = BPName;
        this.TagID = TagID;
        this.toAdd = toAdd;
    }

    public CtoS_SetBlueprintTag(FriendlyByteBuf buffer) {
        this.OwnerBP = buffer.readBoolean() ? buffer.m_130259_() : null;
        this.BPName = buffer.m_130277_();
        this.TagID = buffer.m_130277_();
        this.toAdd = buffer.readBoolean();
    }

    public void encode(FriendlyByteBuf buffer) {
        if (this.OwnerBP == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.m_130077_(this.OwnerBP);
        }
        buffer.m_130070_(this.BPName);
        buffer.m_130070_(this.TagID);
        buffer.writeBoolean(this.toAdd);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            String key;
            ServerPlayer player = context.getSender();
            ServerLevel level = player.m_284548_();
            String id = Blueprint.getIDBlueprint(level, key = this.OwnerBP == null ? "server" : this.OwnerBP.toString(), this.OwnerBP, this.BPName);
            if (!id.isEmpty()) {
                if (!ModTabletTags.BlueprintTagsData.containsKey(id)) {
                    ModTabletTags.BlueprintTagsData.put(id, new ArrayList());
                }
                if (this.toAdd) {
                    if (!ModTabletTags.BlueprintTagsData.get(id).contains(this.TagID)) {
                        ModTabletTags.BlueprintTagsData.get(id).add(this.TagID);
                    }
                } else {
                    ModTabletTags.BlueprintTagsData.get(id).remove(this.TagID);
                }
                if (ModTabletTags.BlueprintTagsData.get(id).isEmpty()) {
                    ModTabletTags.BlueprintTagsData.remove(id);
                }
            }
        });
        return true;
    }
}

