/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.global_blueprint_net;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.init.ModGameRules;
import nimble.portable_blueprints.robautile.Operazioni;

public class CtoS_SaveGlobalBlueprintInServer {
    public static Map<UUID, Boolean> StaGiaGestendoUnaBlueprint = new HashMap<UUID, Boolean>();
    public static Map<UUID, String> ID_blueprint_in_gestione = new HashMap<UUID, String>();
    public static Map<UUID, String> NOME_BLUEPRINT = new HashMap<UUID, String>();
    public final String valore;

    public CtoS_SaveGlobalBlueprintInServer() {
        this.valore = "";
    }

    public CtoS_SaveGlobalBlueprintInServer(String valore) {
        this.valore = valore;
    }

    public CtoS_SaveGlobalBlueprintInServer(FriendlyByteBuf buffer) {
        this.valore = buffer.m_130277_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.valore);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ServerLevel level = player.m_284548_();
            UUID uuidPlayer = player.m_20148_();
            if (level.m_46469_().m_46207_(ModGameRules.AllowGlobalBlueprints)) {
                if (!StaGiaGestendoUnaBlueprint.containsKey(uuidPlayer)) {
                    StaGiaGestendoUnaBlueprint.put(uuidPlayer, false);
                }
                if (!ID_blueprint_in_gestione.containsKey(uuidPlayer)) {
                    ID_blueprint_in_gestione.put(uuidPlayer, "");
                }
                if (!NOME_BLUEPRINT.containsKey(uuidPlayer)) {
                    NOME_BLUEPRINT.put(uuidPlayer, "");
                }
                if (this.valore.contains("[INIZIO DATI BLUEPRINT ") && !StaGiaGestendoUnaBlueprint.get(uuidPlayer).booleanValue()) {
                    StaGiaGestendoUnaBlueprint.put(uuidPlayer, true);
                    ID_blueprint_in_gestione.put(uuidPlayer, Operazioni.getValueInsideTag(this.valore, "id"));
                    NOME_BLUEPRINT.put(uuidPlayer, Operazioni.getValueInsideTag(this.valore, "nome") + " [Global]");
                    try {
                        if (new File(Blueprint.getFileForBlueprints(level, uuidPlayer), NOME_BLUEPRINT.get(uuidPlayer) + ".bp").exists()) {
                            new File(Blueprint.getFileForBlueprints(level, uuidPlayer), NOME_BLUEPRINT.get(uuidPlayer) + ".bp").delete();
                        }
                        File f = new File(Blueprint.getFileForBlueprints(level, uuidPlayer), NOME_BLUEPRINT.get(uuidPlayer) + ".tmp");
                        f.createNewFile();
                        Files.write(f.toPath(), "".getBytes(), new OpenOption[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (this.valore.contains("[FINE DATI BLUEPRINT DI ID: ") && StaGiaGestendoUnaBlueprint.get(uuidPlayer).booleanValue() && this.valore.contains(ID_blueprint_in_gestione.get(uuidPlayer))) {
                    Object nome = NOME_BLUEPRINT.get(uuidPlayer);
                    int count = 0;
                    while (Blueprint.BlueprintExist(level, (String)nome, uuidPlayer)) {
                        nome = NOME_BLUEPRINT.get(uuidPlayer);
                        String add = "(" + count + ")";
                        if (((String)nome).length() + add.length() > 25) {
                            nome = ((String)nome).substring(0, 25 - add.length());
                        }
                        nome = (String)nome + add;
                        ++count;
                    }
                    if (((String)nome).length() > 25) {
                        nome = ((String)nome).substring(0, 25);
                    }
                    new File(Blueprint.getFileForBlueprints(level, uuidPlayer), NOME_BLUEPRINT.get(uuidPlayer) + ".tmp").renameTo(new File(Blueprint.getFileForBlueprints(level, uuidPlayer), (String)nome + ".bp"));
                    NOME_BLUEPRINT.put(uuidPlayer, "");
                    StaGiaGestendoUnaBlueprint.put(uuidPlayer, false);
                    ID_blueprint_in_gestione.put(uuidPlayer, "");
                } else if (this.valore.contains("[" + ID_blueprint_in_gestione.get(uuidPlayer) + "]")) {
                    try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(Blueprint.getFileForBlueprints(level, uuidPlayer), NOME_BLUEPRINT.get(uuidPlayer) + ".tmp"), true));){
                        writer.write(this.valore.replace("[" + ID_blueprint_in_gestione.get(uuidPlayer) + "]", ""));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        return true;
    }

    public static void resetPlayer(UUID uuid) {
        NOME_BLUEPRINT.remove(uuid);
        StaGiaGestendoUnaBlueprint.remove(uuid);
        ID_blueprint_in_gestione.remove(uuid);
    }
}

