/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.request_ids_blueprints;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.request_ids_blueprints.StoC_RequestIDsBlueprints;

public class CtoS_RequestIDsBlueprints {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    final Tipo tipo;
    final String BPnome;
    final UUID owner;
    final int idRequest;
    final String namespace;

    public CtoS_RequestIDsBlueprints(UUID owner, String BPnome, int idRequest, String namespace) {
        this.tipo = Tipo.PERSONAL;
        this.owner = owner;
        this.BPnome = BPnome;
        this.idRequest = idRequest;
        this.namespace = namespace;
    }

    public CtoS_RequestIDsBlueprints(boolean isServer, String BPnome, int idRequest, String namespace) {
        this.tipo = Tipo.SERVER;
        this.owner = null;
        this.BPnome = BPnome;
        this.idRequest = idRequest;
        this.namespace = namespace;
    }

    public CtoS_RequestIDsBlueprints(boolean isServer) {
        this.tipo = Tipo.SERVER;
        this.owner = null;
        this.BPnome = "";
        this.idRequest = -1;
        this.namespace = "";
    }

    public CtoS_RequestIDsBlueprints(FriendlyByteBuf buffer) {
        this.tipo = (Tipo)buffer.m_130066_(Tipo.class);
        this.BPnome = buffer.m_130277_();
        this.idRequest = buffer.readInt();
        this.namespace = buffer.m_130277_();
        this.owner = this.tipo.equals((Object)Tipo.PERSONAL) ? buffer.m_130259_() : null;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.tipo);
        buffer.m_130070_(this.BPnome);
        buffer.writeInt(this.idRequest);
        buffer.m_130070_(this.namespace);
        if (this.tipo.equals((Object)Tipo.PERSONAL)) {
            buffer.m_130077_(this.owner);
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ServerLevel level = player.m_284548_();
            if (this.tipo.equals((Object)Tipo.PERSONAL)) {
                File blueprintFile = Arrays.stream(Blueprint.getFileForBlueprints(level, this.owner).listFiles()).filter(f -> f.getName().equals(this.BPnome + ".bp")).findFirst().orElse(null);
                if (blueprintFile != null) {
                    try {
                        Blueprint.BlueprintDatas bd = (Blueprint.BlueprintDatas)GSON.fromJson((Reader)new FileReader(blueprintFile), Blueprint.BlueprintDatas.class);
                        if (bd != null) {
                            PacketHandler.sendToPlayer(new StoC_RequestIDsBlueprints(Blueprint.getIDBlueprint(this.namespace, bd), this.idRequest), player);
                        }
                    }
                    catch (Exception exception) {}
                }
            } else if (this.tipo.equals((Object)Tipo.SERVER)) {
                try {
                    for (File bpS : Blueprint.getServerBlueprintFile(level).listFiles()) {
                        Blueprint.BlueprintDatas bd;
                        if (!bpS.getName().endsWith(".bp") || !this.BPnome.isEmpty() && !this.BPnome.equals(bpS.getName().replace(".bp", "")) || (bd = (Blueprint.BlueprintDatas)GSON.fromJson((Reader)new FileReader(bpS), Blueprint.BlueprintDatas.class)) == null) continue;
                        PacketHandler.sendToPlayer(new StoC_RequestIDsBlueprints(Blueprint.getIDBlueprint(this.namespace, bd), this.idRequest), player);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return true;
    }

    public static enum Tipo {
        PERSONAL,
        SERVER;

    }
}

