/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.request_specific_data;

import java.io.File;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import nimble.portable_blueprints.altro.Blueprint;
import nimble.portable_blueprints.client.ServerToClientDatasShared;
import nimble.portable_blueprints.init.ModGameRules;
import nimble.portable_blueprints.network.PacketHandler;
import nimble.portable_blueprints.network.request_specific_data.StoC_RequestSpecificData;
import nimble.portable_blueprints.portable_blueprints.ModServerConfig;

public class CtoS_RequestSpecificData {
    private final int idRichesta;
    private final TipoRichiesta tipoRichiesta;

    public CtoS_RequestSpecificData() {
        this.idRichesta = -1;
        this.tipoRichiesta = null;
    }

    public CtoS_RequestSpecificData(int idRichesta, TipoRichiesta tipoRichiesta) {
        this.idRichesta = idRichesta;
        this.tipoRichiesta = tipoRichiesta;
        switch (this.tipoRichiesta) {
            case MAX_DIGITIZED_STRUCTURES_FOR_PLAYER: 
            case MAX_STRUCTURE_BLOCK_COUNT: {
                ServerToClientDatasShared.RichiesteInteger.remove(this.idRichesta);
                break;
            }
            case ALLOW_GLOBAL_BLUEPRINTS: 
            case IS_PLAYER_OP: {
                ServerToClientDatasShared.RichiesteBooleane.remove(this.idRichesta);
                break;
            }
            case GET_TABLET_SOCIAL_LINKS: {
                ServerToClientDatasShared.RichiestaString.remove(this.idRichesta);
            }
        }
    }

    public CtoS_RequestSpecificData(FriendlyByteBuf buffer) {
        this.idRichesta = buffer.readInt();
        this.tipoRichiesta = (TipoRichiesta)buffer.m_130066_(TipoRichiesta.class);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.idRichesta);
        buffer.m_130068_((Enum)this.tipoRichiesta);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ServerLevel level = player.m_284548_();
            switch (this.tipoRichiesta) {
                case MAX_DIGITIZED_STRUCTURES_FOR_PLAYER: {
                    PacketHandler.sendToPlayer(new StoC_RequestSpecificData(this.idRichesta, level.m_6106_().m_5470_().m_46215_(ModGameRules.Max_digitized_structures_for_player)), player);
                    break;
                }
                case MAX_STRUCTURE_BLOCK_COUNT: {
                    PacketHandler.sendToPlayer(new StoC_RequestSpecificData(this.idRichesta, level.m_6106_().m_5470_().m_46215_(ModGameRules.MaxScannerBlockCount)), player);
                    break;
                }
                case ALLOW_GLOBAL_BLUEPRINTS: {
                    PacketHandler.sendToPlayer(new StoC_RequestSpecificData(this.idRichesta, level.m_6106_().m_5470_().m_46207_(ModGameRules.AllowGlobalBlueprints)), player);
                    break;
                }
                case IS_PLAYER_OP: {
                    PacketHandler.sendToPlayer(new StoC_RequestSpecificData(this.idRichesta, player.m_20310_(3)), player);
                    break;
                }
                case GET_TABLET_SOCIAL_LINKS: {
                    PacketHandler.sendToPlayer(new StoC_RequestSpecificData(this.idRichesta, ModServerConfig.tablet_social_1 + ";" + ModServerConfig.tablet_social_2 + ";" + ModServerConfig.tablet_social_3 + ";" + ModServerConfig.tablet_social_4 + ";" + ModServerConfig.tablet_social_5), player);
                    break;
                }
                case PLAYER_BLUEPRINTS_QUANTITY: {
                    int risultato = 0;
                    for (File file : Blueprint.getFileForBlueprints(level, player.m_20148_()).listFiles()) {
                        if (!file.getName().contains(".bp")) continue;
                        ++risultato;
                    }
                    PacketHandler.sendToPlayer(new StoC_RequestSpecificData(this.idRichesta, risultato), player);
                }
            }
        });
        return true;
    }

    public static enum TipoRichiesta {
        MAX_DIGITIZED_STRUCTURES_FOR_PLAYER,
        MAX_STRUCTURE_BLOCK_COUNT,
        ALLOW_GLOBAL_BLUEPRINTS,
        IS_PLAYER_OP,
        PLAYER_BLUEPRINTS_QUANTITY,
        GET_TABLET_SOCIAL_LINKS;

    }
}

