/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.network.request_specific_data;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import nimble.portable_blueprints.client.ServerToClientDatasShared;

public class StoC_RequestSpecificData {
    private final int IDRichiesta;
    private final int int_valore;
    private final boolean bool_valore;
    private final TipoDato tipoDato;
    private final String string_valore;

    public StoC_RequestSpecificData() {
        this.IDRichiesta = -1;
        this.int_valore = 0;
        this.tipoDato = TipoDato.BOOL;
        this.bool_valore = false;
        this.string_valore = "";
    }

    public StoC_RequestSpecificData(int IDRichiesta, int valore) {
        this.IDRichiesta = IDRichiesta;
        this.int_valore = valore;
        this.tipoDato = TipoDato.INT;
        this.bool_valore = false;
        this.string_valore = "";
    }

    public StoC_RequestSpecificData(int IDRichiesta, boolean valore) {
        this.IDRichiesta = IDRichiesta;
        this.int_valore = 0;
        this.tipoDato = TipoDato.BOOL;
        this.bool_valore = valore;
        this.string_valore = "";
    }

    public StoC_RequestSpecificData(int IDRichiesta, String valore) {
        this.IDRichiesta = IDRichiesta;
        this.int_valore = 0;
        this.tipoDato = TipoDato.STRING;
        this.bool_valore = false;
        this.string_valore = valore;
    }

    public StoC_RequestSpecificData(FriendlyByteBuf buffer) {
        this.IDRichiesta = buffer.readInt();
        this.tipoDato = (TipoDato)buffer.m_130066_(TipoDato.class);
        int int_v = 0;
        boolean bool_v = false;
        String string_v = "";
        switch (this.tipoDato) {
            case INT: {
                int_v = buffer.readInt();
                break;
            }
            case BOOL: {
                bool_v = buffer.readBoolean();
                break;
            }
            case STRING: {
                string_v = buffer.m_130277_();
            }
        }
        this.int_valore = int_v;
        this.bool_valore = bool_v;
        this.string_valore = string_v;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.IDRichiesta);
        buffer.m_130068_((Enum)this.tipoDato);
        switch (this.tipoDato) {
            case INT: {
                buffer.writeInt(this.int_valore);
                break;
            }
            case BOOL: {
                buffer.writeBoolean(this.bool_valore);
                break;
            }
            case STRING: {
                buffer.m_130070_(this.string_valore);
            }
        }
    }

    public static void handle(StoC_RequestSpecificData msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            switch (msg.tipoDato) {
                case INT: {
                    ServerToClientDatasShared.addRichiestaInteger(msg.IDRichiesta, msg.int_valore);
                    break;
                }
                case BOOL: {
                    ServerToClientDatasShared.addRichiestaBooleana(msg.IDRichiesta, msg.bool_valore);
                    break;
                }
                case STRING: {
                    ServerToClientDatasShared.addRichiestaString(msg.IDRichiesta, msg.string_valore);
                }
            }
        });
    }

    public static enum TipoDato {
        BOOL,
        INT,
        STRING;

    }
}

