/*
 * Decompiled with CFR 0.152.
 */
package nimble.portable_blueprints.robautile;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedEditBox
extends EditBox {
    private final Font font;
    private final float fontSize;
    private Component Message;
    private boolean visibleText;
    private ColorHover colorHover;

    public AdvancedEditBox(int pX, int pY, int pWidth, int pHeight, Component pMessage, Font font, float fontSize, ColorHover colorHover, boolean withBorder, boolean visibleText) {
        super(font, pX, pY, pWidth, pHeight, pMessage);
        this.Message = pMessage;
        this.font = Minecraft.m_91087_().f_91062_;
        this.colorHover = colorHover;
        this.m_94182_(withBorder);
        this.visibleText = visibleText;
        this.fontSize = fontSize;
    }

    public AdvancedEditBox(Builder builder) {
        this(builder.x, builder.y, builder.width, builder.height, builder.message, builder.font, builder.fontSize, builder.colorHover, builder.withBorder, builder.visibleText);
        this.m_257544_(builder.tooltip);
    }

    public static Builder builder(Component pMessage) {
        return new Builder(pMessage);
    }

    public void m_88315_(GuiGraphics guiGraphics, int MouseX, int MouseY, float p_93660_) {
        if (!this.visibleText) {
            return;
        }
        super.m_88315_(guiGraphics, MouseX, MouseY, p_93660_);
        if (this.colorHover != null && !this.m_93696_() && this.m_5953_(MouseX, MouseY)) {
            RenderSystem.setShaderColor((float)((float)(this.colorHover.R / 255.0)), (float)((float)(this.colorHover.G / 255.0)), (float)((float)(this.colorHover.B / 255.0)), (float)((float)(this.colorHover.alpha / 255.0)));
            guiGraphics.m_280509_((int)this.colorHover.StartPos.f_82470_, (int)this.colorHover.StartPos.f_82471_, (int)this.colorHover.EndPos.f_82470_, (int)this.colorHover.EndPos.f_82471_, -1);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static class ColorHover {
        public double R;
        public double G;
        public double B;
        public double alpha;
        public Vec2 StartPos;
        public Vec2 EndPos;

        public ColorHover(int Color, Vec2 StartPos, Vec2 EndPos) {
            this.alpha = Color >> 24 & 0xFF;
            this.R = Color >> 16 & 0xFF;
            this.G = Color >> 8 & 0xFF;
            this.B = Color & 0xFF;
            this.StartPos = StartPos;
            this.EndPos = EndPos;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final Component message;
        private int x;
        private int y;
        private int width = 150;
        private int height = 20;
        private Tooltip tooltip;
        private float fontSize = 1.0f;
        private boolean withBorder = true;
        private boolean visibleText = true;
        private Font font;
        private ColorHover colorHover;

        public Builder(Component TestoPulsante) {
            this.font = Minecraft.m_91087_().f_91062_;
            this.message = TestoPulsante;
        }

        public Builder pos(int pX, int pY) {
            this.x = pX;
            this.y = pY;
            return this;
        }

        public Builder size(int pWidth, int pHeight) {
            this.width = pWidth;
            this.height = pHeight;
            return this;
        }

        public Builder tooltip(@Nullable Tooltip pTooltip) {
            this.tooltip = pTooltip;
            return this;
        }

        public Builder addColorHover(ColorHover colorHover) {
            this.colorHover = colorHover;
            return this;
        }

        public Builder setWithBorder(boolean withBorder) {
            this.withBorder = withBorder;
            return this;
        }

        public Builder setvisibleText(boolean visibleText) {
            this.visibleText = visibleText;
            return this;
        }

        public AdvancedEditBox build() {
            return (AdvancedEditBox)((Object)this.build(AdvancedEditBox::new));
        }

        public Object build(Function<Builder, Object> builder) {
            return builder.apply(this);
        }
    }
}

