/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.common.client.render.entity.renderer;

import com.izofar.takesapillage.common.ItTakesPillage;
import com.izofar.takesapillage.common.client.render.entity.model.SkirmisherModel;
import com.izofar.takesapillage.common.client.render.entity.state.SkirmisherRenderState;
import com.izofar.takesapillage.common.entity.Skirmisher;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.illager.AbstractIllager;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;

public final class SkirmisherRenderer
extends MobRenderer<Skirmisher, SkirmisherRenderState, SkirmisherModel> {
    private static final Identifier TEXTURE = ItTakesPillage.makeId("textures/entity/skirmisher.png");
    public static final float SCALE = 0.9375f;

    public SkirmisherRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SkirmisherModel(SkirmisherModel.createBodyLayer().bakeRoot()), 0.5f);
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
    }

    protected void scale(SkirmisherRenderState renderState, PoseStack poseStack) {
        poseStack.scale(0.9375f, 0.9375f, 0.9375f);
    }

    public SkirmisherRenderState createRenderState() {
        return new SkirmisherRenderState();
    }

    public void extractRenderState(Skirmisher skirmisher, SkirmisherRenderState renderState, float partialTick) {
        super.extractRenderState((LivingEntity)skirmisher, (LivingEntityRenderState)renderState, partialTick);
        renderState.skirmisher = skirmisher;
        ArmedEntityRenderState.extractArmedEntityRenderState((LivingEntity)skirmisher, (ArmedEntityRenderState)renderState, (ItemModelResolver)this.itemModelResolver, (float)partialTick);
        renderState.isRiding = skirmisher.isPassenger();
        renderState.mainArm = skirmisher.getMainArm();
        renderState.armPose = skirmisher.getArmPose();
        renderState.maxCrossbowChargeDuration = renderState.armPose == AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE ? CrossbowItem.getChargeDuration((ItemStack)skirmisher.getUseItem(), (LivingEntity)skirmisher) : 0;
        renderState.ticksUsingItem = skirmisher.getTicksUsingItem();
        renderState.attackAnim = skirmisher.getAttackAnim(partialTick);
        renderState.isAggressive = skirmisher.isAggressive();
    }

    public Identifier getTextureLocation(SkirmisherRenderState renderState) {
        return TEXTURE;
    }
}

