/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.common.util;

import com.google.common.collect.ImmutableList;
import com.izofar.takesapillage.common.init.ItTakesPillageEntityTypes;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.illager.AbstractIllager;
import net.minecraft.world.entity.raid.Raider;

public final class MobLists {
    public static final WeightedList<EntityType<? extends Raider>> PILLAGER_CAMP_LIST = MobLists.createWeightedList(ImmutableList.of(MobLists.createWeightedEntry(EntityType.PILLAGER, 15), MobLists.createWeightedEntry(EntityType.PILLAGER, 15), MobLists.createWeightedEntry((EntityType)ItTakesPillageEntityTypes.SKIRMISHER.get(), 12), MobLists.createWeightedEntry((EntityType)ItTakesPillageEntityTypes.ARCHER.get(), 8), MobLists.createWeightedEntry(EntityType.VINDICATOR, 5), MobLists.createWeightedEntry(EntityType.WITCH, 3), MobLists.createWeightedEntry(EntityType.EVOKER, 1)));
    public static final WeightedList<EntityType<? extends AbstractIllager>> PILLAGER_SIEGE_LIST = MobLists.createWeightedList(ImmutableList.of(MobLists.createWeightedEntry(EntityType.PILLAGER, 8), MobLists.createWeightedEntry((EntityType)ItTakesPillageEntityTypes.SKIRMISHER.get(), 6), MobLists.createWeightedEntry((EntityType)ItTakesPillageEntityTypes.ARCHER.get(), 6), MobLists.createWeightedEntry((EntityType)ItTakesPillageEntityTypes.LEGIONER.get(), 4), MobLists.createWeightedEntry(EntityType.VINDICATOR, 3)));
    public static final WeightedList<EntityType<? extends AbstractIllager>> RANGED_ILLAGER_LIST = MobLists.createWeightedList(ImmutableList.of(MobLists.createWeightedEntry(EntityType.PILLAGER, 1), MobLists.createWeightedEntry((EntityType)ItTakesPillageEntityTypes.ARCHER.get(), 2)));
    public static final WeightedList<EntityType<? extends Animal>> LIVESTOCK_LIST = MobLists.createWeightedList(ImmutableList.of(MobLists.createWeightedEntry(EntityType.COW, 4), MobLists.createWeightedEntry(EntityType.CHICKEN, 3), MobLists.createWeightedEntry(EntityType.SHEEP, 6), MobLists.createWeightedEntry(EntityType.DONKEY, 1), MobLists.createWeightedEntry(EntityType.HORSE, 2)));
    public static final WeightedList<EntityType<? extends Mob>> PRISONER_LIST = MobLists.createWeightedList(ImmutableList.of(MobLists.createWeightedEntry(EntityType.IRON_GOLEM, 4), MobLists.createWeightedEntry(EntityType.VILLAGER, 3), MobLists.createWeightedEntry((EntityType)ItTakesPillageEntityTypes.CLAY_GOLEM.get(), 3)));
    public static final WeightedList<EntityType<? extends Raider>> BASTILLE_LIST = MobLists.createWeightedList(ImmutableList.of(MobLists.createWeightedEntry((EntityType)ItTakesPillageEntityTypes.LEGIONER.get(), 15), MobLists.createWeightedEntry((EntityType)ItTakesPillageEntityTypes.SKIRMISHER.get(), 12), MobLists.createWeightedEntry((EntityType)ItTakesPillageEntityTypes.ARCHER.get(), 8), MobLists.createWeightedEntry(EntityType.PILLAGER, 7), MobLists.createWeightedEntry(EntityType.VINDICATOR, 5), MobLists.createWeightedEntry(EntityType.WITCH, 4), MobLists.createWeightedEntry(EntityType.EVOKER, 1)));
    public static final WeightedList<EntityType<? extends Mob>> CAPTIVE_LIST = MobLists.createWeightedList(ImmutableList.of(MobLists.createWeightedEntry(EntityType.VILLAGER, 5), MobLists.createWeightedEntry((EntityType)ItTakesPillageEntityTypes.CLAY_GOLEM.get(), 3), MobLists.createWeightedEntry(EntityType.IRON_GOLEM, 2)));

    public static <T extends Mob> WeightedList<EntityType<? extends T>> createWeightedList(ImmutableList<Weighted<EntityType<? extends T>>> entries) {
        return WeightedList.of(entries);
    }

    public static <T extends Mob> Weighted<EntityType<? extends T>> createWeightedEntry(EntityType<? extends T> entityType, int weight) {
        return new Weighted(entityType, weight);
    }
}

