/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.common.world;

import com.izofar.takesapillage.common.ItTakesPillage;
import com.izofar.takesapillage.common.util.MobLists;
import com.izofar.takesapillage.common.versions.VersionedEntitySpawnReason;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.illager.AbstractIllager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class PillageSiege
implements CustomSpawner {
    public static final PillageSiege PILLAGE_SIEGE = new PillageSiege();
    private boolean hasSetupSiege;
    private State siegeState = State.SIEGE_DONE;
    private int pillagersToSpawn;
    private int nextSpawnTime;
    private int spawnX;
    private int spawnY;
    private int spawnZ;

    public void tick(ServerLevel serverLevel, boolean spawnMonsters) {
        if (serverLevel.isBrightOutside() || !ItTakesPillage.getConfig().enablePillageSieges) {
            this.siegeState = State.SIEGE_DONE;
            this.hasSetupSiege = false;
            return;
        }
        long l = serverLevel.getDayTime() % 24000L;
        if (l == 12000L) {
            State state = this.siegeState = serverLevel.random.nextInt(10) == 0 ? State.SIEGE_TONIGHT : State.SIEGE_DONE;
        }
        if (this.siegeState == State.SIEGE_DONE) {
            return;
        }
        if (!this.hasSetupSiege) {
            if (!this.tryToSetupSiege(serverLevel)) {
                return;
            }
            this.hasSetupSiege = true;
        }
        if (this.nextSpawnTime > 0) {
            --this.nextSpawnTime;
            return;
        }
        this.nextSpawnTime = 2;
        if (this.pillagersToSpawn > 0) {
            this.trySpawn(serverLevel);
            --this.pillagersToSpawn;
        } else {
            this.siegeState = State.SIEGE_DONE;
        }
    }

    private boolean tryToSetupSiege(ServerLevel serverLevel) {
        for (Player player : serverLevel.players()) {
            BlockPos blockpos;
            if (player.isSpectator() || !serverLevel.isVillage(blockpos = player.blockPosition()) || serverLevel.getBiome(blockpos).is(BiomeTags.WITHOUT_ZOMBIE_SIEGES)) continue;
            for (int i = 0; i < 10; ++i) {
                float f = serverLevel.random.nextFloat() * ((float)Math.PI * 2);
                this.spawnX = blockpos.getX() + Mth.floor((float)(Mth.cos((double)f) * 32.0f));
                this.spawnY = blockpos.getY();
                this.spawnZ = blockpos.getZ() + Mth.floor((float)(Mth.sin((double)f) * 32.0f));
                Vec3 siegeLocation = this.findRandomSpawnPos(serverLevel, new BlockPos(this.spawnX, this.spawnY, this.spawnZ));
                if (siegeLocation == null) continue;
                this.nextSpawnTime = 0;
                this.pillagersToSpawn = serverLevel.random.nextInt(6) + 4;
                break;
            }
            if (Mth.frac((double)((double)serverLevel.getDayTime() / 24000.0)) > 0.4583333333333333) {
                serverLevel.playSound(null, (double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ(), (SoundEvent)SoundEvents.RAID_HORN.value(), SoundSource.NEUTRAL, 64.0f, 1.0f);
                serverLevel.playSound(null, (double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ(), SoundEvents.BELL_BLOCK, SoundSource.BLOCKS, 2.0f, 1.0f);
                serverLevel.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, blockpos);
            }
            return true;
        }
        return false;
    }

    private void trySpawn(ServerLevel serverLevel) {
        Vec3 vec3 = this.findRandomSpawnPos(serverLevel, new BlockPos(this.spawnX, this.spawnY, this.spawnZ));
        if (vec3 != null) {
            AbstractIllager pillager;
            try {
                EntityType entityType = (EntityType)MobLists.PILLAGER_SIEGE_LIST.getRandom(serverLevel.random).get();
                pillager = (AbstractIllager)entityType.create((Level)serverLevel, VersionedEntitySpawnReason.EVENT);
                pillager.setPersistenceRequired();
                if (serverLevel.random.nextInt(6) < 1) {
                    pillager.setItemSlot(EquipmentSlot.HEAD, Raid.getOminousBannerInstance((HolderGetter)pillager.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
                    pillager.setDropChance(EquipmentSlot.HEAD, 2.0f);
                }
                pillager.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(pillager.blockPosition()), VersionedEntitySpawnReason.EVENT, null);
            }
            catch (Exception exception) {
                ItTakesPillage.getLogger().warn("Failed to create pillager for pillage siege at {}", (Object)vec3, (Object)exception);
                return;
            }
            pillager.snapTo(vec3.x, vec3.y, vec3.z, serverLevel.random.nextFloat() * 360.0f, 0.0f);
            serverLevel.addFreshEntityWithPassengers((Entity)pillager);
        }
    }

    @Nullable
    private Vec3 findRandomSpawnPos(ServerLevel serverLevel, BlockPos blockPos) {
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = blockPos.getX() + serverLevel.random.nextInt(16) - 8;
            BlockPos blockpos = new BlockPos(j, l = serverLevel.getHeight(Heightmap.Types.WORLD_SURFACE, j, k = blockPos.getZ() + serverLevel.random.nextInt(16) - 8), k);
            if (!serverLevel.isVillage(blockpos) || !Monster.checkMonsterSpawnRules((EntityType)EntityType.PILLAGER, (ServerLevelAccessor)serverLevel, (EntitySpawnReason)VersionedEntitySpawnReason.EVENT, (BlockPos)blockpos, (RandomSource)serverLevel.random)) continue;
            return Vec3.atBottomCenterOf((Vec3i)blockpos);
        }
        return null;
    }

    static enum State {
        SIEGE_TONIGHT,
        SIEGE_DONE;

    }
}

