/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.common.world;

import com.izofar.takesapillage.common.ItTakesPillage;
import com.izofar.takesapillage.common.util.MobLists;
import com.izofar.takesapillage.common.versions.VersionedEntitySpawnReason;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1543;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3765;
import net.minecraft.class_5304;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public final class PillageSiege
implements class_5304 {
    public static final PillageSiege PILLAGE_SIEGE = new PillageSiege();
    private boolean hasSetupSiege;
    private State siegeState = State.SIEGE_DONE;
    private int pillagersToSpawn;
    private int nextSpawnTime;
    private int spawnX;
    private int spawnY;
    private int spawnZ;

    public void method_6445(class_3218 serverLevel, boolean spawnMonsters) {
        if (serverLevel.method_8530() || !ItTakesPillage.getConfig().enablePillageSieges) {
            this.siegeState = State.SIEGE_DONE;
            this.hasSetupSiege = false;
            return;
        }
        float f = serverLevel.method_30274(0.0f);
        if ((double)f == 0.5) {
            State state = this.siegeState = serverLevel.field_9229.method_43048(10) == 0 ? State.SIEGE_TONIGHT : State.SIEGE_DONE;
        }
        if (this.siegeState == State.SIEGE_DONE) {
            return;
        }
        if (!this.hasSetupSiege) {
            if (!this.tryToSetupSiege(serverLevel)) {
                return;
            }
            this.hasSetupSiege = true;
        }
        if (this.nextSpawnTime > 0) {
            --this.nextSpawnTime;
            return;
        }
        this.nextSpawnTime = 2;
        if (this.pillagersToSpawn > 0) {
            this.trySpawn(serverLevel);
            --this.pillagersToSpawn;
        } else {
            this.siegeState = State.SIEGE_DONE;
        }
    }

    private boolean tryToSetupSiege(class_3218 serverLevel) {
        for (class_1657 player : serverLevel.method_18456()) {
            class_2338 blockpos;
            if (player.method_7325() || !serverLevel.method_19500(blockpos = player.method_24515()) || serverLevel.method_23753(blockpos).method_40220(class_6908.field_37381)) continue;
            for (int i = 0; i < 10; ++i) {
                float f = serverLevel.field_9229.method_43057() * ((float)Math.PI * 2);
                this.spawnX = blockpos.method_10263() + class_3532.method_15375((float)(class_3532.method_15362((float)f) * 32.0f));
                this.spawnY = blockpos.method_10264();
                this.spawnZ = blockpos.method_10260() + class_3532.method_15375((float)(class_3532.method_15374((float)f) * 32.0f));
                class_243 siegeLocation = this.findRandomSpawnPos(serverLevel, new class_2338(this.spawnX, this.spawnY, this.spawnZ));
                if (siegeLocation == null) continue;
                this.nextSpawnTime = 0;
                this.pillagersToSpawn = serverLevel.field_9229.method_43048(6) + 4;
                break;
            }
            if ((double)serverLevel.method_30274((float)serverLevel.method_30271()) > class_3532.method_15385((double)0.4583333333333333)) {
                serverLevel.method_43128(null, (double)blockpos.method_10263(), (double)blockpos.method_10264(), (double)blockpos.method_10260(), (class_3414)class_3417.field_17266.comp_349(), class_3419.field_15254, 64.0f, 1.0f);
                serverLevel.method_43128(null, (double)blockpos.method_10263(), (double)blockpos.method_10264(), (double)blockpos.method_10260(), class_3417.field_17265, class_3419.field_15245, 2.0f, 1.0f);
                serverLevel.method_33596(null, (class_6880)class_5712.field_28733, blockpos);
            }
            return true;
        }
        return false;
    }

    private void trySpawn(class_3218 serverLevel) {
        class_243 vec3 = this.findRandomSpawnPos(serverLevel, new class_2338(this.spawnX, this.spawnY, this.spawnZ));
        if (vec3 != null) {
            class_1543 pillager;
            try {
                class_1299 entityType = (class_1299)MobLists.PILLAGER_SIEGE_LIST.method_34992(serverLevel.field_9229).get();
                pillager = (class_1543)entityType.method_5883((class_1937)serverLevel, VersionedEntitySpawnReason.EVENT);
                pillager.method_5971();
                if (serverLevel.field_9229.method_43048(6) < 1) {
                    pillager.method_5673(class_1304.field_6169, class_3765.method_61558((class_7871)pillager.method_56673().method_30530(class_7924.field_41252)));
                    pillager.method_5946(class_1304.field_6169, 2.0f);
                }
                pillager.method_5943((class_5425)serverLevel, serverLevel.method_8404(pillager.method_24515()), VersionedEntitySpawnReason.EVENT, null);
            }
            catch (Exception exception) {
                ItTakesPillage.getLogger().warn("Failed to create pillager for pillage siege at {}", (Object)vec3, (Object)exception);
                return;
            }
            pillager.method_5808(vec3.field_1352, vec3.field_1351, vec3.field_1350, serverLevel.field_9229.method_43057() * 360.0f, 0.0f);
            serverLevel.method_30771((class_1297)pillager);
        }
    }

    @Nullable
    private class_243 findRandomSpawnPos(class_3218 serverLevel, class_2338 blockPos) {
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = blockPos.method_10263() + serverLevel.field_9229.method_43048(16) - 8;
            class_2338 blockpos = new class_2338(j, l = serverLevel.method_8624(class_2902.class_2903.field_13202, j, k = blockPos.method_10260() + serverLevel.field_9229.method_43048(16) - 8), k);
            if (!serverLevel.method_19500(blockpos) || !class_1588.method_20680((class_1299)class_1299.field_6105, (class_5425)serverLevel, (class_3730)VersionedEntitySpawnReason.EVENT, (class_2338)blockpos, (class_5819)serverLevel.field_9229)) continue;
            return class_243.method_24955((class_2382)blockpos);
        }
        return null;
    }

    static enum State {
        SIEGE_TONIGHT,
        SIEGE_DONE;

    }
}

