/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.common.mixin;

import com.izofar.takesapillage.common.entity.ClayGolem;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CarvedPumpkinBlock.class})
public abstract class CarvedPumpkinBlockMixin {
    @Inject(method={"canSpawnGolem"}, at={@At(value="HEAD")}, cancellable=true)
    public void takesapillage$canDispense(LevelReader levelReader, BlockPos blockPos, CallbackInfoReturnable<Boolean> cir) {
        if (ClayGolem.getClayGolemBuildPattern().find(levelReader, blockPos) != null) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"onPlace"}, at={@At(value="HEAD")})
    private void takesapillage$customOnBlockAdded(BlockState blockState, Level level, BlockPos blockPos, BlockState oldBlockState, boolean bl, CallbackInfo ci) {
        if (!oldBlockState.is(blockState.getBlock())) {
            ClayGolem.trySpawnClayGolem(level, blockPos);
        }
    }
}

