/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.common.client.render.entity.model;

import com.izofar.takesapillage.common.client.render.entity.state.SkirmisherRenderState;
import com.izofar.takesapillage.common.entity.Skirmisher;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.AbstractIllager;

public class SkirmisherModel
extends EntityModel<SkirmisherRenderState>
implements ArmedModel,
HeadedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart left_leg;
    private final ModelPart right_leg;

    public SkirmisherModel(ModelPart root) {
        super(root);
        this.root = root;
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.left_arm = root.getChild("left_arm");
        this.right_arm = root.getChild("right_arm");
        this.left_leg = root.getChild("left_leg");
        this.right_leg = root.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.ZERO);
        partdefinition1.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-0.5f, -15.0f, -5.0f, 1.0f, 6.0f, 10.0f, new CubeDeformation(-0.5f)), PartPose.ZERO);
        partdefinition1.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 20).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f).texOffs(0, 38).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 22).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 46).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 46).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(SkirmisherRenderState renderState) {
        Skirmisher skirmisher = renderState.skirmisher;
        float limbAngle = renderState.walkAnimationPos;
        float limbDistance = renderState.walkAnimationSpeed;
        float animationProgress = renderState.ageInTicks;
        float headYaw = renderState.yRot;
        float headPitch = renderState.xRot;
        float attackTime = renderState.attackTime;
        HumanoidArm mainArm = skirmisher.getMainArm();
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        if (skirmisher.isPassenger()) {
            this.right_arm.xRot = -0.62831855f;
            this.right_arm.yRot = 0.0f;
            this.right_arm.zRot = 0.0f;
            this.left_arm.xRot = -0.62831855f;
            this.left_arm.yRot = 0.0f;
            this.left_arm.zRot = 0.0f;
            this.right_leg.xRot = -1.4137167f;
            this.right_leg.yRot = 0.31415927f;
            this.right_leg.zRot = 0.07853982f;
            this.left_leg.xRot = -1.4137167f;
            this.left_leg.yRot = -0.31415927f;
            this.left_leg.zRot = -0.07853982f;
        } else {
            this.right_arm.xRot = Mth.cos((float)(limbAngle * 0.6662f + (float)Math.PI)) * 2.0f * limbDistance * 0.5f;
            this.right_arm.yRot = 0.0f;
            this.right_arm.zRot = 0.0f;
            this.left_arm.xRot = Mth.cos((float)(limbAngle * 0.6662f)) * 2.0f * limbDistance * 0.5f;
            this.left_arm.yRot = 0.0f;
            this.left_arm.zRot = 0.0f;
            this.right_leg.xRot = Mth.cos((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance * 0.5f;
            this.right_leg.yRot = 0.0f;
            this.right_leg.zRot = 0.0f;
            this.left_leg.xRot = Mth.cos((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance * 0.5f;
            this.left_leg.yRot = 0.0f;
            this.left_leg.zRot = 0.0f;
        }
        AbstractIllager.IllagerArmPose abstractillager$illagerarmpose = skirmisher.getArmPose();
        if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.ATTACKING) {
            if (!skirmisher.getMainHandItem().isEmpty()) {
                AnimationUtils.swingWeaponDown((ModelPart)this.right_arm, (ModelPart)this.left_arm, (HumanoidArm)mainArm, (float)attackTime, (float)animationProgress);
            }
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.SPELLCASTING) {
            this.right_arm.z = 0.0f;
            this.right_arm.x = -5.0f;
            this.left_arm.z = 0.0f;
            this.left_arm.x = 5.0f;
            this.right_arm.xRot = Mth.cos((float)(animationProgress * 0.6662f)) * 0.25f;
            this.left_arm.xRot = Mth.cos((float)(animationProgress * 0.6662f)) * 0.25f;
            this.right_arm.zRot = 2.3561945f;
            this.left_arm.zRot = -2.3561945f;
            this.right_arm.yRot = 0.0f;
            this.left_arm.yRot = 0.0f;
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.BOW_AND_ARROW) {
            this.right_arm.yRot = -0.1f + this.head.yRot;
            this.right_arm.xRot = -1.5707964f + this.head.xRot;
            this.left_arm.xRot = -0.9424779f + this.head.xRot;
            this.head.yRot -= 0.4f;
            this.left_arm.zRot = 1.5707964f;
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CROSSBOW_HOLD) {
            AnimationUtils.animateCrossbowHold((ModelPart)this.right_arm, (ModelPart)this.left_arm, (ModelPart)this.head, (boolean)true);
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE) {
            AnimationUtils.animateCrossbowCharge((ModelPart)this.right_arm, (ModelPart)this.left_arm, (float)renderState.maxCrossbowChargeDuration, (int)renderState.ticksUsingItem, (boolean)true);
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CELEBRATING) {
            this.right_arm.z = 0.0f;
            this.right_arm.x = -5.0f;
            this.right_arm.xRot = Mth.cos((float)(animationProgress * 0.6662f)) * 0.05f;
            this.right_arm.zRot = 2.670354f;
            this.right_arm.yRot = 0.0f;
            this.left_arm.z = 0.0f;
            this.left_arm.x = 5.0f;
            this.left_arm.xRot = Mth.cos((float)(animationProgress * 0.6662f)) * 0.05f;
            this.left_arm.zRot = -2.3561945f;
            this.left_arm.yRot = 0.0f;
        }
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.left_arm : this.right_arm;
    }

    public ModelPart getHead() {
        return this.head;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

