/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.common.item;

import com.izofar.takesapillage.common.versions.VersionedEntity;
import com.izofar.takesapillage.common.versions.VersionedGameRulesProvider;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class RavagerHornItem
extends InstrumentItem {
    public RavagerHornItem(TagKey<Instrument> instruments, Item.Properties properties) {
        super(instruments, properties);
    }

    public boolean releaseUsing(ItemStack itemStack, Level level, LivingEntity livingEntity, int remainingTicks) {
        super.finishUsingItem(itemStack, level, livingEntity);
        itemStack.hurtAndBreak(1, livingEntity, VersionedEntity.getEquipmentSlotForItem(livingEntity.getUsedItemHand()));
        return true;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        InteractionResult result = super.use(level, player, hand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RavagerHornItem.incrementBadOmen(serverLevel, player);
        }
        return result;
    }

    private static void incrementBadOmen(ServerLevel level, Player player) {
        MobEffectInstance mobeffectinstance = player.getEffect(MobEffects.BAD_OMEN);
        int i = 1;
        if (mobeffectinstance != null) {
            i += mobeffectinstance.getAmplifier();
            player.removeEffectNoUpdate(MobEffects.BAD_OMEN);
        } else {
            --i;
        }
        i = Mth.clamp((int)i, (int)0, (int)4);
        if (!VersionedGameRulesProvider.getBoolean(level, VersionedGameRulesProvider.RAIDS)) {
            player.addEffect(new MobEffectInstance(MobEffects.BAD_OMEN, 120000, i, false, false, true));
        }
    }
}

