/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.takesapillage.common.world.structure;

import com.izofar.takesapillage.common.init.ItTakesPillageStructureTypes;
import com.izofar.takesapillage.common.util.ModStructureUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_5434;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7151;
import net.minecraft.class_8891;
import net.minecraft.class_9778;
import net.minecraft.class_9822;

public final class PillagerStructure
extends class_3195 {
    public static final MapCodec<PillagerStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PillagerStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.intRange((int)0, (int)30).fieldOf("terrain_search_radius").forGetter(structure -> structure.terrainSearchRadius), (App)Codec.intRange((int)0, (int)30).fieldOf("max_terrain_range").forGetter(structure -> structure.maxTerrainRange), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, PillagerStructure::new));
    private final class_6880<class_3785> startPool;
    private final Optional<class_2960> startJigsawName;
    private final int size;
    private final int terrainSearchRadius;
    private final int maxTerrainRange;
    private final class_6122 startHeight;
    private final Optional<class_2902.class_2903> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    public PillagerStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int size, int terrainSearchRadius, int maxTerrainRange, class_6122 startHeight, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.terrainSearchRadius = terrainSearchRadius;
        this.maxTerrainRange = maxTerrainRange;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public class_7151<?> method_41618() {
        return (class_7151)ItTakesPillageStructureTypes.PILLAGER_STRUCTURE.get();
    }

    private static boolean checkLocation(class_3195.class_7149 context, int terrainSearchRadius, int maxTerrainRange) {
        int i = context.comp_568().field_9181 >> 4;
        int j = context.comp_568().field_9180 >> 4;
        class_2919 worldgenrandom = new class_2919((class_5819)new class_5820(0L));
        worldgenrandom.method_43052((long)(i ^ j << 4) ^ context.comp_567());
        return ModStructureUtils.isRelativelyFlat(context, terrainSearchRadius, maxTerrainRange) && ModStructureUtils.isOnLand(context, terrainSearchRadius);
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        if (!PillagerStructure.checkLocation(context, this.terrainSearchRadius, this.maxTerrainRange)) {
            return Optional.empty();
        }
        class_2338 blockpos = context.comp_568().method_33943(0);
        return class_3778.method_30419((class_3195.class_7149)context, this.startPool, this.startJigsawName, (int)this.size, (class_2338)blockpos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter, (class_8891)class_8891.field_46826, (class_9778)class_5434.field_51911, (class_9822)class_5434.field_52235);
    }
}

