/*
 * Decompiled with CFR 0.152.
 */
package net.legacy.combat_reborn;

import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.legacy.combat_reborn.config.CRConfig;
import net.legacy.combat_reborn.entity.PlayerSpawnCallback;
import net.legacy.combat_reborn.item.AttributeModifierCallback;
import net.legacy.combat_reborn.network.ShieldInfo;
import net.legacy.combat_reborn.registry.CRDataComponents;
import net.legacy.combat_reborn.registry.CREnchantments;
import net.legacy.combat_reborn.sound.CRSounds;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_746;
import net.minecraft.class_8710;

public class CombatReborn
implements ModInitializer {
    public static boolean isEndRebornLoaded = false;
    public static boolean isEnchantsAndExpeditionsLoaded = false;
    public static final String MOD_ID = "combat_reborn";

    public void onInitialize() {
        Optional modContainer = FabricLoader.getInstance().getModContainer(MOD_ID);
        AutoConfig.register(CRConfig.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(GsonConfigSerializer::new));
        CRDataComponents.init();
        CREnchantments.init();
        CRSounds.init();
        AttributeModifierCallback.init();
        PlayerSpawnCallback.init();
        CombatReborn.registerPayloads();
        if (!CRConfig.get().general.combat.shield_overhaul) {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)CombatReborn.id("no_shield_overhaul"), (ModContainer)((ModContainer)modContainer.get()), (class_2561)class_2561.method_43471((String)"pack.combat_reborn.no_shield_overhaul"), (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
        }
        if (!CRConfig.get().general.combat.cleaving) {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)CombatReborn.id("no_cleaving"), (ModContainer)((ModContainer)modContainer.get()), (class_2561)class_2561.method_43471((String)"pack.combat_reborn.no_cleaving"), (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
        }
        if (FabricLoader.getInstance().isModLoaded("end_reborn")) {
            isEndRebornLoaded = true;
        }
        if (FabricLoader.getInstance().isModLoaded("enchants_and_expeditions")) {
            isEnchantsAndExpeditionsLoaded = true;
        }
    }

    public static void registerPayloads() {
        PayloadTypeRegistry.playS2C().register(ShieldInfo.Sync.TYPE, ShieldInfo.Sync.CODEC);
        PayloadTypeRegistry.playC2S().register(ShieldInfo.Request.TYPE, ShieldInfo.Request.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(ShieldInfo.Sync.TYPE, (payload, context) -> {
            class_746 player = context.player();
            if (player instanceof ShieldInfo) {
                ShieldInfo shieldInfo = (ShieldInfo)player;
                shieldInfo.setPercentageDamage(payload.percentageDamage());
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(ShieldInfo.Request.TYPE, (payload, context) -> {
            class_3222 player = context.player();
            if (player instanceof ShieldInfo) {
                ShieldInfo shieldInfo = (ShieldInfo)player;
                int current = shieldInfo.getPercentageDamage();
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ShieldInfo.Sync(current));
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            if (player instanceof ShieldInfo) {
                ShieldInfo shieldInfo = (ShieldInfo)player;
                int current = shieldInfo.getPercentageDamage();
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ShieldInfo.Sync(current));
            }
        });
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }
}

