/*
 * Decompiled with CFR 0.152.
 */
package net.legacy.combat_reborn.mixin.entity;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Optional;
import net.legacy.combat_reborn.config.CRConfig;
import net.legacy.combat_reborn.network.ShieldInfo;
import net.legacy.combat_reborn.registry.CREnchantments;
import net.legacy.combat_reborn.tag.CRItemTags;
import net.legacy.combat_reborn.util.BlockedSourceInterface;
import net.legacy.combat_reborn.util.ShieldHelper;
import net.minecraft.class_10707;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.minecraft.class_8103;
import net.minecraft.class_9334;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
implements ShieldInfo,
BlockedSourceInterface {
    @Unique
    private class_1282 lastBlockedSource;
    @Unique
    int localTick = 0;
    @Unique
    int recoveryDelay = 0;
    @Unique
    int hurtOrBlockedTime = 0;
    @Unique
    private Optional<Integer> percentageDamage = Optional.of(0);
    @Unique
    class_1282 damageSource;
    @Shadow
    public int field_6235;

    @Override
    public @Nullable class_1282 getLastBlockedSource() {
        return this.lastBlockedSource;
    }

    @Override
    public void setLastBlockedSource(class_1282 source) {
        this.lastBlockedSource = source;
    }

    @WrapOperation(method={"method_64397(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1309;method_67346(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)F")})
    private float lastBlockedSource(class_1309 attacked, class_3218 serverLevel, class_1282 damageSource, float f, Operation<Float> original) {
        this.setLastBlockedSource(damageSource);
        return ((Float)original.call(new Object[]{attacked, serverLevel, damageSource, Float.valueOf(f)})).floatValue();
    }

    @Override
    public ShieldInfo getInfo() {
        return this;
    }

    @Override
    public int getPercentageDamage() {
        return this.percentageDamage.get();
    }

    @Override
    public void setPercentageDamage(int value) {
        this.percentageDamage = Optional.of(value);
    }

    @Inject(method={"method_5652(Lnet/minecraft/class_11372;)V"}, at={@At(value="TAIL")})
    private void write(class_11372 valueOutput, CallbackInfo ci) {
        valueOutput.method_71465("combat_reborn:percentage_damage", this.percentageDamage.get().intValue());
    }

    @Inject(method={"method_5749(Lnet/minecraft/class_11368;)V"}, at={@At(value="TAIL")})
    private void read(class_11368 valueInput, CallbackInfo ci) {
        if (valueInput.contains("combat_reborn:percentage_damage")) {
            this.percentageDamage = valueInput.method_71439("combat_reborn:percentage_damage");
        }
    }

    @Inject(method={"method_64397(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)Z"}, at={@At(value="HEAD")})
    private void getDamageSource(class_3218 level, class_1282 damageSource, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.damageSource = damageSource;
    }

    @WrapOperation(method={"method_64397(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1309;method_67346(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)F")})
    private float trackShieldDamageBlocked(class_1309 instance, class_3218 serverLevel, class_1282 damageSource, float f, Operation<Float> original) {
        class_1309 entity;
        class_1799 stack;
        Object[] objectArray = new Object[]{instance, serverLevel, damageSource, Float.valueOf(f)};
        float blockedDamage = ((Float)original.call(objectArray)).floatValue();
        if (blockedDamage > 0.0f && CRConfig.get().general.combat.shield_overhaul && this.hurtOrBlockedTime == 0 && (stack = (entity = (class_1309)class_1309.class.cast(this)).method_6030()).method_31573(CRItemTags.SHIELD) && entity instanceof ShieldInfo) {
            ShieldInfo shieldInfo = (ShieldInfo)entity;
            int percentageToIncrease = ShieldHelper.processDamage(stack, f);
            if (damageSource.method_48789(class_8103.field_42247)) {
                percentageToIncrease /= 2;
            }
            if (damageSource.method_60948() != null && damageSource.method_60948().method_31573(class_3489.field_42612)) {
                percentageToIncrease *= 2;
            }
            if (entity.method_6048() <= ShieldHelper.getParryWindow(stack) && ShieldHelper.canBeParried(damageSource)) {
                percentageToIncrease = (int)((float)percentageToIncrease / ShieldHelper.getParryBonus(stack));
            }
            shieldInfo.setPercentageDamageAndSync(Math.max(shieldInfo.getPercentageDamage() + percentageToIncrease, 0), (class_3222)entity);
            this.hurtOrBlockedTime = 10;
            this.recoveryDelay = 100;
            if (shieldInfo.getPercentageDamage() >= 100) {
                float disableTime = 15.0f;
                if (CRConfig.get().general.integrations.enderscape && stack.method_31573(CRItemTags.RUBBLE_SHIELD)) {
                    disableTime = 10.0f;
                }
                ((class_10707)stack.method_57353().method_58694(class_9334.field_56396)).method_67200(serverLevel, entity, disableTime, stack);
                shieldInfo.setPercentageDamageAndSync(0, (class_3222)entity);
                entity.method_5780("should_disable_shield");
            }
        }
        return blockedDamage;
    }

    @Inject(method={"method_5773()V"}, at={@At(value="HEAD")})
    private void passiveShieldRecovery(CallbackInfo ci) {
        class_3222 player;
        class_1309 entity;
        block9: {
            block8: {
                entity = (class_1309)class_1309.class.cast(this);
                if (!(entity instanceof class_3222)) break block8;
                player = (class_3222)entity;
                if (CRConfig.get().general.combat.shield_overhaul) break block9;
            }
            return;
        }
        ++this.localTick;
        if (this.localTick >= 5) {
            if (this.recoveryDelay == 0) {
                ShieldInfo shieldInfo;
                if (entity instanceof ShieldInfo && (shieldInfo = (ShieldInfo)entity).getPercentageDamage() > 0) {
                    shieldInfo.setPercentageDamageAndSync(Math.max(shieldInfo.getPercentageDamage(), 0) - 1, player);
                }
            } else {
                this.recoveryDelay = Math.max(this.recoveryDelay - this.localTick, 0);
            }
            this.localTick = 0;
        }
    }

    @Shadow
    public abstract class_1799 method_59958();

    @Inject(method={"method_5670()V"}, at={@At(value="HEAD")})
    private void decreaseHurtOrBlockedTime(CallbackInfo ci) {
        if (this.hurtOrBlockedTime > 0) {
            --this.hurtOrBlockedTime;
        }
    }

    @Inject(method={"method_48922(Lnet/minecraft/class_1282;)V"}, at={@At(value="HEAD")})
    private void setHurtOrBlockedTime(CallbackInfo ci) {
        this.hurtOrBlockedTime = this.field_6235;
    }

    @Inject(method={"method_67125()F"}, at={@At(value="TAIL")}, cancellable=true)
    private void cleaving(CallbackInfoReturnable<Float> cir) {
        float disableTime = ((Float)cir.getReturnValue()).floatValue();
        if (CRConfig.get().general.combat.shield_overhaul && disableTime >= 3.0f) {
            disableTime -= 2.0f;
        }
        if (disableTime <= 0.0f) {
            return;
        }
        class_1799 stack = this.method_59958();
        int level = CREnchantments.getLevel(stack, CREnchantments.CLEAVING);
        if (level > 0) {
            disableTime += (float)level;
        }
        if (CRConfig.get().general.combat.shield_overhaul) {
            this.recoveryDelay = (int)Math.min((float)this.recoveryDelay + disableTime * 20.0f, 100.0f + disableTime * 20.0f);
        }
        cir.setReturnValue((Object)Float.valueOf(disableTime));
    }

    @Inject(method={"method_62821()Lnet/minecraft/class_1799;"}, at={@At(value="HEAD")}, cancellable=true)
    private void configureShieldDelay(CallbackInfoReturnable<class_1799> cir) {
        int i;
        class_1309 entity = (class_1309)class_1309.class.cast(this);
        if (!entity.method_6115()) {
            return;
        }
        class_1799 stack = entity.method_6030();
        if (!stack.method_31573(CRItemTags.SHIELD)) {
            return;
        }
        class_10707 blocksAttacks = (class_10707)stack.method_58694(class_9334.field_56396);
        if (blocksAttacks != null && (i = stack.method_7935(entity) - entity.method_6014()) >= CRConfig.get().general.combat.shield_delay) {
            cir.setReturnValue((Object)stack);
        }
    }

    @ModifyVariable(method={"method_64397(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)Z"}, at=@At(value="HEAD"), index=3, argsOnly=true)
    private float activeShieldRecovery(float value) {
        ShieldInfo shieldInfo;
        class_1657 player;
        class_1297 class_12972;
        if (CRConfig.get().general.combat.shield_overhaul && (class_12972 = this.damageSource.method_5529()) instanceof class_1657 && (player = (class_1657)class_12972) instanceof ShieldInfo && (shieldInfo = (ShieldInfo)player).getPercentageDamage() > 0 && this.hurtOrBlockedTime == 0) {
            float restoration = value / 2.0f;
            class_1799 stack = player.method_59958();
            int dueling = CREnchantments.getLevel(stack, CREnchantments.DUELING);
            shieldInfo.setPercentageDamageAndSync((int)Math.max((float)shieldInfo.getPercentageDamage() - (restoration *= 1.0f + (float)dueling / 3.0f), 0.0f), (class_3222)player);
        }
        return value;
    }
}

