/*
 * Decompiled with CFR 0.152.
 */
package net.legacy.combat_reborn.mixin.entity;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Optional;
import net.legacy.combat_reborn.config.CRConfig;
import net.legacy.combat_reborn.network.ShieldInfo;
import net.legacy.combat_reborn.registry.CREnchantments;
import net.legacy.combat_reborn.tag.CRItemTags;
import net.legacy.combat_reborn.util.ShieldHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.minecraft.class_8103;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
implements ShieldInfo {
    @Unique
    private class_1282 lastBlockedSource;
    @Unique
    int localTick = 0;
    @Unique
    int recoveryDelay = 0;
    @Unique
    int hurtOrBlockedTime = 0;
    @Unique
    private Optional<Integer> percentageDamage = Optional.of(0);
    @Unique
    class_1282 damageSource;
    @Shadow
    public int field_6235;

    @WrapOperation(method={"method_5643(Lnet/minecraft/class_1282;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1309;method_6061(Lnet/minecraft/class_1282;)Z")})
    private boolean lastBlockedSource(class_1309 entity, class_1282 damageSource, Operation<Boolean> original) {
        this.lastBlockedSource = damageSource;
        return (Boolean)original.call(new Object[]{entity, damageSource});
    }

    @Inject(method={"method_6090(Lnet/minecraft/class_1309;)V"}, at={@At(value="HEAD")})
    private void handleParrying(class_1309 attacker, CallbackInfo ci) {
        if (!CRConfig.get().general.combat.shield_overhaul) {
            return;
        }
        class_1309 attacked = (class_1309)class_1309.class.cast(this);
        class_1282 damageSource = this.lastBlockedSource;
        class_1799 stack = attacked.method_6030();
        int useTicks = attacked.method_6048();
        if (useTicks <= ShieldHelper.getParryWindow(stack) && damageSource.method_5529() != null && ShieldHelper.canBeParried(damageSource)) {
            class_3218 serverLevel = attacked.method_37908().method_8503().method_3847(attacked.method_37908().method_27983());
            ShieldHelper.onParry(serverLevel, attacker, attacked, stack);
        }
    }

    @Override
    public ShieldInfo getInfo() {
        return this;
    }

    @Override
    public int getPercentageDamage() {
        return this.percentageDamage.get();
    }

    @Override
    public void setPercentageDamage(int value) {
        this.percentageDamage = Optional.of(value);
    }

    @Inject(method={"method_5652(Lnet/minecraft/class_2487;)V"}, at={@At(value="TAIL")})
    private void write(class_2487 compoundTag, CallbackInfo ci) {
        compoundTag.method_10569("combat_reborn:percentage_damage", this.percentageDamage.get().intValue());
    }

    @Inject(method={"method_5749(Lnet/minecraft/class_2487;)V"}, at={@At(value="TAIL")})
    private void read(class_2487 compoundTag, CallbackInfo ci) {
        if (compoundTag.method_10545("combat_reborn:percentage_damage")) {
            this.percentageDamage = Optional.of(compoundTag.method_10550("combat_reborn:percentage_damage"));
        }
    }

    @Inject(method={"method_5643(Lnet/minecraft/class_1282;F)Z"}, at={@At(value="HEAD")})
    private void getDamageSource(class_1282 damageSource, float f, CallbackInfoReturnable<Boolean> cir) {
        this.damageSource = damageSource;
    }

    @WrapOperation(method={"method_5643(Lnet/minecraft/class_1282;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_3222;method_7339(Lnet/minecraft/class_2960;I)V")})
    private void trackShieldDamageBlocked(class_3222 player, class_2960 resourceLocation, int i, Operation<Void> original) {
        class_1309 entity;
        class_1799 stack;
        float blockedDamage = (float)i / 10.0f;
        if (blockedDamage > 0.0f && CRConfig.get().general.combat.shield_overhaul && this.hurtOrBlockedTime == 0 && (stack = (entity = (class_1309)class_1309.class.cast(this)).method_6030()).method_31573(CRItemTags.SHIELD) && entity instanceof ShieldInfo) {
            ShieldInfo shieldInfo = (ShieldInfo)entity;
            int percentageToIncrease = ShieldHelper.processDamage(stack, blockedDamage);
            if (this.damageSource.method_48789(class_8103.field_42247)) {
                percentageToIncrease /= 2;
            }
            if (this.damageSource.method_60948() != null && this.damageSource.method_60948().method_31573(class_3489.field_42612)) {
                percentageToIncrease *= 2;
            }
            if (entity.method_6048() <= ShieldHelper.getParryWindow(stack) && ShieldHelper.canBeParried(this.damageSource)) {
                percentageToIncrease = (int)((float)percentageToIncrease / ShieldHelper.getParryBonus(stack));
            }
            shieldInfo.setPercentageDamageAndSync(Math.max(shieldInfo.getPercentageDamage() + percentageToIncrease, 0), (class_3222)entity);
            this.hurtOrBlockedTime = 10;
            this.recoveryDelay = 100;
            if (shieldInfo.getPercentageDamage() >= 100) {
                float disableTime = 15.0f;
                if (CRConfig.get().general.integrations.enderscape && stack.method_31573(CRItemTags.RUBBLE_SHIELD)) {
                    disableTime = 10.0f;
                }
                if (stack.method_7909() instanceof class_1819) {
                    player.method_7357().method_7906(class_1802.field_8255, (int)(disableTime * 20.0f));
                    player.method_6021();
                    player.method_37908().method_8421((class_1297)player, (byte)30);
                }
                shieldInfo.setPercentageDamageAndSync(0, (class_3222)entity);
                entity.method_5780("should_disable_shield");
            }
        }
    }

    @Inject(method={"method_5670()V"}, at={@At(value="HEAD")})
    private void decreaseHurtOrBlockedTime(CallbackInfo ci) {
        if (this.hurtOrBlockedTime > 0) {
            --this.hurtOrBlockedTime;
        }
    }

    @Inject(method={"method_48922(Lnet/minecraft/class_1282;)V"}, at={@At(value="HEAD")})
    private void setHurtOrBlockedTime(CallbackInfo ci) {
        this.hurtOrBlockedTime = this.field_6235;
    }

    @Inject(method={"method_5773()V"}, at={@At(value="HEAD")})
    private void passiveShieldRecovery(CallbackInfo ci) {
        class_3222 player;
        class_1309 entity;
        block13: {
            block12: {
                entity = (class_1309)class_1309.class.cast(this);
                if (!(entity instanceof class_3222)) break block12;
                player = (class_3222)entity;
                if (CRConfig.get().general.combat.shield_overhaul) break block13;
            }
            return;
        }
        if (player.method_5752().contains("stop_shield_recharge")) {
            int disableTime = 3;
            if (player.method_5752().contains("stop_shield_recharge_1")) {
                disableTime = 4;
                player.method_5738("stop_shield_recharge_1");
            }
            if (player.method_5752().contains("stop_shield_recharge_2")) {
                disableTime = 5;
                player.method_5738("stop_shield_recharge_2");
            }
            if (player.method_5752().contains("stop_shield_recharge_3")) {
                disableTime = 6;
                player.method_5738("stop_shield_recharge_3");
            }
            this.recoveryDelay = Math.min(this.recoveryDelay + disableTime * 20, 100 + disableTime * 20);
            player.method_5738("stop_shield_recharge");
        }
        ++this.localTick;
        if (this.localTick >= 5) {
            if (this.recoveryDelay == 0) {
                ShieldInfo shieldInfo;
                if (entity instanceof ShieldInfo && (shieldInfo = (ShieldInfo)entity).getPercentageDamage() > 0) {
                    shieldInfo.setPercentageDamageAndSync(Math.max(shieldInfo.getPercentageDamage(), 0) - 1, player);
                }
            } else {
                this.recoveryDelay = Math.max(this.recoveryDelay - this.localTick, 0);
            }
            this.localTick = 0;
        }
    }

    @ModifyConstant(method={"method_6039()Z"}, constant={@Constant(intValue=5)})
    private int removeShieldDelay(int original) {
        return CRConfig.get().general.combat.shield_delay;
    }

    @ModifyVariable(method={"method_5643(Lnet/minecraft/class_1282;F)Z"}, at=@At(value="HEAD"), index=2, argsOnly=true)
    private float activeShieldRecovery(float value) {
        ShieldInfo shieldInfo;
        class_1657 player;
        class_1297 class_12972;
        if (CRConfig.get().general.combat.shield_overhaul && (class_12972 = this.damageSource.method_5529()) instanceof class_1657 && (player = (class_1657)class_12972) instanceof ShieldInfo && (shieldInfo = (ShieldInfo)player).getPercentageDamage() > 0 && this.hurtOrBlockedTime == 0) {
            float restoration = value / 2.0f;
            class_1799 stack = player.method_59958();
            int dueling = CREnchantments.getLevel(stack, CREnchantments.DUELING);
            restoration *= 1.0f + (float)dueling / 3.0f;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                shieldInfo.setPercentageDamageAndSync((int)Math.max((float)shieldInfo.getPercentageDamage() - restoration, 0.0f), serverPlayer);
            }
        }
        return value;
    }
}

