/*
 * Decompiled with CFR 0.152.
 */
package yeah.im.liam.rpglocatorbar.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import yeah.im.liam.rpglocatorbar.config.LocatorConfig;

public final class LocatorConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static LocatorConfig config;
    private static Path configPath;

    private LocatorConfigManager() {
    }

    public static synchronized void init(Path configDir) {
        configPath = configDir.resolve("rpglocatorbar.json");
        LocatorConfigManager.load();
    }

    public static synchronized LocatorConfig get() {
        if (config == null) {
            LocatorConfigManager.load();
        }
        return config;
    }

    public static synchronized void save() {
        if (configPath == null) {
            return;
        }
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
                GSON.toJson((Object)LocatorConfigManager.get(), (Appendable)writer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void load() {
        LocatorConfig defaults = new LocatorConfig();
        if (configPath == null) {
            config = defaults;
            return;
        }
        if (Files.exists(configPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configPath);){
                LocatorConfig loaded = (LocatorConfig)GSON.fromJson((Reader)reader, LocatorConfig.class);
                config = loaded != null ? loaded : defaults;
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        config = defaults;
    }
}

