/*
 * Decompiled with CFR 0.152.
 */
package yeah.im.liam.rpglocatorbar.config.ui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import yeah.im.liam.rpglocatorbar.config.LocatorConfig;
import yeah.im.liam.rpglocatorbar.config.LocatorConfigManager;

public final class LocatorConfigScreen
extends Screen {
    private static final int MIN_OFFSET_PX = -7;
    private static final int MAX_OFFSET_PX = 220;
    private final Screen parent;
    private LocatorOffsetSlider offsetSlider;
    private CycleButton<Boolean> xpToggle;
    private CycleButton<Boolean> hideXpCreativeToggle;
    private CycleButton<Boolean> locatorDuringXpToggle;
    private CycleButton<Boolean> locatorAlwaysOnToggle;

    public LocatorConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"rpglocatorbar.config.title"));
        this.parent = parent;
    }

    protected void init() {
        LocatorConfig config = LocatorConfigManager.get();
        int center = this.width / 2;
        int y = Math.max(20, this.height / 4 - 24);
        this.offsetSlider = new LocatorOffsetSlider(center - 100, y, 200, 20, config.locatorYOffset);
        this.addRenderableWidget((GuiEventListener)this.offsetSlider);
        this.xpToggle = CycleButton.onOffBuilder((boolean)config.renderExperienceOverlay).create(center - 100, y += 26, 200, 20, (Component)Component.translatable((String)"rpglocatorbar.config.render_xp_overlay"), (button, value) -> {
            config.renderExperienceOverlay = value;
        });
        this.addRenderableWidget((GuiEventListener)this.xpToggle);
        this.hideXpCreativeToggle = CycleButton.onOffBuilder((boolean)config.hideXpInCreative).create(center - 100, y += 24, 200, 20, (Component)Component.translatable((String)"rpglocatorbar.config.hide_xp_creative"), (button, value) -> {
            config.hideXpInCreative = value;
        });
        this.addRenderableWidget((GuiEventListener)this.hideXpCreativeToggle);
        this.locatorDuringXpToggle = CycleButton.onOffBuilder((boolean)config.keepLocatorVisibleDuringXpGain).create(center - 100, y += 24, 200, 20, (Component)Component.translatable((String)"rpglocatorbar.config.keep_locator_during_xp"), (button, value) -> {
            config.keepLocatorVisibleDuringXpGain = value;
        });
        this.addRenderableWidget((GuiEventListener)this.locatorDuringXpToggle);
        this.locatorAlwaysOnToggle = CycleButton.onOffBuilder((boolean)config.alwaysShowLocator).create(center - 100, y += 24, 200, 20, (Component)Component.translatable((String)"rpglocatorbar.config.always_show_locator"), (button, value) -> {
            config.alwaysShowLocator = value;
        });
        this.addRenderableWidget((GuiEventListener)this.locatorAlwaysOnToggle);
        Button reset = Button.builder((Component)Component.translatable((String)"rpglocatorbar.config.default_settings"), b -> {
            LocatorConfig defaults = new LocatorConfig();
            LocatorConfig live = LocatorConfigManager.get();
            live.locatorYOffset = defaults.locatorYOffset;
            live.renderExperienceOverlay = defaults.renderExperienceOverlay;
            live.hideXpInCreative = defaults.hideXpInCreative;
            live.keepLocatorVisibleDuringXpGain = defaults.keepLocatorVisibleDuringXpGain;
            live.alwaysShowLocator = defaults.alwaysShowLocator;
            this.offsetSlider.setOffset(live.locatorYOffset);
            this.xpToggle.setValue((Object)live.renderExperienceOverlay);
            this.hideXpCreativeToggle.setValue((Object)live.hideXpInCreative);
            this.locatorDuringXpToggle.setValue((Object)live.keepLocatorVisibleDuringXpGain);
            this.locatorAlwaysOnToggle.setValue((Object)live.alwaysShowLocator);
        }).pos(center - 100, y += 24).size(200, 20).build();
        this.addRenderableWidget((GuiEventListener)reset);
        Button done = Button.builder((Component)Component.translatable((String)"gui.done"), b -> this.onClose()).pos(center - 50, y += 30).size(100, 20).build();
        this.addRenderableWidget((GuiEventListener)done);
    }

    public void onClose() {
        LocatorConfig config = LocatorConfigManager.get();
        config.locatorYOffset = this.offsetSlider.getOffset();
        LocatorConfigManager.save();
        Minecraft client = Minecraft.getInstance();
        if (client != null) {
            client.setScreen(this.parent);
        }
    }

    private static final class LocatorOffsetSlider
    extends AbstractSliderButton {
        private int offset;

        LocatorOffsetSlider(int x, int y, int width, int height, int initialOffset) {
            super(x, y, width, height, (Component)Component.empty(), 0.0);
            this.offset = Mth.clamp((int)initialOffset, (int)-7, (int)220);
            this.value = (double)(this.offset - -7) / 227.0;
            this.updateMessage();
        }

        int getOffset() {
            return this.offset;
        }

        void setOffset(int newOffset) {
            this.offset = Mth.clamp((int)newOffset, (int)-7, (int)220);
            this.value = (double)(this.offset - -7) / 227.0;
            this.updateMessage();
        }

        protected void updateMessage() {
            this.setMessage((Component)Component.translatable((String)"rpglocatorbar.config.offset", (Object[])new Object[]{this.offset}));
        }

        protected void applyValue() {
            double range = 227.0;
            this.offset = Mth.clamp((int)((int)Math.round(-7.0 + this.value * range)), (int)-7, (int)220);
        }
    }
}

