/*
 * Decompiled with CFR 0.152.
 */
package yeah.im.liam.rpglocatorbar.mixin;

import com.mojang.blaze3d.platform.Window;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.contextualbar.ContextualBarRenderer;
import net.minecraft.client.gui.contextualbar.ExperienceBarRenderer;
import net.minecraft.client.gui.contextualbar.LocatorBarRenderer;
import net.minecraft.world.level.GameType;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Desc;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import yeah.im.liam.rpglocatorbar.config.LocatorConfig;
import yeah.im.liam.rpglocatorbar.config.LocatorConfigManager;

@Mixin(value={Gui.class})
public abstract class GuiMixin {
    @Shadow
    @Final
    private Map<?, Supplier<ContextualBarRenderer>> contextualInfoBarRenderers;
    @Shadow
    private Pair<?, ContextualBarRenderer> contextualInfoBar;

    @Redirect(method={"renderHotbarAndDecorations"}, at=@At(value="INVOKE", desc=@Desc(owner=ContextualBarRenderer.class, value="render", args={GuiGraphics.class, DeltaTracker.class})))
    private void rpglocatorbar$redirectContextualRender(ContextualBarRenderer renderer, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        boolean canRenderXp;
        if (this.contextualInfoBar == null || renderer == null || renderer == ContextualBarRenderer.EMPTY) {
            return;
        }
        LocatorConfig config = LocatorConfigManager.get();
        boolean locatorActive = renderer instanceof LocatorBarRenderer;
        boolean xpActive = renderer instanceof ExperienceBarRenderer;
        ContextualBarRenderer xpRenderer = this.rpglocatorbar$getExperienceRenderer();
        ContextualBarRenderer locatorRenderer = this.rpglocatorbar$getLocatorRenderer();
        boolean hasLocator = this.rpglocatorbar$hasLocatorTargets(config);
        boolean bl = canRenderXp = config.renderExperienceOverlay && this.rpglocatorbar$canRenderXpBar();
        if (locatorActive && canRenderXp && xpRenderer != null && xpRenderer != ContextualBarRenderer.EMPTY) {
            xpRenderer.renderBackground(guiGraphics, deltaTracker);
            xpRenderer.render(guiGraphics, deltaTracker);
        }
        renderer.render(guiGraphics, deltaTracker);
        if (xpActive && (config.keepLocatorVisibleDuringXpGain || config.alwaysShowLocator) && locatorRenderer != null && locatorRenderer != renderer && hasLocator) {
            locatorRenderer.renderBackground(guiGraphics, deltaTracker);
            locatorRenderer.render(guiGraphics, deltaTracker);
        }
        if (!xpActive && !locatorActive && canRenderXp && xpRenderer != null && xpRenderer != ContextualBarRenderer.EMPTY) {
            xpRenderer.renderBackground(guiGraphics, deltaTracker);
            xpRenderer.render(guiGraphics, deltaTracker);
        }
        if (!locatorActive && locatorRenderer != null && locatorRenderer != renderer && hasLocator && (!xpActive || config.keepLocatorVisibleDuringXpGain || config.alwaysShowLocator)) {
            locatorRenderer.renderBackground(guiGraphics, deltaTracker);
            locatorRenderer.render(guiGraphics, deltaTracker);
        }
    }

    @Redirect(method={"renderHotbarAndDecorations"}, at=@At(value="INVOKE", desc=@Desc(owner=ContextualBarRenderer.class, value="renderExperienceLevel", args={GuiGraphics.class, Font.class, int.class})))
    private void rpglocatorbar$suppressVanillaLevel(GuiGraphics guiGraphics, Font font, int level) {
    }

    @Inject(method={"renderHotbarAndDecorations"}, at={@At(value="TAIL")})
    private void rpglocatorbar$drawLevelAtTail(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        ContextualBarRenderer xp;
        Minecraft mc = Minecraft.getInstance();
        LocatorConfig config = LocatorConfigManager.get();
        if (mc != null && mc.gameMode != null && mc.gameMode.getPlayerMode() == GameType.CREATIVE && !config.hideXpInCreative && this.rpglocatorbar$canRenderXpBar() && (xp = this.rpglocatorbar$getExperienceRenderer()) != null) {
            xp.renderBackground(guiGraphics, deltaTracker);
            xp.render(guiGraphics, deltaTracker);
        }
        this.rpglocatorbar$drawXpLevel(guiGraphics);
    }

    private ContextualBarRenderer rpglocatorbar$getExperienceRenderer() {
        if (this.contextualInfoBarRenderers != null) {
            for (Supplier<ContextualBarRenderer> supplier : this.contextualInfoBarRenderers.values()) {
                ContextualBarRenderer r = supplier.get();
                if (r instanceof ExperienceBarRenderer) {
                    return r;
                }
                if (r == null || !r.getClass().getSimpleName().toLowerCase().contains("experience")) continue;
                return r;
            }
        }
        return null;
    }

    private boolean rpglocatorbar$shouldShowLocator(LocatorConfig config, boolean locatorActive) {
        return config.alwaysShowLocator || locatorActive;
    }

    private ContextualBarRenderer rpglocatorbar$getLocatorRenderer() {
        if (this.contextualInfoBarRenderers != null) {
            for (Supplier<ContextualBarRenderer> supplier : this.contextualInfoBarRenderers.values()) {
                ContextualBarRenderer r = supplier.get();
                if (r instanceof LocatorBarRenderer) {
                    return r;
                }
                if (r == null || !r.getClass().getSimpleName().toLowerCase().contains("locator")) continue;
                return r;
            }
        }
        return null;
    }

    private boolean rpglocatorbar$canRenderXpBar() {
        boolean hasXp;
        Minecraft mc = Minecraft.getInstance();
        LocatorConfig config = LocatorConfigManager.get();
        if (mc == null || mc.player == null) {
            return false;
        }
        if (mc.options != null && mc.options.hideGui) {
            return false;
        }
        if (mc.player.isSpectator()) {
            return false;
        }
        boolean inCreative = mc.gameMode != null && mc.gameMode.getPlayerMode() == GameType.CREATIVE;
        int level = mc.player.experienceLevel;
        if (level <= 0) {
            return false;
        }
        boolean bl = hasXp = mc.gameMode != null && mc.gameMode.hasExperience();
        if (inCreative) {
            return !config.hideXpInCreative;
        }
        return hasXp;
    }

    private boolean rpglocatorbar$hasLocatorTargets(LocatorConfig config) {
        if (config.alwaysShowLocator) {
            return true;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.player == null || mc.player.connection == null) {
            return false;
        }
        return mc.player.connection.getWaypointManager().hasWaypoints();
    }

    private int rpglocatorbar$getExperienceBarTop(Window window) {
        ContextualBarRenderer active;
        ContextualBarRenderer xp = this.rpglocatorbar$getExperienceRenderer();
        if (xp != null) {
            return xp.top(window);
        }
        if (this.contextualInfoBar != null && (active = (ContextualBarRenderer)this.contextualInfoBar.getRight()) != null && active != ContextualBarRenderer.EMPTY) {
            return active.top(window);
        }
        return window.getGuiScaledHeight() - 5 - 24;
    }

    private void rpglocatorbar$drawXpLevel(GuiGraphics guiGraphics) {
        boolean inCreative;
        Minecraft mc = Minecraft.getInstance();
        LocatorConfig config = LocatorConfigManager.get();
        if (mc == null || mc.player == null || mc.font == null) {
            return;
        }
        if (mc.options != null && mc.options.hideGui) {
            return;
        }
        if (mc.player.isSpectator()) {
            return;
        }
        boolean bl = inCreative = mc.gameMode != null && mc.gameMode.getPlayerMode() == GameType.CREATIVE;
        if (inCreative && config.hideXpInCreative) {
            return;
        }
        int level = mc.player.experienceLevel;
        if (level <= 0) {
            return;
        }
        guiGraphics.nextStratum();
        ContextualBarRenderer.renderExperienceLevel((GuiGraphics)guiGraphics, (Font)mc.font, (int)level);
    }
}

