/*
 * Decompiled with CFR 0.152.
 */
package yeah.im.liam.rpglocatorbar.neoforge.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.contextualbar.ContextualBarRenderer;
import net.minecraft.client.gui.contextualbar.ExperienceBarRenderer;
import net.minecraft.client.gui.contextualbar.LocatorBarRenderer;
import net.minecraft.world.level.GameType;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import yeah.im.liam.rpglocatorbar.config.LocatorConfig;
import yeah.im.liam.rpglocatorbar.config.LocatorConfigManager;

public final class ClientHudEvents {
    private static ExperienceBarRenderer xpRenderer;
    private static LocatorBarRenderer locatorRenderer;

    private ClientHudEvents() {
    }

    public static void onRenderGuiPost(RenderGuiEvent.Post event) {
        ExperienceBarRenderer renderer;
        Minecraft mc = Minecraft.getInstance();
        GuiGraphics guiGraphics = event.getGuiGraphics();
        if (mc == null || guiGraphics == null || mc.player == null || mc.font == null) {
            return;
        }
        LocatorConfig config = LocatorConfigManager.get();
        boolean renderXpBar = config.renderExperienceOverlay && ClientHudEvents.canRenderXpBar(mc, config);
        boolean renderLevel = ClientHudEvents.canRenderXpLevel(mc, config);
        boolean renderLocator = ClientHudEvents.shouldRenderLocator(mc, config, renderXpBar, renderXpBar);
        if (renderXpBar) {
            renderer = ClientHudEvents.getXpRenderer(mc);
            renderer.renderBackground(guiGraphics, event.getPartialTick());
            renderer.render(guiGraphics, event.getPartialTick());
        }
        if (renderLocator) {
            renderer = ClientHudEvents.getLocatorRenderer(mc);
            renderer.renderBackground(guiGraphics, event.getPartialTick());
            renderer.render(guiGraphics, event.getPartialTick());
        }
        if (renderLevel) {
            guiGraphics.nextStratum();
            ContextualBarRenderer.renderExperienceLevel((GuiGraphics)guiGraphics, (Font)mc.font, (int)mc.player.experienceLevel);
        }
    }

    private static ExperienceBarRenderer getXpRenderer(Minecraft mc) {
        if (xpRenderer == null) {
            xpRenderer = new ExperienceBarRenderer(mc);
        }
        return xpRenderer;
    }

    private static LocatorBarRenderer getLocatorRenderer(Minecraft mc) {
        if (locatorRenderer == null) {
            locatorRenderer = new LocatorBarRenderer(mc);
        }
        return locatorRenderer;
    }

    private static boolean canRenderXpBar(Minecraft mc, LocatorConfig config) {
        boolean hasXp;
        if (mc.options != null && mc.options.hideGui) {
            return false;
        }
        if (mc.player.isSpectator()) {
            return false;
        }
        boolean inCreative = mc.gameMode != null && mc.gameMode.getPlayerMode() == GameType.CREATIVE;
        int level = mc.player.experienceLevel;
        boolean bl = hasXp = mc.gameMode != null && mc.gameMode.hasExperience();
        if (inCreative) {
            return !config.hideXpInCreative;
        }
        return hasXp && level > 0;
    }

    private static boolean canRenderXpLevel(Minecraft mc, LocatorConfig config) {
        boolean inCreative;
        if (mc.options != null && mc.options.hideGui) {
            return false;
        }
        if (mc.player.isSpectator()) {
            return false;
        }
        boolean bl = inCreative = mc.gameMode != null && mc.gameMode.getPlayerMode() == GameType.CREATIVE;
        if (inCreative && config.hideXpInCreative) {
            return false;
        }
        int level = mc.player.experienceLevel;
        return level > 0;
    }

    private static boolean shouldRenderLocator(Minecraft mc, LocatorConfig config, boolean xpActive, boolean renderXpBar) {
        if (mc.options != null && mc.options.hideGui) {
            return false;
        }
        if (mc.player == null || mc.player.isSpectator()) {
            return false;
        }
        if (renderXpBar && !config.keepLocatorVisibleDuringXpGain) {
            return false;
        }
        try {
            boolean hasTargets;
            boolean bl = hasTargets = mc.player.connection != null && mc.player.connection.getWaypointManager().hasWaypoints();
            if (hasTargets) {
                return true;
            }
            return config.alwaysShowLocator;
        }
        catch (Throwable ignored) {
            return false;
        }
    }
}

