/*
 * Decompiled with CFR 0.152.
 */
package yeah.im.liam.rpglocatorbar.neoforge.client;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.Identifier;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import yeah.im.liam.rpglocatorbar.config.ui.LocatorConfigScreen;

public final class ClientKeyHandler {
    private static final KeyMapping.Category CATEGORY = KeyMapping.Category.register((Identifier)Identifier.fromNamespaceAndPath((String)"rpglocatorbar", (String)"key_category"));
    private static final KeyMapping OPEN_CONFIG = new KeyMapping("key.rpglocatorbar.config_menu", InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), CATEGORY);
    private static boolean registered = false;

    private ClientKeyHandler() {
    }

    public static void onClientTick(ClientTickEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null) {
            return;
        }
        ClientKeyHandler.ensureRegistered(mc.options);
        while (OPEN_CONFIG.consumeClick()) {
            Screen current = mc.screen;
            if (mc.player == null) continue;
            mc.setScreen((Screen)new LocatorConfigScreen(current));
        }
    }

    private static void ensureRegistered(Options options) {
        if (registered || options == null) {
            return;
        }
        KeyMapping[] existing = options.keyMappings;
        KeyMapping[] updated = new KeyMapping[existing.length + 1];
        System.arraycopy(existing, 0, updated, 0, existing.length);
        updated[existing.length] = OPEN_CONFIG;
        options.keyMappings = updated;
        registered = true;
    }
}

