/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.block.api.dripstone;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5689;
import org.jetbrains.annotations.ApiStatus;

public class DripstoneDripApi {
    private static final Map<class_2248, List<InjectedDrip>> WATER_DRIP_METHODS = new Object2ObjectOpenHashMap();
    private static final Map<class_2248, List<InjectedDrip>> LAVA_DRIP_METHODS = new Object2ObjectOpenHashMap();

    public static class_3611 getDripstoneFluid(class_3218 level, class_2338 pos) {
        class_2338 stalacticPos = class_5689.method_32767((class_1937)level, (class_2338)pos);
        if (stalacticPos == null) {
            return class_3612.field_15906;
        }
        return class_5689.method_32775((class_3218)level, (class_2338)stalacticPos);
    }

    public static void addWaterDrip(class_2248 block, InjectedDrip injectedDrip) {
        if (WATER_DRIP_METHODS.containsKey(block)) {
            WATER_DRIP_METHODS.get(block).add(injectedDrip);
        } else {
            WATER_DRIP_METHODS.put(block, Lists.newArrayList((Object[])new InjectedDrip[]{injectedDrip}));
        }
    }

    @ApiStatus.Internal
    public static boolean containsWaterDrip(class_2248 block) {
        return WATER_DRIP_METHODS.containsKey(block);
    }

    @ApiStatus.Internal
    public static void runWaterDripsIfPresent(class_2248 block, class_3218 level, class_2338 pos, class_5689.class_7381 fluidInfo) {
        Optional.ofNullable(WATER_DRIP_METHODS.getOrDefault(block, null)).ifPresent(drips -> drips.forEach(injectedDrip -> injectedDrip.onDrip(level, pos, fluidInfo)));
    }

    public static void addLavaDrip(class_2248 block, InjectedDrip injectedDrip) {
        if (LAVA_DRIP_METHODS.containsKey(block)) {
            LAVA_DRIP_METHODS.get(block).add(injectedDrip);
        } else {
            LAVA_DRIP_METHODS.put(block, Lists.newArrayList((Object[])new InjectedDrip[]{injectedDrip}));
        }
    }

    @ApiStatus.Internal
    public static boolean containsLavaDrip(class_2248 block) {
        return LAVA_DRIP_METHODS.containsKey(block);
    }

    @ApiStatus.Internal
    public static void runLavaDripsIfPresent(class_2248 block, class_3218 level, class_2338 pos, class_5689.class_7381 fluidInfo) {
        Optional.ofNullable(LAVA_DRIP_METHODS.getOrDefault(block, null)).ifPresent(drips -> drips.forEach(injectedDrip -> injectedDrip.onDrip(level, pos, fluidInfo)));
    }

    @FunctionalInterface
    public static interface InjectedDrip {
        public void onDrip(class_3218 var1, class_2338 var2, class_5689.class_7381 var3);
    }
}

