/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.block.client.api;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4588;
import net.minecraft.class_761;

@Environment(value=EnvType.CLIENT)
public class LiquidRenderUtils {
    public static void tesselateWithSingleTexture(class_1920 level, class_2338 pos, class_4588 vertexConsumer, class_2680 state, class_3610 fluidState, class_1058 sprite) {
        int color;
        float southWestHeight;
        float southEastHeight;
        float northWestHeight;
        float northEastHeight;
        class_2680 downState = level.method_8320(pos.method_10093(class_2350.field_11033));
        class_3610 downFluidState = downState.method_26227();
        class_2680 upState = level.method_8320(pos.method_10093(class_2350.field_11036));
        class_3610 upFluidState = upState.method_26227();
        class_2680 northState = level.method_8320(pos.method_10093(class_2350.field_11043));
        class_3610 northFluidState = northState.method_26227();
        class_2680 southState = level.method_8320(pos.method_10093(class_2350.field_11035));
        class_3610 southFluidState = southState.method_26227();
        class_2680 westState = level.method_8320(pos.method_10093(class_2350.field_11039));
        class_3610 westFluidState = westState.method_26227();
        class_2680 eastState = level.method_8320(pos.method_10093(class_2350.field_11034));
        class_3610 eastFluidState = eastState.method_26227();
        boolean renderUp = !LiquidRenderUtils.isNeighborSameFluidAndBlock(fluidState, upFluidState, state, upState);
        boolean renderDown = LiquidRenderUtils.shouldRenderFace(level, pos, fluidState, state, class_2350.field_11033, downFluidState, downState) && !LiquidRenderUtils.isFaceOccludedByNeighbor((class_1922)level, pos, class_2350.field_11033, 0.8888889f, downState, state);
        boolean renderNorth = LiquidRenderUtils.shouldRenderFace(level, pos, fluidState, state, class_2350.field_11043, northFluidState, northState);
        boolean renderSouth = LiquidRenderUtils.shouldRenderFace(level, pos, fluidState, state, class_2350.field_11035, southFluidState, southState);
        boolean renderEast = LiquidRenderUtils.shouldRenderFace(level, pos, fluidState, state, class_2350.field_11034, eastFluidState, eastState);
        boolean renderWest = LiquidRenderUtils.shouldRenderFace(level, pos, fluidState, state, class_2350.field_11039, westFluidState, westState);
        if (!(renderUp || renderDown || renderEast || renderWest || renderNorth || renderSouth)) {
            return;
        }
        float downShade = level.method_24852(class_2350.field_11033, true);
        float upShade = level.method_24852(class_2350.field_11036, true);
        float northShade = level.method_24852(class_2350.field_11043, true);
        float westShade = level.method_24852(class_2350.field_11039, true);
        class_3611 fluid = fluidState.method_15772();
        float fluidHeight = LiquidRenderUtils.getHeight(level, fluid, pos, state, fluidState);
        if (fluidHeight >= 1.0f) {
            northEastHeight = 1.0f;
            northWestHeight = 1.0f;
            southEastHeight = 1.0f;
            southWestHeight = 1.0f;
        } else {
            float northHeight = LiquidRenderUtils.getHeight(level, fluid, pos.method_10095(), northState, northFluidState);
            float southHeight = LiquidRenderUtils.getHeight(level, fluid, pos.method_10072(), southState, southFluidState);
            float eastHeight = LiquidRenderUtils.getHeight(level, fluid, pos.method_10078(), eastState, eastFluidState);
            float westHeight = LiquidRenderUtils.getHeight(level, fluid, pos.method_10067(), westState, westFluidState);
            northEastHeight = LiquidRenderUtils.calculateAverageHeight(level, fluid, fluidHeight, northHeight, eastHeight, pos.method_10093(class_2350.field_11043).method_10093(class_2350.field_11034));
            northWestHeight = LiquidRenderUtils.calculateAverageHeight(level, fluid, fluidHeight, northHeight, westHeight, pos.method_10093(class_2350.field_11043).method_10093(class_2350.field_11039));
            southEastHeight = LiquidRenderUtils.calculateAverageHeight(level, fluid, fluidHeight, southHeight, eastHeight, pos.method_10093(class_2350.field_11035).method_10093(class_2350.field_11034));
            southWestHeight = LiquidRenderUtils.calculateAverageHeight(level, fluid, fluidHeight, southHeight, westHeight, pos.method_10093(class_2350.field_11035).method_10093(class_2350.field_11039));
        }
        float renderX = pos.method_10263() & 0xF;
        float renderY = pos.method_10264() & 0xF;
        float renderZ = pos.method_10260() & 0xF;
        float renderYOffset = renderDown ? 0.001f : 0.0f;
        float u0 = sprite.method_4594();
        float u1 = sprite.method_4577();
        float v0 = sprite.method_4593();
        float v1 = sprite.method_4575();
        if (renderUp && !LiquidRenderUtils.isFaceOccludedByNeighbor((class_1922)level, pos, class_2350.field_11036, Math.min(Math.min(northWestHeight, southWestHeight), Math.min(southEastHeight, northEastHeight)), upState, state)) {
            color = LiquidRenderUtils.getLightColor(level, pos);
            LiquidRenderUtils.vertex(vertexConsumer, renderX + 0.0f, renderY + (northWestHeight -= 0.001f), renderZ + 0.0f, upShade, upShade, upShade, u0, v0, color);
            LiquidRenderUtils.vertex(vertexConsumer, renderX + 0.0f, renderY + (southWestHeight -= 0.001f), renderZ + 1.0f, upShade, upShade, upShade, u0, v1, color);
            LiquidRenderUtils.vertex(vertexConsumer, renderX + 1.0f, renderY + (southEastHeight -= 0.001f), renderZ + 1.0f, upShade, upShade, upShade, u1, v1, color);
            LiquidRenderUtils.vertex(vertexConsumer, renderX + 1.0f, renderY + (northEastHeight -= 0.001f), renderZ + 0.0f, upShade, upShade, upShade, u1, v0, color);
            if (fluidState.method_15756((class_1922)level, pos.method_10084()) || !state.equals((Object)downState)) {
                LiquidRenderUtils.vertex(vertexConsumer, renderX + 0.0f, renderY + northWestHeight, renderZ + 0.0f, upShade, upShade, upShade, u0, v0, color);
                LiquidRenderUtils.vertex(vertexConsumer, renderX + 1.0f, renderY + northEastHeight, renderZ + 0.0f, upShade, upShade, upShade, u1, v0, color);
                LiquidRenderUtils.vertex(vertexConsumer, renderX + 1.0f, renderY + southEastHeight, renderZ + 1.0f, upShade, upShade, upShade, u1, v1, color);
                LiquidRenderUtils.vertex(vertexConsumer, renderX + 0.0f, renderY + southWestHeight, renderZ + 1.0f, upShade, upShade, upShade, u0, v1, color);
            }
        }
        if (renderDown) {
            int belowColor = LiquidRenderUtils.getLightColor(level, pos.method_10074());
            LiquidRenderUtils.vertex(vertexConsumer, renderX, renderY + renderYOffset, renderZ + 1.0f, downShade, downShade, downShade, u0, v1, belowColor);
            LiquidRenderUtils.vertex(vertexConsumer, renderX, renderY + renderYOffset, renderZ, downShade, downShade, downShade, u0, v0, belowColor);
            LiquidRenderUtils.vertex(vertexConsumer, renderX + 1.0f, renderY + renderYOffset, renderZ, downShade, downShade, downShade, u1, v0, belowColor);
            LiquidRenderUtils.vertex(vertexConsumer, renderX + 1.0f, renderY + renderYOffset, renderZ + 1.0f, downShade, downShade, downShade, u1, v1, belowColor);
            if (downState.method_26204() != state.method_26204() && !downState.method_26225()) {
                LiquidRenderUtils.vertex(vertexConsumer, renderX, renderY + renderYOffset, renderZ + 1.0f, downShade, downShade, downShade, u0, v1, belowColor);
                LiquidRenderUtils.vertex(vertexConsumer, renderX + 1.0f, renderY + renderYOffset, renderZ + 1.0f, downShade, downShade, downShade, u0, v0, belowColor);
                LiquidRenderUtils.vertex(vertexConsumer, renderX + 1.0f, renderY + renderYOffset, renderZ, downShade, downShade, downShade, u1, v0, belowColor);
                LiquidRenderUtils.vertex(vertexConsumer, renderX, renderY + renderYOffset, renderZ, downShade, downShade, downShade, u1, v1, belowColor);
            }
        }
        color = LiquidRenderUtils.getLightColor(level, pos);
        block5: for (class_2350 direction : class_2350.class_2353.field_11062) {
            float lastZ;
            float firstZ;
            float secondX;
            float firstX;
            float secondY;
            float firstY;
            switch (direction) {
                case field_11043: {
                    firstY = northWestHeight;
                    secondY = northEastHeight;
                    firstX = renderX;
                    secondX = renderX + 1.0f;
                    lastZ = firstZ = renderZ + 0.001f;
                    if (!renderNorth) continue block5;
                    break;
                }
                case field_11035: {
                    firstY = southEastHeight;
                    secondY = southWestHeight;
                    firstX = renderX + 1.0f;
                    secondX = renderX;
                    firstZ = lastZ = renderZ + 1.0f - 0.001f;
                    if (!renderSouth) continue block5;
                    break;
                }
                case field_11039: {
                    firstY = southWestHeight;
                    secondY = northWestHeight;
                    secondX = firstX = renderX + 0.001f;
                    firstZ = renderZ + 1.0f;
                    lastZ = renderZ;
                    if (!renderWest) continue block5;
                    break;
                }
                default: {
                    firstY = northEastHeight;
                    secondY = southEastHeight;
                    secondX = firstX = renderX + 1.0f - 0.001f;
                    firstZ = renderZ;
                    lastZ = renderZ + 1.0f;
                    if (!renderEast) continue block5;
                }
            }
            if (LiquidRenderUtils.isFaceOccludedByNeighbor((class_1922)level, pos, direction, Math.max(firstY, secondY), level.method_8320(pos.method_10093(direction)), level.method_8320(pos.method_10093(direction)))) continue;
            float sideShade = upShade * (direction.method_10166() == class_2350.class_2351.field_11051 ? northShade : westShade);
            LiquidRenderUtils.vertex(vertexConsumer, firstX, renderY + firstY, firstZ, sideShade, sideShade, sideShade, u0, v0, color);
            LiquidRenderUtils.vertex(vertexConsumer, secondX, renderY + secondY, lastZ, sideShade, sideShade, sideShade, u1, v0, color);
            LiquidRenderUtils.vertex(vertexConsumer, secondX, renderY + renderYOffset, lastZ, sideShade, sideShade, sideShade, u1, v1, color);
            LiquidRenderUtils.vertex(vertexConsumer, firstX, renderY + renderYOffset, firstZ, sideShade, sideShade, sideShade, u0, v1, color);
            LiquidRenderUtils.vertex(vertexConsumer, firstX, renderY + renderYOffset, firstZ, sideShade, sideShade, sideShade, u0, v1, color);
            LiquidRenderUtils.vertex(vertexConsumer, secondX, renderY + renderYOffset, lastZ, sideShade, sideShade, sideShade, u1, v1, color);
            LiquidRenderUtils.vertex(vertexConsumer, secondX, renderY + secondY, lastZ, sideShade, sideShade, sideShade, u1, v0, color);
            LiquidRenderUtils.vertex(vertexConsumer, firstX, renderY + firstY, firstZ, sideShade, sideShade, sideShade, u0, v0, color);
        }
    }

    private static float calculateAverageHeight(class_1920 level, class_3611 fluid, float height, float adjacentHeightA, float adjacentHeightB, class_2338 fluidPos) {
        if (adjacentHeightB >= 1.0f || adjacentHeightA >= 1.0f) {
            return 1.0f;
        }
        float[] heightAndCount = new float[2];
        if (adjacentHeightB > 0.0f || adjacentHeightA > 0.0f) {
            float fluidHeight = LiquidRenderUtils.getHeight(level, fluid, fluidPos);
            if (fluidHeight >= 1.0f) {
                return 1.0f;
            }
            LiquidRenderUtils.addWeightedHeight(heightAndCount, fluidHeight);
        }
        LiquidRenderUtils.addWeightedHeight(heightAndCount, height);
        LiquidRenderUtils.addWeightedHeight(heightAndCount, adjacentHeightB);
        LiquidRenderUtils.addWeightedHeight(heightAndCount, adjacentHeightA);
        return heightAndCount[0] / heightAndCount[1];
    }

    public static void addWeightedHeight(float[] weights, float height) {
        if (height >= 0.8f) {
            weights[0] = weights[0] + height * 10.0f;
            weights[1] = weights[1] + 10.0f;
        } else if (height >= 0.0f) {
            weights[0] = weights[0] + height;
            weights[1] = weights[1] + 1.0f;
        }
    }

    public static float getHeight(class_1920 level, class_3611 fluid, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        return LiquidRenderUtils.getHeight(level, fluid, pos, state, state.method_26227());
    }

    public static float getHeight(class_1920 level, class_3611 fluid, class_2338 pos, class_2680 state, class_3610 fluidState) {
        if (fluid.method_15780(fluidState.method_15772())) {
            class_2680 aboveState = level.method_8320(pos.method_10084());
            if (fluid.method_15780(aboveState.method_26227().method_15772())) {
                return 1.0f;
            }
            return fluidState.method_20785();
        }
        if (!state.method_51367()) {
            return 0.0f;
        }
        return -1.0f;
    }

    public static void vertex(class_4588 consumer, float x, float y, float z, float red, float green, float blue, float u, float v, int packedLight) {
        consumer.method_22912(x, y, z).method_22915(red, green, blue, 1.0f).method_22913(u, v).method_60803(packedLight).method_22914(0.0f, 1.0f, 0.0f);
    }

    public static int getLightColor(class_1920 level, class_2338 pos) {
        int color = class_761.method_23794((class_1920)level, (class_2338)pos);
        int aboveColor = class_761.method_23794((class_1920)level, (class_2338)pos.method_10084());
        int k = color & 0xFF;
        int l = aboveColor & 0xFF;
        int m = color >> 16 & 0xFF;
        int n = aboveColor >> 16 & 0xFF;
        return Math.max(k, l) | Math.max(m, n) << 16;
    }

    private static boolean isNeighborSameFluidAndBlock(class_3610 firstState, class_3610 secondState, class_2680 firstBlock, class_2680 secondBlock) {
        return secondState.method_15772().method_15780(firstState.method_15772()) && firstBlock.method_26204() == secondBlock.method_26204();
    }

    private static boolean isFaceOccludedByState(class_1922 level, class_2350 face, float height, class_2338 pos, class_2680 state, class_2680 neighborState) {
        if (neighborState.method_26204() != state.method_26204() || !state.method_26225()) {
            return false;
        }
        class_265 planeShape = class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)height, (double)1.0);
        class_265 occlusionShape = state.method_26201();
        return class_259.method_1083((class_265)planeShape, (class_265)occlusionShape, (class_2350)face);
    }

    private static boolean isFaceOccludedByNeighbor(class_1922 level, class_2338 pos, class_2350 side, float height, class_2680 state, class_2680 neighborState) {
        return LiquidRenderUtils.isFaceOccludedByState(level, side, height, pos.method_10093(side), state, neighborState);
    }

    private static boolean isFaceOccludedBySelf(class_1922 level, class_2338 pos, class_2680 state, class_2350 face, class_2680 neighborState) {
        return LiquidRenderUtils.isFaceOccludedByState(level, face.method_10153(), 1.0f, pos, state, neighborState);
    }

    public static boolean shouldRenderFace(class_1920 level, class_2338 pos, class_3610 fluidState, class_2680 state, class_2350 side, class_3610 neighborFluid, class_2680 neighborState) {
        return !LiquidRenderUtils.isFaceOccludedBySelf((class_1922)level, pos, state, side, neighborState) && !LiquidRenderUtils.isNeighborSameFluidAndBlock(fluidState, neighborFluid, state, neighborState);
    }
}

