/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.config.api.instance.json;

import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.frozenblock.lib.config.api.instance.Config;
import net.frozenblock.lib.config.api.instance.ConfigSerialization;
import net.frozenblock.lib.config.api.instance.json.JsonType;
import net.frozenblock.lib.shadow.blue.endless.jankson.Jankson;

public class JsonConfig<T>
extends Config<T> {
    private final Jankson jankson;
    private final JsonType type;

    public JsonConfig(String modId, Class<T> config) {
        this(modId, config, true);
    }

    public JsonConfig(String modId, Class<T> config, JsonType type) {
        this(modId, config, type, true);
    }

    public JsonConfig(String modId, Class<T> config, Path path, JsonType type) {
        this(modId, config, path, type, true);
    }

    public JsonConfig(String modId, Class<T> config, boolean supportsModification) {
        this(modId, config, JsonType.JSON, supportsModification);
    }

    public JsonConfig(String modId, Class<T> config, JsonType type, boolean supportsModification) {
        this(modId, config, JsonConfig.makePath(modId, type.method_15434()), type, supportsModification);
    }

    public JsonConfig(String modId, Class<T> config, Path path, JsonType type, boolean supportsModification) {
        super(modId, config, path, supportsModification);
        Jankson.Builder janksonBuilder = Jankson.builder();
        this.jankson = ConfigSerialization.createJankson(janksonBuilder, modId);
        this.type = type;
        if (this.load()) {
            this.save();
        }
    }

    @Override
    public void onSave() throws Exception {
        Files.createDirectories(this.path().getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(this.path(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            writer.write(this.jankson.toJson(this.instance()).toJson(this.type.getGrammar()));
        }
    }

    @Override
    public boolean onLoad() throws Exception {
        if (!Files.exists(this.path(), new LinkOption[0])) {
            return true;
        }
        this.setConfig(this.jankson.fromJson(this.jankson.load(this.path().toFile()), this.configClass()));
        return true;
    }
}

