/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.config.api.instance.xjs;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.frozenblock.lib.config.api.entry.TypedEntry;
import net.frozenblock.lib.config.api.instance.xjs.InvalidEnumConstantException;
import net.frozenblock.lib.config.api.instance.xjs.NonSerializableObjectException;
import net.frozenblock.lib.config.api.instance.xjs.UnsafeUtils;
import net.frozenblock.lib.config.api.instance.xjs.XjsTypedEntrySerializer;
import net.frozenblock.lib.config.api.instance.xjs.XjsUtils;
import net.frozenblock.lib.shadow.blue.endless.jankson.Comment;
import net.frozenblock.lib.shadow.blue.endless.jankson.annotation.SaveToggle;
import net.frozenblock.lib.shadow.xjs.data.Json;
import net.frozenblock.lib.shadow.xjs.data.JsonArray;
import net.frozenblock.lib.shadow.xjs.data.JsonObject;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import org.jetbrains.annotations.Nullable;

public class XjsObjectMapper {
    public static void serializeObject(Path p, Object o) throws IOException, NonSerializableObjectException {
        XjsUtils.writeJson(XjsObjectMapper.toJsonObject(o), p.toFile()).throwIfErr();
    }

    public static <T> T deserializeObject(Path p, Class<T> clazz) throws NonSerializableObjectException {
        return XjsObjectMapper.deserializeObject(null, p, clazz);
    }

    public static <T> T deserializeObject(@Nullable String modId, Path p, Class<T> clazz) throws NonSerializableObjectException {
        T t = UnsafeUtils.constructUnsafely(clazz);
        Optional<JsonObject> read = XjsUtils.readJson(p.toFile());
        if (read.isEmpty()) {
            return t;
        }
        JsonObject json = read.get();
        if (json.isEmpty()) {
            return t;
        }
        XjsObjectMapper.writeObjectInto(modId, t, json);
        return t;
    }

    public static JsonValue toJsonValue(Object o) throws NonSerializableObjectException {
        if (o.getClass().isArray()) {
            return XjsObjectMapper.toJsonArray((Object[])o);
        }
        if (o.getClass().isEnum()) {
            return Json.value(((Enum)o).name());
        }
        if (o instanceof String) {
            return Json.value((String)o);
        }
        if (o instanceof Integer) {
            return Json.value(((Integer)o).intValue());
        }
        if (o instanceof Long) {
            return Json.value((Long)o);
        }
        if (o instanceof Float || o instanceof Double) {
            return Json.value(((Number)o).doubleValue());
        }
        if (o instanceof Boolean) {
            return Json.value((Boolean)o);
        }
        if (o instanceof Collection) {
            return XjsObjectMapper.toJsonArray((Collection)o);
        }
        if (o instanceof Map) {
            return XjsObjectMapper.toJsonObject((Map)o);
        }
        if (o instanceof TypedEntry) {
            return XjsTypedEntrySerializer.toJsonValue((TypedEntry)o);
        }
        return XjsObjectMapper.toJsonObject(o);
    }

    public static JsonObject toJsonObject(Object o) throws NonSerializableObjectException {
        JsonObject json = new JsonObject();
        Class<?> c = o.getClass();
        for (Field f : c.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers())) continue;
            JsonValue value = XjsObjectMapper.toJsonValue(UnsafeUtils.getUnsafely(f, o));
            String comment = XjsObjectMapper.getComment(f);
            if (comment != null) {
                value.setComment(comment);
            }
            if (!XjsObjectMapper.getSaveToggle(f)) continue;
            json.add(f.getName(), value);
        }
        return json;
    }

    @Nullable
    public static String getComment(Field f) {
        Comment[] comments = (Comment[])f.getAnnotationsByType(Comment.class);
        if (comments.length == 0) {
            return null;
        }
        return comments[0].value();
    }

    public static boolean getSaveToggle(Field f) {
        SaveToggle[] toggles = (SaveToggle[])f.getAnnotationsByType(SaveToggle.class);
        if (toggles.length == 0) {
            return true;
        }
        return toggles[0].value();
    }

    public static JsonObject toJsonObject(Map<?, ?> map) throws NonSerializableObjectException {
        JsonObject json = new JsonObject();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!(entry.getKey() instanceof String)) {
                throw NonSerializableObjectException.unsupportedKey(entry.getKey());
            }
            json.add((String)entry.getKey(), XjsObjectMapper.toJsonValue(entry.getValue()));
        }
        return json;
    }

    public static JsonArray toJsonArray(Object[] a) throws NonSerializableObjectException {
        JsonArray json = new JsonArray();
        for (Object o : a) {
            json.add(XjsObjectMapper.toJsonValue(o));
        }
        return json;
    }

    public static JsonArray toJsonArray(Collection<?> a) throws NonSerializableObjectException {
        JsonArray json = new JsonArray();
        if (a.isEmpty()) {
            return json;
        }
        for (Object o : a) {
            json.add(XjsObjectMapper.toJsonValue(o));
        }
        return json;
    }

    private static void writeObjectInto(@Nullable String modId, Object o, JsonObject json) throws NonSerializableObjectException {
        Class<?> clazz = o.getClass();
        for (JsonObject.Member member : json) {
            Field f = XjsObjectMapper.getField(clazz, member.getKey());
            if (f == null || !XjsObjectMapper.getSaveToggle(f)) continue;
            Object def = UnsafeUtils.getUnsafely(f, o);
            UnsafeUtils.setUnsafely(f, o, XjsObjectMapper.getValueByType(modId, f.getType(), def, member.getValue()));
        }
    }

    private static Field getField(Class<?> clazz, String name) {
        for (Field f : clazz.getDeclaredFields()) {
            if (!name.equals(f.getName())) continue;
            return f;
        }
        return null;
    }

    private static Object getValueByType(@Nullable String modId, Class<?> type, Object def, JsonValue value) throws NonSerializableObjectException {
        if (type.isAssignableFrom(TypedEntry.class)) {
            return XjsTypedEntrySerializer.fromJsonValue(modId, value);
        }
        if (type.isArray()) {
            return XjsObjectMapper.toArray(modId, type, def, value);
        }
        if (type.isEnum()) {
            return XjsObjectMapper.assertEnumConstant(value.asString(), type);
        }
        if (type.isAssignableFrom(String.class)) {
            return value.asString();
        }
        if (type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Integer.TYPE)) {
            return value.asInt();
        }
        if (type.isAssignableFrom(Long.class) || type.isAssignableFrom(Long.TYPE)) {
            return value.asLong();
        }
        if (type.isAssignableFrom(Float.class) || type.isAssignableFrom(Float.TYPE)) {
            return Float.valueOf(value.asFloat());
        }
        if (type.isAssignableFrom(Double.class) || type.isAssignableFrom(Double.TYPE)) {
            return value.asDouble();
        }
        if (type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.TYPE)) {
            return value.asBoolean();
        }
        if (type.isAssignableFrom(List.class)) {
            return XjsObjectMapper.toList(modId, value, def);
        }
        if (type.isAssignableFrom(Set.class)) {
            return new HashSet<Object>(XjsObjectMapper.toList(modId, value, def));
        }
        if (type.equals(Collection.class)) {
            return XjsObjectMapper.toList(modId, value, def);
        }
        if (type.isAssignableFrom(Map.class)) {
            return XjsObjectMapper.toMap(modId, value, def);
        }
        Object o = UnsafeUtils.constructUnsafely(type);
        XjsObjectMapper.writeObjectInto(modId, o, value.asObject());
        return o;
    }

    private static Object toArray(@Nullable String modId, Class<?> type, Object def, JsonValue value) throws NonSerializableObjectException {
        JsonArray json = value.asArray();
        Object[] array = new Object[json.size()];
        Object[] defaults = (Object[])def;
        def = defaults != null && defaults.length > 0 ? defaults[0] : null;
        for (int i = 0; i < json.size(); ++i) {
            array[i] = XjsObjectMapper.getValueByType(modId, type.getComponentType(), def, json.get(i));
        }
        return Arrays.copyOf(array, array.length, type);
    }

    private static List<Object> toList(@Nullable String modId, JsonValue value, Object def) throws NonSerializableObjectException {
        Collection defaults = (Collection)def;
        Object object = def = defaults != null && !defaults.isEmpty() ? (Object)defaults.iterator().next() : null;
        if (def == null) {
            throw NonSerializableObjectException.defaultRequired();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (JsonValue v : value.asArray()) {
            list.add(XjsObjectMapper.getValueByType(modId, def.getClass(), def, v));
        }
        return list;
    }

    private static Map<String, Object> toMap(@Nullable String modId, JsonValue value, Object def) throws NonSerializableObjectException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map defaults = (Map)def;
        Object object = def = defaults != null && !defaults.isEmpty() ? (Object)defaults.entrySet().iterator().next().getValue() : null;
        if (def == null) {
            throw NonSerializableObjectException.defaultRequired();
        }
        for (JsonObject.Member member : value.asObject()) {
            map.put(member.getKey(), XjsObjectMapper.getValueByType(modId, def.getClass(), def, member.getValue()));
        }
        return map;
    }

    private static <T> Optional<T> find(T[] values, Predicate<T> by) {
        for (T val : values) {
            if (!by.test(val)) continue;
            return Optional.of(val);
        }
        return Optional.empty();
    }

    private static <T extends Enum<T>> T assertEnumConstant(String s, Class<T> clazz) {
        return (T)((Enum)XjsObjectMapper.getEnumConstant(s, clazz).orElseThrow(() -> new InvalidEnumConstantException(s, clazz)));
    }

    private static <E extends Enum<E>> Optional<E> getEnumConstant(String s, Class<E> clazz) {
        return XjsObjectMapper.find((Enum[])clazz.getEnumConstants(), e -> XjsObjectMapper.isFormatted(e, s));
    }

    private static <E extends Enum<E>> boolean isFormatted(E e, String s) {
        String id = e.name().replace("_", "");
        return id.equalsIgnoreCase(s.replace("_", ""));
    }
}

