/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.config.impl.network;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.FrozenLibLogUtils;
import net.frozenblock.lib.config.api.instance.Config;
import net.frozenblock.lib.config.api.instance.ConfigModification;
import net.frozenblock.lib.config.api.registry.ConfigRegistry;
import net.frozenblock.lib.config.api.sync.network.ConfigByteBufUtil;
import net.frozenblock.lib.config.api.sync.network.ConfigSyncData;
import net.frozenblock.lib.config.impl.network.ConfigSyncModification;
import net.frozenblock.lib.networking.FrozenClientNetworking;
import net.frozenblock.lib.networking.FrozenNetworking;
import net.frozenblock.lib.shadow.blue.endless.jankson.api.SyntaxError;
import net.minecraft.class_12099;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public record ConfigSyncPacket<T>(String modId, String className, T configData) implements class_8710
{
    public static final class_8710.class_9154<ConfigSyncPacket<?>> PACKET_TYPE = new class_8710.class_9154(FrozenLibConstants.id("config_sync_packet"));
    public static final class_9139<class_2540, ConfigSyncPacket<?>> CODEC = class_9139.method_56438(ConfigSyncPacket::write, ConfigSyncPacket::create);

    @Nullable
    public static <T> ConfigSyncPacket<T> create(class_2540 buf) {
        String modId = buf.method_19772();
        if (!FabricLoader.getInstance().isModLoaded(modId)) {
            return null;
        }
        String className = buf.method_19772();
        try {
            Object configData = ConfigByteBufUtil.readJankson(buf, modId, className);
            return new ConfigSyncPacket(modId, className, configData);
        }
        catch (SyntaxError e) {
            FrozenLibLogUtils.logError("Failed to read config data from packet.", true, e);
            return null;
        }
    }

    public void write(class_2540 buf) {
        buf.method_10814(this.modId);
        buf.method_10814(this.className);
        ConfigByteBufUtil.writeJankson(buf, this.modId, this.configData);
    }

    public static <T> void receive(ConfigSyncPacket<T> packet, @Nullable MinecraftServer server) {
        String modId = packet.modId();
        String className = packet.className();
        for (Config<?> raw : ConfigRegistry.getConfigsForMod(modId)) {
            String configClassName = raw.configClass().getName();
            if (!configClassName.equals(className)) continue;
            Config<?> config = raw;
            if (server != null) {
                ConfigModification.copyInto(packet.configData(), config.instance());
                if (!FrozenNetworking.connectedToIntegratedServer()) {
                    config.save();
                }
                for (class_3222 player : PlayerLookup.all((MinecraftServer)server)) {
                    ConfigSyncPacket.sendS2C(player, List.of(config));
                }
            } else {
                boolean shouldAddModification = !ConfigRegistry.containsSyncData(config);
                ConfigRegistry.setSyncData(config, new ConfigSyncData<T>(packet.configData()));
                if (shouldAddModification) {
                    ConfigRegistry.register(config, new ConfigModification(new ConfigSyncModification(config, ConfigRegistry::getSyncData)), Integer.MIN_VALUE);
                }
            }
            config.onSync(packet.configData());
            break;
        }
    }

    public static void sendS2C(class_3222 player, Iterable<Config<?>> configs) {
        if (FrozenNetworking.isLocalPlayer((class_1657)player)) {
            return;
        }
        for (Config<?> config : configs) {
            if (!config.supportsSync()) continue;
            ConfigSyncPacket packet = new ConfigSyncPacket(config.modId(), config.configClass().getName(), config.config());
            ServerPlayNetworking.send((class_3222)player, packet);
        }
    }

    public static void sendS2C(class_3222 player) {
        ConfigSyncPacket.sendS2C(player, ConfigRegistry.getAllConfigs());
    }

    public static boolean hasPermissionsToSendSync(@Nullable class_1657 player, boolean serverSide) {
        if (player == null) {
            return false;
        }
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return player.method_75004().hasPermission(class_12099.field_63210);
        }
        if (FrozenClientNetworking.notConnected()) {
            return false;
        }
        boolean isHost = serverSide && FrozenNetworking.isLocalPlayer(player);
        return FrozenNetworking.connectedToIntegratedServer() || isHost || player.method_75004().hasPermission(class_12099.field_63210);
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendC2S(Iterable<Config<?>> configs) {
        if (!ClientPlayNetworking.canSend(PACKET_TYPE)) {
            return;
        }
        for (Config<?> config : configs) {
            if (!config.supportsSync()) continue;
            ConfigSyncPacket packet = new ConfigSyncPacket(config.modId(), config.configClass().getName(), config.instance());
            ClientPlayNetworking.send(packet);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendC2S() {
        ConfigSyncPacket.sendC2S(ConfigRegistry.getAllConfigs());
    }

    @Environment(value=EnvType.CLIENT)
    public static <T> void trySendC2S(Config<T> config) {
        if (ConfigSyncPacket.hasPermissionsToSendSync((class_1657)class_310.method_1551().field_1724, false)) {
            ConfigSyncPacket.sendC2S(List.of(config));
        }
    }

    public class_8710.class_9154<?> method_56479() {
        return PACKET_TYPE;
    }
}

