/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.integration.api;

import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.frozenblock.lib.integration.api.ModIntegration;
import net.frozenblock.lib.integration.impl.EmptyModIntegration;

public class ModIntegrationSupplier<T extends ModIntegration> {
    protected final String modID;
    protected final boolean isModLoaded;
    protected final Optional<T> optionalIntegration;
    protected final T unloadedModIntegration;

    public ModIntegrationSupplier(Supplier<T> modIntegrationSupplier, String modID) {
        this.modID = modID;
        this.isModLoaded = FabricLoader.getInstance().isModLoaded(this.modID);
        this.optionalIntegration = this.modLoaded() ? Optional.of((ModIntegration)modIntegrationSupplier.get()) : Optional.empty();
        this.unloadedModIntegration = new EmptyModIntegration(modID);
    }

    public ModIntegrationSupplier(Supplier<T> modIntegrationSupplier, Supplier<T> unloadedModIntegrationSupplier, String modID) {
        this.modID = modID;
        this.isModLoaded = FabricLoader.getInstance().isModLoaded(this.modID);
        this.optionalIntegration = this.modLoaded() ? Optional.of((ModIntegration)modIntegrationSupplier.get()) : Optional.empty();
        this.unloadedModIntegration = (ModIntegration)unloadedModIntegrationSupplier.get();
    }

    public T getIntegration() {
        return (T)((ModIntegration)this.optionalIntegration.orElse(this.unloadedModIntegration));
    }

    public Optional<T> get() {
        return this.optionalIntegration;
    }

    public boolean modLoaded() {
        return this.isModLoaded;
    }
}

