/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.item.api;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public final class ItemTooltipAdditionAPI {
    private static final Map<TooltipCondition, List<class_2561>> ADDITIONAL_TOOLTIPS = new Object2ObjectLinkedOpenHashMap();

    public static void addTooltip(class_2561 tooltip, TooltipCondition condition) {
        List<class_2561> tooltips = List.of(tooltip);
        ItemTooltipAdditionAPI.addTooltips(tooltips, condition);
    }

    public static void addTooltips(List<class_2561> tooltips, TooltipCondition condition) {
        List tooltipList = ADDITIONAL_TOOLTIPS.getOrDefault(condition, new ArrayList());
        tooltipList.addAll(tooltips);
        ADDITIONAL_TOOLTIPS.put(condition, tooltipList);
    }

    public static Optional<List<class_2561>> getTooltipsForItemStack(class_1799 stack) {
        ArrayList tooltips = new ArrayList();
        ADDITIONAL_TOOLTIPS.forEach((condition, tooltipList) -> {
            if (condition.test(stack)) {
                tooltips.addAll(tooltipList);
            }
        });
        if (tooltips.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(tooltips);
    }

    @Generated
    private ItemTooltipAdditionAPI() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface TooltipCondition {
        public boolean test(class_1799 var1);
    }
}

