/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.music.api.client.pitch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.music.api.client.pitch.MusicPitchInfo;
import net.frozenblock.lib.music.impl.client.MusicPitchDetectionType;
import net.frozenblock.lib.worldgen.structure.api.status.client.ClientStructureStatuses;
import net.frozenblock.lib.worldgen.structure.impl.status.PlayerStructureStatus;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
public final class MusicPitchApi {
    public static final Function<Long, Float> SUBTLE_PITCH_SHIFTING = l -> Float.valueOf(0.99f + class_3532.method_15374((double)((float)l.longValue() * (float)Math.PI / 1200.0f)) * 0.025f);
    private static final List<MusicPitchInfo> MUSIC_PITCH_INFO_LIST = new ArrayList<MusicPitchInfo>();
    private static float CURRENT_PITCH = 1.0f;

    public static void registerForBiome(class_2960 id, Function<Long, Float> pitchFunction) {
        MUSIC_PITCH_INFO_LIST.add(new MusicPitchInfo(MusicPitchDetectionType.BIOME, id, pitchFunction));
    }

    public static void registerForBiome(class_2960 id, float pitch) {
        MusicPitchApi.registerForBiome(id, l -> Float.valueOf(pitch));
    }

    public static void registerForStructure(class_2960 id, Function<Long, Float> pitchFunction) {
        MUSIC_PITCH_INFO_LIST.add(new MusicPitchInfo(MusicPitchDetectionType.STRUCTURE, id, pitchFunction));
    }

    public static void registerForStructure(class_2960 id, float pitch) {
        MusicPitchApi.registerForStructure(id, l -> Float.valueOf(pitch));
    }

    public static void registerForStructureInside(class_2960 id, Function<Long, Float> pitchFunction) {
        MUSIC_PITCH_INFO_LIST.add(new MusicPitchInfo(MusicPitchDetectionType.STRUCTURE_INSIDE, id, pitchFunction));
    }

    public static void registerForStructureInside(class_2960 id, float pitch) {
        MusicPitchApi.registerForStructureInside(id, l -> Float.valueOf(pitch));
    }

    public static void registerForDimension(class_2960 id, Function<Long, Float> pitchFunction) {
        MUSIC_PITCH_INFO_LIST.add(new MusicPitchInfo(MusicPitchDetectionType.DIMENSION, id, pitchFunction));
    }

    public static void registerForDimension(class_2960 id, float pitch) {
        MusicPitchApi.registerForDimension(id, l -> Float.valueOf(pitch));
    }

    @ApiStatus.Internal
    public static void setCurrentPitch(float pitch) {
        CURRENT_PITCH = pitch;
    }

    @ApiStatus.Internal
    public static void resetCurrentPitch() {
        MusicPitchApi.setCurrentPitch(1.0f);
    }

    @ApiStatus.Internal
    public static float getCurrentPitch() {
        return CURRENT_PITCH;
    }

    @ApiStatus.Internal
    public static void updateTargetMusicPitch(class_1937 level, class_6880<class_1959> biome) {
        long gameTime = level.method_75260();
        ArrayList<Float> pitches = new ArrayList<Float>();
        int pitchContributors = 0;
        Optional<PlayerStructureStatus> optionalStructureStatus = ClientStructureStatuses.getProminentStructureStatus();
        for (MusicPitchInfo info : MUSIC_PITCH_INFO_LIST) {
            MusicPitchDetectionType type = info.type();
            if (type.isForStructure()) {
                if (optionalStructureStatus.isEmpty()) continue;
                PlayerStructureStatus structureStatus = optionalStructureStatus.get();
                class_2960 structureLocation = structureStatus.getStructure();
                boolean isInsidePiece = structureStatus.isInsidePiece();
                if (!type.isForStructureAndMatchesInside(isInsidePiece) || !info.id().equals((Object)structureLocation)) continue;
                pitches.add(info.pitchFunction().apply(gameTime));
                ++pitchContributors;
                continue;
            }
            if (type.isForBiome() && biome.method_40226(info.id())) {
                pitches.add(info.pitchFunction().apply(gameTime));
                ++pitchContributors;
                continue;
            }
            if (!type.isForDimension() || !level.method_27983().method_29177().equals((Object)info.id())) continue;
            pitches.add(info.pitchFunction().apply(gameTime));
            ++pitchContributors;
        }
        if (pitchContributors <= 0) {
            MusicPitchApi.resetCurrentPitch();
            return;
        }
        float totalPitches = 0.0f;
        Iterator iterator = pitches.iterator();
        while (iterator.hasNext()) {
            float suppliedPitch = ((Float)iterator.next()).floatValue();
            totalPitches += suppliedPitch - 1.0f;
        }
        MusicPitchApi.setCurrentPitch(1.0f + totalPitches / (float)pitchContributors);
    }

    @Generated
    private MusicPitchApi() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

