/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.networking;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.cape.api.CapeUtil;
import net.frozenblock.lib.cape.impl.ServerCapeData;
import net.frozenblock.lib.cape.impl.networking.CapeCustomizePacket;
import net.frozenblock.lib.cape.impl.networking.LoadCapeRepoPacket;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.frozenblock.lib.config.impl.network.ConfigSyncPacket;
import net.frozenblock.lib.event.api.PlayerJoinEvents;
import net.frozenblock.lib.file.transfer.FileTransferFilter;
import net.frozenblock.lib.file.transfer.FileTransferPacket;
import net.frozenblock.lib.file.transfer.FileTransferRebuilder;
import net.frozenblock.lib.item.impl.network.CooldownChangePacket;
import net.frozenblock.lib.item.impl.network.CooldownTickCountPacket;
import net.frozenblock.lib.item.impl.network.ForcedCooldownPacket;
import net.frozenblock.lib.screenshake.impl.network.EntityScreenShakePacket;
import net.frozenblock.lib.screenshake.impl.network.RemoveEntityScreenShakePacket;
import net.frozenblock.lib.screenshake.impl.network.RemoveScreenShakePacket;
import net.frozenblock.lib.screenshake.impl.network.ScreenShakePacket;
import net.frozenblock.lib.sound.impl.networking.FadingDistanceSwitchingSoundPacket;
import net.frozenblock.lib.sound.impl.networking.FlyBySoundPacket;
import net.frozenblock.lib.sound.impl.networking.LocalPlayerSoundPacket;
import net.frozenblock.lib.sound.impl.networking.LocalSoundPacket;
import net.frozenblock.lib.sound.impl.networking.MovingFadingDistanceSwitchingRestrictionSoundPacket;
import net.frozenblock.lib.sound.impl.networking.MovingRestrictionSoundPacket;
import net.frozenblock.lib.sound.impl.networking.RelativeMovingSoundPacket;
import net.frozenblock.lib.sound.impl.networking.StartingMovingRestrictionSoundLoopPacket;
import net.frozenblock.lib.spotting_icons.impl.SpottingIconPacket;
import net.frozenblock.lib.spotting_icons.impl.SpottingIconRemovePacket;
import net.frozenblock.lib.wind.api.WindManager;
import net.frozenblock.lib.wind.impl.networking.WindAccessPacket;
import net.frozenblock.lib.wind.impl.networking.WindDisturbancePacket;
import net.frozenblock.lib.wind.impl.networking.WindSyncPacket;
import net.frozenblock.lib.worldgen.structure.impl.status.networking.PlayerStructureStatusPacket;
import net.minecraft.class_1657;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_634;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.quiltmc.qsl.frozenblock.resource.loader.api.ResourceLoaderEvents;

public final class FrozenNetworking {
    public static void registerNetworking() {
        PayloadTypeRegistry registry = PayloadTypeRegistry.playS2C();
        PayloadTypeRegistry c2sRegistry = PayloadTypeRegistry.playC2S();
        PlayerJoinEvents.ON_PLAYER_ADDED_TO_LEVEL.register((server, serverLevel, player) -> {
            WindManager windManager = WindManager.getOrCreateWindManager(serverLevel);
            windManager.sendSyncToPlayer(windManager.createSyncPacket(), player);
            ServerCapeData.sendAllCapesToPlayer(player);
        });
        PlayerJoinEvents.ON_JOIN_SERVER.register((server, player) -> {
            ConfigSyncPacket.sendS2C(player);
            ServerCapeData.sendCapeReposToPlayer(player);
        });
        ResourceLoaderEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, error) -> {
            if (error != null || server == null) {
                return;
            }
            for (class_3222 player : PlayerLookup.all((MinecraftServer)server)) {
                ConfigSyncPacket.sendS2C(player);
            }
        });
        c2sRegistry.register(ConfigSyncPacket.PACKET_TYPE, ConfigSyncPacket.CODEC);
        registry.register(ConfigSyncPacket.PACKET_TYPE, ConfigSyncPacket.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ConfigSyncPacket.PACKET_TYPE, (packet, ctx) -> {
            if (ConfigSyncPacket.hasPermissionsToSendSync((class_1657)ctx.player(), true)) {
                ConfigSyncPacket.receive(packet, ctx.server());
            }
        });
        registry.register(LocalPlayerSoundPacket.PACKET_TYPE, LocalPlayerSoundPacket.CODEC);
        registry.register(LocalSoundPacket.PACKET_TYPE, LocalSoundPacket.CODEC);
        registry.register(RelativeMovingSoundPacket.PACKET_TYPE, RelativeMovingSoundPacket.CODEC);
        registry.register(StartingMovingRestrictionSoundLoopPacket.PACKET_TYPE, StartingMovingRestrictionSoundLoopPacket.CODEC);
        registry.register(MovingRestrictionSoundPacket.PACKET_TYPE, MovingRestrictionSoundPacket.CODEC);
        registry.register(FlyBySoundPacket.PACKET_TYPE, FlyBySoundPacket.CODEC);
        registry.register(FadingDistanceSwitchingSoundPacket.PACKET_TYPE, FadingDistanceSwitchingSoundPacket.CODEC);
        registry.register(MovingFadingDistanceSwitchingRestrictionSoundPacket.PACKET_TYPE, MovingFadingDistanceSwitchingRestrictionSoundPacket.CODEC);
        registry.register(CooldownChangePacket.PACKET_TYPE, CooldownChangePacket.CODEC);
        registry.register(ForcedCooldownPacket.PACKET_TYPE, ForcedCooldownPacket.CODEC);
        registry.register(CooldownTickCountPacket.PACKET_TYPE, CooldownTickCountPacket.CODEC);
        registry.register(ScreenShakePacket.PACKET_TYPE, ScreenShakePacket.CODEC);
        registry.register(EntityScreenShakePacket.PACKET_TYPE, EntityScreenShakePacket.CODEC);
        registry.register(RemoveScreenShakePacket.PACKET_TYPE, RemoveScreenShakePacket.CODEC);
        registry.register(RemoveEntityScreenShakePacket.PACKET_TYPE, RemoveEntityScreenShakePacket.CODEC);
        registry.register(SpottingIconPacket.PACKET_TYPE, SpottingIconPacket.CODEC);
        registry.register(SpottingIconRemovePacket.PACKET_TYPE, SpottingIconRemovePacket.CODEC);
        registry.register(WindSyncPacket.PACKET_TYPE, WindSyncPacket.CODEC);
        registry.register(WindDisturbancePacket.PACKET_TYPE, WindDisturbancePacket.CODEC);
        registry.register(PlayerStructureStatusPacket.PACKET_TYPE, PlayerStructureStatusPacket.CODEC);
        registry.register(CapeCustomizePacket.PACKET_TYPE, CapeCustomizePacket.CODEC);
        registry.register(LoadCapeRepoPacket.PACKET_TYPE, LoadCapeRepoPacket.STREAM_CODEC);
        c2sRegistry.register(CapeCustomizePacket.PACKET_TYPE, CapeCustomizePacket.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(CapeCustomizePacket.PACKET_TYPE, (packet, ctx) -> {
            UUID uuid = ctx.player().method_5667();
            class_2960 capeId = packet.getCapeId();
            if (capeId != null && !CapeUtil.canPlayerUserCape(uuid, capeId)) {
                return;
            }
            CapeCustomizePacket.sendCapeToAll(ctx.server(), uuid, capeId);
        });
        registry.register(FileTransferPacket.PACKET_TYPE, FileTransferPacket.STREAM_CODEC);
        c2sRegistry.register(FileTransferPacket.PACKET_TYPE, FileTransferPacket.STREAM_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(FileTransferPacket.PACKET_TYPE, (packet, ctx) -> {
            if (packet.request()) {
                String fileName;
                String requestPath = packet.transferPath();
                if (!FileTransferFilter.isRequestAcceptable(requestPath, fileName = packet.fileName(), ctx.player())) {
                    return;
                }
                File file = ctx.server().method_3831().resolve(requestPath).resolve(fileName).toFile();
                try {
                    for (FileTransferPacket fileTransferPacket : FileTransferPacket.create(requestPath, file)) {
                        ServerPlayNetworking.send((class_3222)ctx.player(), (class_8710)fileTransferPacket);
                    }
                }
                catch (IOException ignored) {
                    FrozenLibConstants.LOGGER.error("Unable to create and send transfer packets for file {} on server!", (Object)fileName);
                }
            } else {
                String fileName;
                if (!FrozenLibConfig.FILE_TRANSFER_SERVER) {
                    return;
                }
                String destPath = packet.transferPath().replace("/.local", "");
                if (!FileTransferFilter.isTransferAcceptable(destPath, fileName = packet.fileName(), ctx.player())) {
                    return;
                }
                try {
                    Path path = ctx.server().method_3831().resolve(destPath).resolve(packet.fileName());
                    FileTransferRebuilder.onReceiveFileTransferPacket(path, packet.snippet(), packet.totalPacketCount(), false);
                }
                catch (IOException ignored) {
                    FrozenLibConstants.LOGGER.error("Unable to save transferred file {} on server!", (Object)packet.fileName());
                }
            }
        });
        registry.register(WindAccessPacket.PACKET_TYPE, WindAccessPacket.STREAM_CODEC);
    }

    public static void sendPacketToAllPlayers(class_3218 level, class_8710 payload) {
        class_2658 packet = new class_2658(payload);
        for (class_3222 serverPlayer : level.method_18456()) {
            serverPlayer.field_13987.method_14364((class_2596)packet);
        }
    }

    public static boolean isLocalPlayer(class_1657 player) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return false;
        }
        return class_310.method_1551().method_52701(player.method_7334().id());
    }

    public static boolean connectedToIntegratedServer() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return false;
        }
        class_310 minecraft = class_310.method_1551();
        return minecraft.method_1496();
    }

    public static boolean connectedToServer() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return false;
        }
        class_310 minecraft = class_310.method_1551();
        class_634 listener = minecraft.method_1562();
        if (listener == null) {
            return false;
        }
        return listener.method_48296().method_10758();
    }

    public static boolean isMultiplayer() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return true;
        }
        return !class_310.method_1551().method_47392();
    }
}

