/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.resource_pack.impl.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.networking.FrozenClientNetworking;
import net.frozenblock.lib.resource_pack.api.client.FrozenLibModResourcePackApi;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class PackDownloadToast
implements class_368 {
    private static final class_2960 BACKGROUND_SPRITE = FrozenLibConstants.id("toast/resource_pack");
    private static final int MAX_LINE_SIZE = 200;
    private static final int LINE_SPACING = 12;
    private static final int MARGIN = 10;
    private static final int DOUBLE_MARGIN = 20;
    private static final int WIDTH_BUFFER = 30;
    private final PackDownloadToastId id;
    private class_2561 title;
    private final Optional<Supplier<class_2561>> bottomText;
    private final List<FrozenLibModResourcePackApi.PackDownloadStatusProvider> messageProviders = new ArrayList<FrozenLibModResourcePackApi.PackDownloadStatusProvider>();
    private final List<class_5481> messageLines = new ArrayList<class_5481>();
    private long lastChanged;
    private boolean changed;
    private int width = 230;
    private boolean forceHide;
    private class_368.class_369 wantedVisibility;

    public static PackDownloadToast create(PackDownloadToastId id, FrozenLibModResourcePackApi.PackDownloadStatusProvider statusProvider) {
        PackDownloadToast toast = new PackDownloadToast(id);
        toast.messageProviders.add(statusProvider);
        toast.updateTextAndWidth();
        return toast;
    }

    private PackDownloadToast(PackDownloadToastId id) {
        this.id = id;
        this.title = id.title;
        this.bottomText = id.bottomDisplay;
        this.wantedVisibility = class_368.class_369.field_2209;
    }

    private void updateTextAndWidth() {
        Stream<class_5481> messages = this.messageProviders.stream().map(provider -> provider.getComponent(this.id).method_30937());
        this.messageLines.clear();
        this.messageLines.addAll(messages.toList());
        this.bottomText.ifPresent(supplier -> this.messageLines.add(((class_2561)supplier.get()).method_30937()));
        class_327 font = class_310.method_1551().field_1772;
        ArrayList<Integer> allLines = new ArrayList<Integer>();
        allLines.add(30 + font.method_27525((class_5348)this.title));
        this.bottomText.ifPresent(supplier -> allLines.add(30 + font.method_27525((class_5348)supplier.get())));
        this.messageLines.forEach(line -> allLines.add(font.method_30880(line)));
        this.width = Math.max(200, allLines.stream().mapToInt(Integer::intValue).max().orElse(200));
    }

    public void appendStatusProvider(FrozenLibModResourcePackApi.PackDownloadStatusProvider provider) {
        if (this.messageProviders.contains(provider)) {
            return;
        }
        this.messageProviders.add(provider);
        this.updateTextAndWidth();
        this.setChanged();
    }

    public int method_29049() {
        return this.width;
    }

    public int method_29050() {
        return 20 + Math.max(this.messageLines.size(), 1) * 12;
    }

    public void forceHide() {
        this.forceHide = true;
    }

    public class_368.class_369 method_61988() {
        return this.wantedVisibility;
    }

    public void method_61989(class_374 toastManager, long time) {
        if (time % 100L == 0L) {
            this.updateTextAndWidth();
        }
        if (this.changed) {
            this.lastChanged = time;
            this.changed = false;
        }
        double displayTime = (double)this.id.displayTime * toastManager.method_48221();
        long timeSinceLastChanged = time - this.lastChanged;
        this.wantedVisibility = !this.forceHide && (double)timeSinceLastChanged < displayTime ? class_368.class_369.field_2210 : class_368.class_369.field_2209;
    }

    public void method_1986(class_332 guiGraphics, class_327 font, long l) {
        guiGraphics.method_52706(class_10799.field_56883, BACKGROUND_SPRITE, 0, 0, this.method_29049(), this.method_29050());
        if (this.messageLines.isEmpty()) {
            guiGraphics.method_51439(font, this.title, 15, 12, -256, false);
            return;
        }
        guiGraphics.method_51439(font, this.title, 15, 7, -256, false);
        for (int i = 0; i < this.messageLines.size(); ++i) {
            guiGraphics.method_51430(font, this.messageLines.get(i), 18, 18 + i * 12, -1, false);
        }
    }

    public void setChanged() {
        this.changed = true;
    }

    public PackDownloadToastId getToken() {
        return this.id;
    }

    public static void add(class_374 toastManager, PackDownloadToastId id, FrozenLibModResourcePackApi.PackDownloadStatusProvider statusProvider) {
        toastManager.method_1999((class_368)PackDownloadToast.create(id, statusProvider.getDirectProvider()));
    }

    public static void addOrAppendIfNotPresent(class_374 toastManager, PackDownloadToastId id, FrozenLibModResourcePackApi.PackDownloadStatusProvider statusProvider) {
        FrozenLibModResourcePackApi.PackDownloadStatusProvider directProvider = statusProvider.getDirectProvider();
        PackDownloadToast packToast = (PackDownloadToast)toastManager.method_1997(PackDownloadToast.class, (Object)id);
        if (packToast == null) {
            PackDownloadToast.add(toastManager, id, directProvider);
            return;
        }
        packToast.appendStatusProvider(directProvider);
    }

    public static void forceHide(class_374 toastManager, PackDownloadToastId id) {
        PackDownloadToast PackDownloadToast2 = (PackDownloadToast)toastManager.method_1997(PackDownloadToast.class, (Object)id);
        if (PackDownloadToast2 != null) {
            PackDownloadToast2.forceHide();
        }
    }

    public static class PackDownloadToastId {
        public static final PackDownloadToastId PACK_DOWNLOAD_SUCCESS = new PackDownloadToastId("download.success", () -> FrozenClientNetworking.notConnected() ? class_2561.method_43471((String)"frozenlib.resourcepack.download.open_menu") : class_2561.method_43471((String)"frozenlib.resourcepack.download.press_f3"));
        public static final PackDownloadToastId PACK_UPDATE_SUCCESS = new PackDownloadToastId("download.success.update", () -> FrozenClientNetworking.notConnected() ? class_2561.method_43471((String)"frozenlib.resourcepack.download.open_menu") : class_2561.method_43471((String)"frozenlib.resourcepack.download.press_f3"));
        public static final PackDownloadToastId PACK_DOWNLOAD_FAILURE = new PackDownloadToastId("download.failure");
        public static final PackDownloadToastId PACK_DOWNLOAD_FAILURE_PRESENT = new PackDownloadToastId("download.failure.present");
        public static final PackDownloadToastId PACK_DOWNLOAD_PRESENT = new PackDownloadToastId("download.present");
        private final long displayTime;
        private final class_2561 title;
        private final Optional<Supplier<class_2561>> bottomDisplay;

        public PackDownloadToastId(long displayTime, String title, Optional<Supplier<class_2561>> bottomDisplay) {
            this.displayTime = displayTime;
            this.title = class_2561.method_43471((String)("frozenlib.resourcepack." + title));
            this.bottomDisplay = bottomDisplay;
        }

        public class_2561 getTitle() {
            return this.title;
        }

        public Optional<class_2561> getBottomDisplay() {
            return this.bottomDisplay.map(Supplier::get);
        }

        public PackDownloadToastId(String title) {
            this(5000L, title, Optional.empty());
        }

        public PackDownloadToastId(String title, class_2561 component) {
            this(5000L, title, Optional.of(() -> component));
        }

        public PackDownloadToastId(String title, Supplier<class_2561> supplier) {
            this(5000L, title, Optional.of(supplier));
        }
    }
}

