/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.screenshake.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.frozenblock.lib.screenshake.api.ScreenShakeManager;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_3222;

public class EntityScreenShakeManager {
    private final ArrayList<EntityScreenShake> shakes = new ArrayList();
    public class_1297 entity;

    public EntityScreenShakeManager(class_1297 entity) {
        this.entity = entity;
    }

    public void load(class_11368 input) {
        this.shakes.clear();
        class_11368.class_11369 list = input.method_71437("frozenlib_screen_shakes", EntityScreenShake.CODEC);
        for (EntityScreenShake shake : list) {
            this.shakes.add(shake);
        }
    }

    public void save(class_11372 nbt) {
        if (this.shakes.isEmpty()) {
            return;
        }
        class_11372.class_11373 list = nbt.method_71467("frozenlib_screen_shakes", EntityScreenShake.CODEC);
        for (EntityScreenShake shake : this.shakes) {
            list.method_71484((Object)shake);
        }
    }

    public void addShake(float intensity, int duration, int durationFalloffStart, float maxDistance, int ticks) {
        this.shakes.add(new EntityScreenShake(intensity, duration, durationFalloffStart, maxDistance, ticks));
    }

    public void tick() {
        this.shakes.removeIf(EntityScreenShake::hasDurationExpired);
        for (EntityScreenShake entityScreenShake : this.shakes) {
            entityScreenShake.tick();
        }
    }

    public void syncWithPlayer(class_3222 serverPlayer) {
        for (EntityScreenShake nbt : this.getShakes()) {
            ScreenShakeManager.sendEntityScreenShakeTo(serverPlayer, this.entity, nbt.intensity, nbt.duration, nbt.durationFalloffStart, nbt.maxDistance, nbt.ticks);
        }
    }

    public ArrayList<EntityScreenShake> getShakes() {
        return this.shakes;
    }

    public static class EntityScreenShake {
        public static final Codec<EntityScreenShake> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("Intensity").forGetter(EntityScreenShake::intensity), (App)Codec.INT.fieldOf("Duration").forGetter(EntityScreenShake::duration), (App)Codec.INT.fieldOf("FalloffStart").forGetter(EntityScreenShake::durationFalloffStart), (App)Codec.FLOAT.fieldOf("MaxDistance").forGetter(EntityScreenShake::maxDistance), (App)Codec.INT.fieldOf("Ticks").forGetter(EntityScreenShake::ticks)).apply((Applicative)instance, EntityScreenShake::new));
        final float intensity;
        final int duration;
        final int durationFalloffStart;
        final float maxDistance;
        public int ticks;

        public EntityScreenShake(float intensity, int duration, int durationFalloffStart, float maxDistance, int ticks) {
            this.intensity = intensity;
            this.duration = duration;
            this.durationFalloffStart = durationFalloffStart;
            this.maxDistance = maxDistance;
            this.ticks = ticks;
        }

        public void tick() {
            ++this.ticks;
        }

        public float intensity() {
            return this.intensity;
        }

        public int duration() {
            return this.duration;
        }

        public int durationFalloffStart() {
            return this.durationFalloffStart;
        }

        public float maxDistance() {
            return this.maxDistance;
        }

        public int ticks() {
            return this.ticks;
        }

        public boolean hasDurationExpired() {
            return this.ticks > this.duration;
        }
    }
}

