/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data;

import net.frozenblock.lib.shadow.xjs.data.JsonString;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import org.jetbrains.annotations.Nullable;

public enum StringType {
    SINGLE,
    DOUBLE,
    MULTI,
    BACKTICK,
    IMPLICIT,
    NONE;


    public static StringType selectValue(String text) {
        for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\n': {
                    return MULTI;
                }
                case '\'': {
                    return DOUBLE;
                }
            }
        }
        return SINGLE;
    }

    public static StringType selectKey(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$') continue;
            return StringType.selectValue(text);
        }
        return IMPLICIT;
    }

    public static StringType fromValue(@Nullable JsonValue value) {
        if (value == null) {
            return NONE;
        }
        if (value instanceof JsonString) {
            return ((JsonString)value).getStringType();
        }
        return value.isPrimitive() ? IMPLICIT : NONE;
    }
}

