/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization;

import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.comments.CommentStyle;
import net.frozenblock.lib.shadow.xjs.data.serialization.parser.DjsParser;
import net.frozenblock.lib.shadow.xjs.data.serialization.parser.JsonParser;
import net.frozenblock.lib.shadow.xjs.data.serialization.parser.ParsingFunction;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.DjsTokenizer;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenizingFunction;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.DjsWriter;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.JsonWriter;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.JsonWriterOptions;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.WritingFunction;

public class JsonContext {
    private static final Map<String, ParsingFunction> PARSERS = new ConcurrentHashMap<String, ParsingFunction>();
    private static final Map<String, WritingFunction> WRITERS = new ConcurrentHashMap<String, WritingFunction>();
    private static final Map<String, TokenizingFunction> TOKENIZERS = new ConcurrentHashMap<String, TokenizingFunction>();
    private static final Map<String, String> ALIASES = new ConcurrentHashMap<String, String>();
    private static final ParsingFunction DEFAULT_PARSER = ParsingFunction.fromParser(DjsParser::new);
    private static final WritingFunction DEFAULT_WRITER = WritingFunction.fromWriter(DjsWriter::new);
    private static final TokenizingFunction DEFAULT_TOKENIZER = TokenizingFunction.fromTokenizer(DjsTokenizer::new);
    private static volatile String eol = System.lineSeparator();
    private static volatile CommentStyle defaultCommentStyle = CommentStyle.LINE;
    private static volatile JsonWriterOptions defaultFormatting = new JsonWriterOptions();
    public static final boolean COMPAT_AVAILABLE;
    public static final boolean TRANSFORM_AVAILABLE;

    public static void addParser(String format, ParsingFunction parser) {
        PARSERS.put(format.toLowerCase(), parser);
    }

    public static void addWriter(String format, WritingFunction writer) {
        WRITERS.put(format.toLowerCase(), writer);
    }

    public static void addTokenizer(String format, TokenizingFunction tokenizer) {
        TOKENIZERS.put(format.toLowerCase(), tokenizer);
    }

    public static void registerAlias(String alias, String format) {
        ALIASES.put(alias.toLowerCase(), format.toLowerCase());
    }

    public static synchronized String getEol() {
        return eol;
    }

    public static synchronized void setEol(String eol) {
        JsonContext.eol = eol;
    }

    public static synchronized CommentStyle getDefaultCommentStyle() {
        return defaultCommentStyle;
    }

    public static synchronized void setDefaultCommentStyle(CommentStyle style) {
        defaultCommentStyle = style;
    }

    public static synchronized JsonWriterOptions getDefaultFormatting() {
        return defaultFormatting;
    }

    public static synchronized void setDefaultFormatting(JsonWriterOptions options) {
        defaultFormatting = options;
    }

    public static ParsingFunction getDefaultParser() {
        return DEFAULT_PARSER;
    }

    public static WritingFunction getDefaultWriter() {
        return DEFAULT_WRITER;
    }

    public static boolean isKnownFormat(Path file) {
        return JsonContext.isKnownFormat(JsonContext.getFormat(file));
    }

    public static boolean isKnownFormat(String ext) {
        return PARSERS.containsKey(ext) || ALIASES.containsKey(ext);
    }

    public static JsonValue autoParse(Path file) throws IOException {
        return JsonContext.getParser(JsonContext.getFormat(file)).parse(file);
    }

    public static void autoWrite(Path file, JsonValue value) throws IOException {
        JsonContext.getWriter(JsonContext.getFormat(file)).write(file, value, defaultFormatting);
    }

    public static void autoWrite(Writer tw, String extension, JsonValue value) throws IOException {
        JsonContext.getWriter(extension).write(tw, value, defaultFormatting);
    }

    public static ParsingFunction getParser(String ext) {
        return PARSERS.getOrDefault(JsonContext.getFormat(ext), DEFAULT_PARSER);
    }

    public static WritingFunction getWriter(String ext) {
        return WRITERS.getOrDefault(JsonContext.getFormat(ext), DEFAULT_WRITER);
    }

    public static TokenizingFunction getTokenizer(String ext) {
        return TOKENIZERS.getOrDefault(JsonContext.getFormat(ext), DEFAULT_TOKENIZER);
    }

    public static String getFormat(Path file) {
        return JsonContext.getFormat(JsonContext.getExtension(file));
    }

    public static String getFormat(String ext) {
        ext = ext.toLowerCase();
        return ALIASES.getOrDefault(ext, ext);
    }

    private static String getExtension(Path file) {
        String filename = file.getFileName().toString();
        int index = filename.lastIndexOf(46);
        return index < 0 ? "djs" : filename.substring(index + 1);
    }

    private static boolean isClassAvailable(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    static {
        PARSERS.put("json", ParsingFunction.fromParser(JsonParser::new));
        PARSERS.put("djs", DEFAULT_PARSER);
        WRITERS.put("json", WritingFunction.fromWriter(JsonWriter::new));
        WRITERS.put("djs", DEFAULT_WRITER);
        ALIASES.put("xjs", "djs");
        COMPAT_AVAILABLE = JsonContext.isClassAvailable("net.frozenblock.lib.shadow.xjs.compat.serialization.XjsCompat");
        TRANSFORM_AVAILABLE = JsonContext.isClassAvailable("xjs.transform.JsonTransformer");
    }
}

