/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.sound.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.frozenblock.lib.sound.api.predicate.SoundPredicate;
import net.frozenblock.lib.sound.impl.networking.FrozenLibSoundPackets;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class MovingLoopingSoundEntityManager {
    private final ArrayList<SoundLoopData> sounds = new ArrayList();
    public class_1297 entity;

    public MovingLoopingSoundEntityManager(class_1297 entity) {
        this.entity = entity;
    }

    public void load(class_11368 input) {
        this.sounds.clear();
        class_11368.class_11369 list = input.method_71437("frozenlib_looping_sounds", SoundLoopData.CODEC);
        for (SoundLoopData sound : list) {
            this.sounds.add(sound);
        }
    }

    public void save(class_11372 output) {
        if (this.sounds.isEmpty()) {
            return;
        }
        class_11372.class_11373 list = output.method_71467("frozenlib_looping_sounds", SoundLoopData.CODEC);
        for (SoundLoopData sound : this.sounds) {
            list.method_71484((Object)sound);
        }
    }

    public void addSound(class_2960 soundID, class_3419 category, float volume, float pitch, class_2960 restrictionId, boolean stopOnDeath) {
        this.sounds.add(new SoundLoopData(soundID, category, volume, pitch, restrictionId, stopOnDeath));
        SoundPredicate.getPredicate(restrictionId).onStart(this.entity);
    }

    public List<SoundLoopData> getSounds() {
        return this.sounds;
    }

    public void tick() {
        if (this.sounds.isEmpty()) {
            return;
        }
        ArrayList<SoundLoopData> soundsToRemove = new ArrayList<SoundLoopData>();
        for (SoundLoopData nbt : this.sounds) {
            SoundPredicate.LoopPredicate<class_1297> predicate = SoundPredicate.getPredicate(nbt.restrictionID);
            if (predicate.test(this.entity)) continue;
            soundsToRemove.add(nbt);
            predicate.onStop(this.entity);
        }
        this.sounds.removeAll(soundsToRemove);
    }

    public void syncWithPlayer(class_3222 player) {
        for (SoundLoopData nbt : this.getSounds()) {
            FrozenLibSoundPackets.createAndSendMovingRestrictionLoopingSound(player, this.entity, (class_6880<class_3414>)((class_6880)class_7923.field_41172.method_10223(nbt.sound()).orElseThrow()), (class_3419)class_3419.valueOf(class_3419.class, (String)nbt.category()), nbt.volume, nbt.pitch, nbt.restrictionID, nbt.stopOnDeath);
        }
    }

    public record SoundLoopData(class_2960 sound, String category, float volume, float pitch, class_2960 restrictionID, boolean stopOnDeath) {
        public static final Codec<SoundLoopData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("sound").forGetter(SoundLoopData::sound), (App)Codec.STRING.fieldOf("categoryOrdinal").forGetter(SoundLoopData::category), (App)Codec.FLOAT.fieldOf("volume").forGetter(SoundLoopData::volume), (App)Codec.FLOAT.fieldOf("pitch").forGetter(SoundLoopData::pitch), (App)class_2960.field_25139.fieldOf("restrictionID").forGetter(SoundLoopData::restrictionID), (App)Codec.BOOL.fieldOf("stopOnDeath").forGetter(SoundLoopData::stopOnDeath)).apply((Applicative)instance, SoundLoopData::new));

        public SoundLoopData(class_2960 sound, class_3419 category, float volume, float pitch, class_2960 restrictionID, boolean stopOnDeath) {
            this(sound, category.toString(), volume, pitch, restrictionID, stopOnDeath);
        }
    }
}

